/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.NumberingStyle;
import org.zwobble.mammoth.internal.documents.Style;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementList;

public class StylesXml {
    public static Styles readStylesXmlElement(XmlElement element) {
        XmlElementList styleElements = element.findChildren("w:style");
        return new Styles(StylesXml.readStyles(styleElements, "paragraph"), StylesXml.readStyles(styleElements, "character"), StylesXml.readStyles(styleElements, "table"), StylesXml.readNumberingStyles(styleElements));
    }

    private static Map<String, Style> readStyles(XmlElementList styleElements, String styleType) {
        return Maps.toMap(StylesXml.styleElementsOfType(styleElements, styleType), StylesXml::readStyle);
    }

    private static Map.Entry<String, Style> readStyle(XmlElement element) {
        Optional<String> customStyleAttr;
        String styleId = StylesXml.readStyleId(element);
        Optional<String> styleName = element.findChildOrEmpty("w:name").getAttributeOrNone("w:val");
        Optional<String> parentStyleId = element.findChildOrEmpty("w:basedOn").getAttributeOrNone("w:val");
        if (StylesXml.isDefaultNormalParentStyleId(parentStyleId)) {
            parentStyleId = Optional.empty();
        }
        boolean isCustom = (customStyleAttr = element.getAttributeOrNone("w:customStyle")).isPresent() && ("true".equals(customStyleAttr.get()) || "1".equals(customStyleAttr.get()));
        return Maps.entry(styleId, new Style(styleId, styleName, parentStyleId, isCustom));
    }

    private static boolean isDefaultNormalParentStyleId(Optional<String> parentStyleId) {
        boolean isDefault = false;
        if (parentStyleId.isPresent()) {
            String style = parentStyleId.get();
            isDefault = "normal".equalsIgnoreCase(style) || "BodyText".equalsIgnoreCase(style) || "DefaultParagraphFont".equalsIgnoreCase(style);
        }
        return isDefault;
    }

    private static Map<String, NumberingStyle> readNumberingStyles(XmlElementList styleElements) {
        return Maps.toMap(StylesXml.styleElementsOfType(styleElements, "numbering"), StylesXml::readNumberingStyle);
    }

    private static Map.Entry<String, NumberingStyle> readNumberingStyle(XmlElement element) {
        String styleId = StylesXml.readStyleId(element);
        Optional<String> numId = element.findChildOrEmpty("w:pPr").findChildOrEmpty("w:numPr").findChildOrEmpty("w:numId").getAttributeOrNone("w:val");
        return Maps.entry(styleId, new NumberingStyle(numId));
    }

    private static String readStyleId(XmlElement element) {
        return element.getAttribute("w:styleId");
    }

    private static Iterable<XmlElement> styleElementsOfType(XmlElementList styleElements, String styleType) {
        return Iterables.lazyFilter(styleElements, styleElement -> StylesXml.isStyleType(styleElement, styleType));
    }

    private static boolean isStyleType(XmlElement styleElement, String styleType) {
        return styleElement.getAttribute("w:type").equals(styleType);
    }
}

