/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.List;
import java.util.Map;
import org.zwobble.mammoth.internal.docx.Relationship;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;

public class Relationships {
    public static final Relationships EMPTY = new Relationships(Lists.list());
    private final Map<String, String> targetsByRelationshipId;
    private final Map<String, List<String>> targetsByType;

    public Relationships(List<Relationship> relationships) {
        this.targetsByRelationshipId = Maps.toMap(relationships, relationship -> Maps.entry(relationship.getRelationshipId(), relationship.getTarget()));
        this.targetsByType = Maps.toMultiMap(relationships, relationship -> Maps.entry(relationship.getType(), relationship.getTarget()));
    }

    public String findTargetByRelationshipId(String relationshipId) {
        return Maps.lookup(this.targetsByRelationshipId, relationshipId).orElseThrow(() -> new RuntimeException("Could not find relationship '" + relationshipId + "'"));
    }

    public List<String> findTargetsByType(String type) {
        return Maps.lookup(this.targetsByType, type).orElse(Lists.list());
    }
}

