/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlNode;

public class BookmarkUtil {
    private static final String ID_ATTR = "w:id";
    private static final String BOOKMARK_START_EL = "w:bookmarkStart";
    private static final String BOOKMARK_END_EL = "w:bookmarkEnd";
    private static final String PARA_EL = "w:p";
    private static final String RUN_EL = "w:r";
    private static final String CELL_EL = "w:tc";
    private static final String ROW_EL = "w:tr";

    private BookmarkUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static List<XmlElement> getTableBookmarks(XmlElement table) {
        List<XmlElement> toRet = Collections.emptyList();
        List<XmlElement> startBookmarksForTable = BookmarkUtil.getStartBookmarksForTable(table);
        if (!(startBookmarksForTable = BookmarkUtil.filterColBookmarks(startBookmarksForTable)).isEmpty()) {
            List<String> endBookmarksForTable = BookmarkUtil.getEndBookmarksForTable(table);
            toRet = BookmarkUtil.extractMachingBookmark(startBookmarksForTable, endBookmarksForTable);
        }
        return toRet;
    }

    public static List<XmlElement> getTableRowBookmarks(XmlElement previewsRow, List<XmlElement> bookmarksStartBeforeRow, XmlElement targetRow, List<XmlNode> nextSiblings) {
        List<XmlElement> toRet = Collections.emptyList();
        List<XmlElement> startBookmarksForRow = BookmarkUtil.getStartBookmarksForTableRow(targetRow);
        startBookmarksForRow.addAll(bookmarksStartBeforeRow);
        if (previewsRow != null) {
            startBookmarksForRow.addAll(BookmarkUtil.getStartBookmarksForPreviewsRow(previewsRow));
        }
        if (!(startBookmarksForRow = BookmarkUtil.filterColBookmarks(startBookmarksForRow)).isEmpty()) {
            List<String> endBookmarksForTableRow = BookmarkUtil.getEndBookmarksForTableRow(targetRow);
            if (nextSiblings != null && !nextSiblings.isEmpty()) {
                endBookmarksForTableRow.addAll(BookmarkUtil.getEndBookmarksFromRowSiblings(nextSiblings));
            }
            toRet = BookmarkUtil.extractMachingBookmark(startBookmarksForRow, endBookmarksForTableRow);
        }
        return toRet;
    }

    private static List<XmlElement> filterColBookmarks(List<XmlElement> toFilter) {
        ArrayList<XmlElement> toRet = new ArrayList<XmlElement>();
        for (XmlElement xmlElement : toFilter) {
            Optional<String> colFirst = xmlElement.getAttributeOrNone("w:colFirst");
            Optional<String> colLast = xmlElement.getAttributeOrNone("w:colLast");
            if (colFirst.isPresent() || colLast.isPresent()) continue;
            toRet.add(xmlElement);
        }
        return toRet;
    }

    private static List<XmlElement> extractMachingBookmark(List<XmlElement> startBookmarks, List<String> endBookmarksIds) {
        ArrayList<XmlElement> toRet = new ArrayList<XmlElement>();
        if (!startBookmarks.isEmpty() && !endBookmarksIds.isEmpty()) {
            for (XmlElement bookmark : startBookmarks) {
                Optional<String> bookmarkId = bookmark.getAttributeOrNone(ID_ATTR);
                if (!bookmarkId.isPresent() || !endBookmarksIds.contains(bookmarkId.get())) continue;
                toRet.add(bookmark);
            }
        }
        return toRet;
    }

    private static List<XmlElement> getStartBookmarksForTable(XmlElement table) {
        ArrayList<XmlElement> toRet = new ArrayList<XmlElement>();
        XmlElement firstRow = BookmarkUtil.collectStartBookmarksUtilElement(table.getChildren(), ROW_EL, toRet);
        if (firstRow != null) {
            toRet.addAll(BookmarkUtil.getStartBookmarksForTableRow(firstRow));
        }
        return toRet;
    }

    private static List<String> getEndBookmarksForTable(XmlElement element) {
        ArrayList<String> toRet = new ArrayList<String>();
        XmlElement firstRow = BookmarkUtil.collectEndBookmarksUtilElementStartingFromTheEnd(element.getChildren(), ROW_EL, toRet);
        if (firstRow != null) {
            toRet.addAll(BookmarkUtil.getEndBookmarksForTableRow(firstRow));
        }
        return toRet;
    }

    private static List<XmlElement> getStartBookmarksForTableRow(XmlElement row) {
        XmlElement fistPara;
        ArrayList<XmlElement> toRet = new ArrayList<XmlElement>();
        XmlElement fistCell = BookmarkUtil.collectStartBookmarksUtilElement(row.getChildren(), CELL_EL, toRet);
        if (fistCell != null && (fistPara = BookmarkUtil.collectStartBookmarksUtilElement(fistCell.getChildren(), PARA_EL, toRet)) != null && fistPara.hasChild(RUN_EL)) {
            BookmarkUtil.collectStartBookmarksUtilElement(fistPara.getChildren(), RUN_EL, toRet);
        }
        return toRet;
    }

    private static List<String> getEndBookmarksForTableRow(XmlElement row) {
        XmlElement fistPara;
        ArrayList<String> toRet = new ArrayList<String>();
        XmlElement fistCell = BookmarkUtil.collectEndBookmarksUtilElementStartingFromTheEnd(row.getChildren(), CELL_EL, toRet);
        if (fistCell != null && (fistPara = BookmarkUtil.collectEndBookmarksUtilElementStartingFromTheEnd(fistCell.getChildren(), PARA_EL, toRet)) != null && fistPara.hasChild(RUN_EL)) {
            BookmarkUtil.collectEndBookmarksUtilElementStartingFromTheEnd(fistPara.getChildren(), RUN_EL, toRet);
        }
        return toRet;
    }

    private static List<XmlElement> getStartBookmarksForPreviewsRow(XmlElement previewsRow) {
        XmlElement lastpara;
        ArrayList<XmlElement> toRet = new ArrayList<XmlElement>();
        XmlElement lastCell = BookmarkUtil.collectStartBookmarksUtilElementStartingFromTheEnd(previewsRow.getChildren(), CELL_EL, toRet);
        if (lastCell != null && (lastpara = BookmarkUtil.collectStartBookmarksUtilElementStartingFromTheEnd(lastCell.getChildren(), PARA_EL, toRet)) != null && lastpara.hasChild(RUN_EL)) {
            BookmarkUtil.collectStartBookmarksUtilElementStartingFromTheEnd(lastpara.getChildren(), RUN_EL, toRet);
        }
        return toRet;
    }

    private static List<String> getEndBookmarksFromRowSiblings(List<XmlNode> nextSiblings) {
        XmlElement fistPara;
        XmlElement fistCell;
        ArrayList<String> toRet = new ArrayList<String>();
        XmlElement firstRow = BookmarkUtil.collectEndBookmarksUtilElement(nextSiblings, ROW_EL, toRet);
        if (firstRow != null && (fistCell = BookmarkUtil.collectEndBookmarksUtilElement(firstRow.getChildren(), CELL_EL, toRet)) != null && (fistPara = BookmarkUtil.collectEndBookmarksUtilElement(fistCell.getChildren(), PARA_EL, toRet)) != null && fistPara.hasChild(RUN_EL)) {
            BookmarkUtil.collectEndBookmarksUtilElement(fistPara.getChildren(), RUN_EL, toRet);
        }
        return toRet;
    }

    private static XmlElement collectStartBookmarksUtilElement(List<XmlNode> nodes, String stopElementName, List<XmlElement> collector) {
        XmlElement stopElement = null;
        for (XmlNode xmlNode : nodes) {
            if (!(xmlNode instanceof XmlElement)) continue;
            XmlElement currentEl = (XmlElement)xmlNode;
            String currentElName = currentEl.getName();
            if (stopElementName.equals(currentElName)) {
                stopElement = currentEl;
                break;
            }
            if (!BOOKMARK_START_EL.equals(currentElName)) continue;
            collector.add(currentEl);
        }
        return stopElement;
    }

    private static XmlElement collectEndBookmarksUtilElement(List<XmlNode> nodes, String stopElementName, List<String> collector) {
        XmlElement stopElement = null;
        for (XmlNode xmlNode : nodes) {
            Optional<String> bookmarkId;
            if (!(xmlNode instanceof XmlElement)) continue;
            XmlElement currentEl = (XmlElement)xmlNode;
            String currentElName = currentEl.getName();
            if (stopElementName.equals(currentElName)) {
                stopElement = currentEl;
                break;
            }
            if (!BOOKMARK_END_EL.equals(currentElName) || !(bookmarkId = currentEl.getAttributeOrNone(ID_ATTR)).isPresent()) continue;
            collector.add(bookmarkId.get());
        }
        return stopElement;
    }

    private static XmlElement collectStartBookmarksUtilElementStartingFromTheEnd(List<XmlNode> nodes, String stopElemementName, List<XmlElement> collector) {
        XmlElement stopElement = null;
        for (int i = nodes.size() - 1; i >= 0; --i) {
            XmlNode xmlNode = nodes.get(i);
            if (!(xmlNode instanceof XmlElement)) continue;
            XmlElement currentEl = (XmlElement)xmlNode;
            String currentElName = currentEl.getName();
            if (stopElemementName.equals(currentElName)) {
                stopElement = currentEl;
                break;
            }
            if (!BOOKMARK_START_EL.equals(currentElName)) continue;
            collector.add(currentEl);
        }
        return stopElement;
    }

    private static XmlElement collectEndBookmarksUtilElementStartingFromTheEnd(List<XmlNode> nodes, String stopElemementName, List<String> collector) {
        XmlElement stopElement = null;
        for (int i = nodes.size() - 1; i >= 0; --i) {
            Optional<String> bookmarkId;
            XmlNode xmlNode = nodes.get(i);
            if (!(xmlNode instanceof XmlElement)) continue;
            XmlElement currentEl = (XmlElement)xmlNode;
            String currentElName = currentEl.getName();
            if (stopElemementName.equals(currentElName)) {
                stopElement = currentEl;
                break;
            }
            if (!BOOKMARK_END_EL.equals(currentElName) || !(bookmarkId = currentEl.getAttributeOrNone(ID_ATTR)).isPresent()) continue;
            collector.add(bookmarkId.get());
        }
        return stopElement;
    }

    public static List<XmlElement> getUnprocessedBookmarks(List<XmlElement> allBookmarks, XmlElement processedBookmark) {
        Optional<String> processedId;
        List<XmlElement> toRet = null;
        if (processedBookmark != null && (processedId = processedBookmark.getAttributeOrNone(ID_ATTR)).isPresent()) {
            toRet = new ArrayList<XmlElement>();
            for (XmlElement bookmark : allBookmarks) {
                Optional<String> bookmarkId = bookmark.getAttributeOrNone(ID_ATTR);
                if (!bookmarkId.isPresent() || processedId.get().equals(bookmarkId.get())) continue;
                toRet.add(bookmark);
            }
        }
        if (toRet == null) {
            toRet = allBookmarks;
        }
        return toRet;
    }
}

