/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.documents;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;

public class IndexTerm
implements DocumentElement {
    private String mainEntry;
    private List<String> subEntries;
    private Optional<String> crossRefEntry;

    public IndexTerm(String entries, Optional<String> crossRefEntry) {
        this.mainEntry = entries;
        this.crossRefEntry = crossRefEntry;
        this.subEntries = Collections.emptyList();
        List<String> entriesList = Arrays.asList(entries.split(":"));
        if (entriesList.size() > 1) {
            this.mainEntry = entriesList.get(0);
            this.subEntries = entriesList.subList(1, entriesList.size());
        }
    }

    public String getMainEntry() {
        return this.mainEntry;
    }

    public List<String> getSubentries() {
        return this.subEntries;
    }

    public Optional<String> getCrossRefEntry() {
        return this.crossRefEntry;
    }

    @Override
    public <T, U> T accept(DocumentElementVisitor<T, U> visitor, U context) {
        return visitor.visit(this, context);
    }
}

