/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.conversion;

import java.util.List;
import org.zwobble.mammoth.internal.documents.Document;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Tab;
import org.zwobble.mammoth.internal.documents.Text;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;

public class RawText {
    public static String extractRawText(Document document) {
        return RawText.extractRawTextOfChildren(document);
    }

    private static String extractRawTextOfChildren(HasChildren parent) {
        return RawText.extractRawText(parent.getChildren());
    }

    private static String extractRawText(List<DocumentElement> nodes) {
        return String.join((CharSequence)"", Iterables.lazyMap(nodes, node -> RawText.extractRawText(node)));
    }

    public static String extractRawText(DocumentElement node) {
        if (node instanceof Text) {
            return ((Text)node).getValue();
        }
        if (node instanceof Tab) {
            return "\t";
        }
        List<DocumentElement> children = Casts.tryCast(HasChildren.class, node).map(HasChildren::getChildren).orElse(Lists.list());
        String suffix = Casts.tryCast(Paragraph.class, node).map(paragraph -> "\n\n").orElse("");
        return RawText.extractRawText(children) + suffix;
    }
}

