/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.zwobble.mammoth.internal.archives.Archive;
import org.zwobble.mammoth.internal.archives.InMemoryArchive;
import org.zwobble.mammoth.internal.archives.ZippedArchive;
import org.zwobble.mammoth.internal.conversion.DocumentToHtml;
import org.zwobble.mammoth.internal.conversion.DocumentToHtmlOptions;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Text;
import org.zwobble.mammoth.internal.docx.DocumentReader;
import org.zwobble.mammoth.internal.docx.EmbeddedStyleMap;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.html.Html;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.styles.parsing.StyleMapParser;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.PassThroughException;

public class InternalDocumentConverter {
    private final DocumentToHtmlOptions options;

    public InternalDocumentConverter(DocumentToHtmlOptions options) {
        this.options = options;
    }

    public InternalResult<String> convertToHtml(InputStream stream) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(stream, (Archive zipFile) -> this.convertToHtml(Optional.empty(), (Archive)zipFile)));
    }

    public InternalResult<String> convertToHtml(File file) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(file, (Archive zipFile) -> this.convertToHtml(Optional.of(file.toPath()), (Archive)zipFile)));
    }

    private InternalResult<String> convertToHtml(Optional<Path> path, Archive zipFile) {
        DocumentReader.PartPaths partPaths = DocumentReader.findPartPaths(zipFile);
        Styles styles = DocumentReader.readStyles(zipFile, partPaths);
        Optional<StyleMap> styleMap = this.readEmbeddedStyleMap(zipFile).map(StyleMapParser::parse);
        DocumentToHtmlOptions conversionOptions = styleMap.map(this.options::addEmbeddedStyleMap).orElse(this.options);
        return DocumentReader.readDocument(path, Optional.of(styles), zipFile).flatMap(nodes -> DocumentToHtml.convertToHtml(nodes, conversionOptions, styles)).map(Html::stripEmpty).map(Html::collapse).map(Html::write);
    }

    private Optional<String> readEmbeddedStyleMap(Archive zipFile) {
        return PassThroughException.wrap(() -> EmbeddedStyleMap.readStyleMap(zipFile));
    }

    public InternalResult<String> extractRawText(InputStream stream) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(stream, (Archive zipFile) -> this.extractRawText(Optional.empty(), (Archive)zipFile)));
    }

    public InternalResult<String> extractRawText(File file) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(file, (Archive zipFile) -> this.extractRawText(Optional.of(file.toPath()), (Archive)zipFile)));
    }

    private InternalResult<String> extractRawText(Optional<Path> path, Archive zipFile) {
        return DocumentReader.readDocument(path, Optional.empty(), zipFile).map(InternalDocumentConverter::extractRawTextOfChildren);
    }

    private static <T> T withDocxFile(File file, Function<Archive, T> function) throws IOException {
        try (ZippedArchive zipFile = new ZippedArchive(file);){
            T t = function.apply(zipFile);
            return t;
        }
    }

    private static <T> T withDocxFile(InputStream stream, Function<Archive, T> function) throws IOException {
        try (InMemoryArchive zipFile = InMemoryArchive.fromStream(stream);){
            T t = function.apply(zipFile);
            return t;
        }
    }

    private static String extractRawTextOfChildren(HasChildren parent) {
        return InternalDocumentConverter.extractRawText(parent.getChildren());
    }

    private static String extractRawText(List<DocumentElement> nodes) {
        return String.join((CharSequence)"", Iterables.lazyMap(nodes, node -> InternalDocumentConverter.extractRawText(node)));
    }

    private static String extractRawText(DocumentElement node) {
        return Casts.tryCast(Text.class, node).map(Text::getValue).orElseGet(() -> {
            List<DocumentElement> children = Casts.tryCast(HasChildren.class, node).map(HasChildren::getChildren).orElse(Lists.list());
            String suffix = Casts.tryCast(Paragraph.class, node).map(paragraph -> "\n\n").orElse("");
            return InternalDocumentConverter.extractRawText(children) + suffix;
        });
    }
}

