/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.binding;

import com.oxygenxml.publishing.template.binding.CloneUtil;
import com.oxygenxml.publishing.template.binding.Pattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class TemplateFileset {
    @XmlElement(name="include", namespace="")
    private List<Pattern> includePatternList;
    @XmlElement(name="exclude", namespace="")
    private List<Pattern> excludePatternList;
    @XmlAnyElement(lax=true)
    public Object[] others;

    public TemplateFileset() {
    }

    public TemplateFileset(TemplateFileset source) {
        this.includePatternList = CloneUtil.copyPatternList(source.includePatternList);
        this.excludePatternList = CloneUtil.copyPatternList(source.excludePatternList);
        if (source.others != null) {
            this.others = Arrays.copyOf(source.others, source.others.length);
        }
    }

    public List<Pattern> getIncludePatterns() {
        return this.includePatternList;
    }

    public List<Pattern> getExcludePatterns() {
        return this.excludePatternList;
    }

    public void addIncludePattern(Pattern includePattern) {
        if (this.includePatternList == null) {
            this.includePatternList = new ArrayList<Pattern>();
        }
        this.includePatternList.add(includePattern);
    }

    public void addExcludePattern(Pattern excludePattern) {
        if (this.includePatternList == null) {
            this.includePatternList = new ArrayList<Pattern>();
        }
        this.includePatternList.add(excludePattern);
    }

    public String toString() {
        return String.format("TemplateFileset [includePatternList=%s, excludePatternList=%s]", this.includePatternList, this.excludePatternList);
    }
}

