/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template;

import com.oxygenxml.publishing.template.AntLicenseValidationHandler;
import com.oxygenxml.publishing.template.AntPropertiesProvider;
import com.oxygenxml.publishing.template.PublishingTemplateBuilder;
import com.oxygenxml.publishing.template.PublishingTemplateLoadException;
import com.oxygenxml.publishing.template.PublishingTemplateUtil;
import com.oxygenxml.publishing.template.TemplateValidationListener;
import com.oxygenxml.publishing.template.binding.BuildProject;
import com.oxygenxml.publishing.template.binding.CSSFile;
import com.oxygenxml.publishing.template.binding.FaviconFile;
import com.oxygenxml.publishing.template.binding.HTMLFragment;
import com.oxygenxml.publishing.template.binding.HTMLPageTemplate;
import com.oxygenxml.publishing.template.binding.JsModule;
import com.oxygenxml.publishing.template.binding.LogoFile;
import com.oxygenxml.publishing.template.binding.PDFTemplateInfo;
import com.oxygenxml.publishing.template.binding.Parameter;
import com.oxygenxml.publishing.template.binding.PublishingTemplate;
import com.oxygenxml.publishing.template.binding.TemplateFileset;
import com.oxygenxml.publishing.template.binding.WebHelpResources;
import com.oxygenxml.publishing.template.binding.WebHelpTemplateInfo;
import com.oxygenxml.publishing.template.binding.XSLTExtensionPoint;
import com.oxygenxml.publishing.template.binding.catalog.XMLCatalog;
import com.oxygenxml.publishing.template.fragment.HTMLFragmentFileInfo;
import com.oxygenxml.publishing.template.fragment.HtmlFragmentConverter;
import com.oxygenxml.publishing.template.fragment.HtmlFragmentUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.licensemanager.base.LicenseCheckerWithOxygenParent;
import ro.sync.licensemanager.webhelp.WebHelpLicenseChecker;

public class PublishingTemplateTask
extends Task {
    private static final String HTML_FRAGMENT_PROPETY_LOG = "''{0}'' -> {1}";
    private static final Logger logger = LoggerFactory.getLogger((String)PublishingTemplateTask.class.getName());
    private static final String PUBLISHING_LICENSE_FILENAME = "licensekey.txt";
    public static final String ANT_PROPERTY_COPY_RESOURCES_ANT_FILE_PATH = "webhelp.copy.resources.ant.file.path";
    private static final String ANT_PROPERTY_CSS_SKIN_PATH = "webhelp.responsive.custom.template.skin.relpath";
    static final String ANT_PROPERTY_PDF_CSS_SKIN_PATH = "template.css.list";
    private static final String ANT_PROPERTY_LOGO_FILE_PATH = "webhelp.logo.image";
    private static final String ANT_PROPERTY_LOGO_ALT_TEXT = "webhelp.logo.image.alt";
    private static final String ANT_PROPERTY_TRIAL_LICENSE = "webhelp.trial.license";
    private static final String ANT_PROPERTY_LOGO_TARGET_URL = "webhelp.logo.image.target.url";
    private static final String ANT_PROPERTY_LOGO_TARGET_URL_NEW_TAB = "webhelp.logo.image.target.url.new.tab";
    private static final String ANT_PROPERTY_FAVICON_FILE_PATH = "webhelp.favicon";
    private static final String ANT_PROPERTY_JS_MODULE_REL_PATH = "webhelp.js.module.rel.path";
    private static final String ANT_PROPERTY_XSL_EXTENSIONS_CATALOG_FILE_PATH = "xsl.extensions.xml.catalog.file.path";
    private static final String OUTPUT_TEMPLATE_FOLDER = "oxygen-webhelp" + File.separator + "template";
    static final String TRANSTYPE_PDF_CSS = "pdf-css";
    static final String TRANSTYPE_WEBHELP = "webhelp-responsive";
    private static final String PROPERTY_FIX_EXTERNAL_REFERENCES = "fix.external.refs.com.oxygenxml";
    static final List<String> WH_PROPERTIES_AS_SYSTEM_PROPS = new ArrayList<String>();
    private String transtype;
    private String tempDir;
    private File tempFileFolder;
    private String outputDir;
    private String initialTemplateRootPath;
    File initialTemplateRootFile;
    File templateRootFile;
    private String templateDescriptor;
    PublishingTemplate publishingTemplate;
    File copyResourcesAntFile;
    private Project antProject;
    File xslExtensionsCatalogFile;
    private String defaultXMLCatalogURL;
    private static final int BUFFER_SIZE = 4096;
    static final String PUBLISHING_TEMPLATE_TEMP_FOLDER_NAME = "publishing-template";
    private String pluginDirPath;
    private HtmlFragmentConverter htmlFragmentProcessor;

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setTemplateRootPath(String templateFilePath) {
        this.initialTemplateRootPath = templateFilePath;
    }

    public void setTemplateDescriptor(String templateDescriptor) {
        this.templateDescriptor = templateDescriptor;
    }

    public void setDefaultXMLCatalog(String defaultXMLCatalog) {
        this.defaultXMLCatalogURL = defaultXMLCatalog;
    }

    public void setTranstype(String transtype) {
        this.transtype = transtype;
    }

    public void execute() {
        try {
            this.antProject = this.getProject();
            this.checkLicense();
            this.loadWebHelpTemplateDescriptor();
            if (TRANSTYPE_WEBHELP.equals(this.transtype)) {
                AntPropertiesProvider propertiesProvider = name -> Optional.ofNullable(name).map(this::getWebHelpParameter);
                this.htmlFragmentProcessor = new HtmlFragmentConverter(propertiesProvider, (arg_0, arg_1) -> ((PublishingTemplateTask)this).log(arg_0, arg_1), this.tempFileFolder);
                this.writeWebHelpCopyResourcesAntFile();
                this.processExistingAntHtmlFragmentsProperties();
                this.writeWebHelpResourcesAntProperties();
                this.writeWebHelpHTMLPageTemplatesProperties();
                this.writeWebHelpANTProperties();
                this.writeWebhelpHTMLFragmentsProperties();
                this.writeWebHelpXSLTExtensionsCatalog();
            } else if (TRANSTYPE_PDF_CSS.equals(this.transtype) && this.publishingTemplate != null && this.publishingTemplate.getPDFTemplateInfo() != null) {
                this.writePDFCSSANTProperties();
                this.writePDFANTProperties();
                this.writePDFXSLTExtensionsCatalog();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String getWebHelpParameter(String name) {
        return Optional.ofNullable(this.antProject).map(proj -> proj.getProperty(name)).orElse(this.getWebHelpOPTParameter(name));
    }

    private String getWebHelpOPTParameter(String name) {
        List paramsList = Optional.ofNullable(this.publishingTemplate).map(PublishingTemplate::getWebhelpTemplateInfo).map(WebHelpTemplateInfo::getParamsList).orElse(Collections.emptyList());
        Parameter param = paramsList.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
        String value = null;
        if (param != null) {
            value = param.getValue();
            if ("filePath".equals(param.getType())) {
                File res = new File(this.templateRootFile, value);
                value = res.getAbsolutePath();
            }
        }
        return value;
    }

    private void processExistingAntHtmlFragmentsProperties() {
        Hashtable properties;
        if (this.antProject != null && (properties = this.antProject.getProperties()) != null) {
            properties.entrySet().stream().filter(e -> HtmlFragmentUtil.isHtmlFragmentParameter((String)e.getKey())).forEach(e -> {
                HTMLFragmentFileInfo fragmentInfo = this.htmlFragmentProcessor.processHtmlFragmentParameter((String)e.getKey(), String.valueOf(e.getValue()));
                if (fragmentInfo != null) {
                    this.log(MessageFormat.format(HTML_FRAGMENT_PROPETY_LOG, fragmentInfo.getFragmentId(), fragmentInfo.getAbsolutePath()));
                    String fragmentFileAbsolutePath = fragmentInfo.getAbsolutePath();
                    this.antProject.setUserProperty(fragmentInfo.getFragmentId(), fragmentFileAbsolutePath);
                }
            });
        }
    }

    private void writePDFCSSANTProperties() {
        if (this.antProject != null && this.publishingTemplate.getPDFTemplateInfo() != null) {
            StringBuilder sb = new StringBuilder();
            List<CSSFile> cssFiles = this.publishingTemplate.getPDFTemplateInfo().getCssFiles();
            if (cssFiles != null) {
                Iterator<CSSFile> iterator = cssFiles.iterator();
                while (iterator.hasNext()) {
                    CSSFile cssFile = iterator.next();
                    String relPath = cssFile.getFilePath();
                    try {
                        File cssF = new File(this.templateRootFile, relPath);
                        sb.append(cssF.toURI().toURL());
                        if (!iterator.hasNext()) continue;
                        sb.append(";");
                    }
                    catch (MalformedURLException e) {
                        logger.warn("Error when convert file to URL: " + e.getMessage());
                    }
                }
            }
            this.setANTProperty(ANT_PROPERTY_PDF_CSS_SKIN_PATH, sb.toString());
        }
    }

    private void checkLicense() {
        AntLicenseValidationHandler validationHandler = new AntLicenseValidationHandler(this.antProject);
        if (this.pluginDirPath != null) {
            String invalidLicenseMsg = this.getInvalidLicenseMessage();
            if (TRANSTYPE_WEBHELP.equals(this.transtype)) {
                WebHelpLicenseChecker whLicenseChecker = new WebHelpLicenseChecker((LicenseCheckerWithOxygenParent.LicenseValidationHandler)validationHandler, this.pluginDirPath, PUBLISHING_LICENSE_FILENAME, invalidLicenseMsg);
                whLicenseChecker.checkLicense();
                if (whLicenseChecker.isTrial()) {
                    this.setANTProperty(ANT_PROPERTY_TRIAL_LICENSE, "yes");
                }
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("The \"pluginDir\" was not specified. You need to set the path of the base directory of the plugin that invoked this task.\n");
            sb.append("This directory is used to search for the Oxygen WebHelp");
            sb.append(" license key file.");
            String errorMessage = sb.toString();
            this.log(errorMessage);
            throw new BuildException(errorMessage);
        }
    }

    private String getInvalidLicenseMessage() {
        String ditaOtDirPath = this.getDitaOtDirPath();
        String msg = MessageFormat.format("Cannot find a valid \"{0}\" license file in:\n- the DITA-OT directory: \"{1}\"\n- the plugin base directory: \"{2}\"\n\nPlease place your Oxygen WebHelp or Oxygen Publishing Engine license key in a file called \"{3}\" and copy it to one of the above locations.\n\nIf you do not have a license key or you need more details, please contact sales@oxygenxml.com.\n", PUBLISHING_LICENSE_FILENAME, ditaOtDirPath, this.pluginDirPath, PUBLISHING_LICENSE_FILENAME);
        return msg;
    }

    private String getDitaOtDirPath() {
        String ditaOtDirPath = null;
        if (this.pluginDirPath != null) {
            try {
                File ditaOtDir;
                File pluginDir = new File(this.pluginDirPath).getCanonicalFile();
                File ditaOtPluginsDir = pluginDir.getParentFile();
                if (ditaOtPluginsDir != null && (ditaOtDir = ditaOtPluginsDir.getParentFile()) != null) {
                    ditaOtDirPath = ditaOtDir.getAbsolutePath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ditaOtDirPath == null) {
            ditaOtDirPath = "[DITA-OT-DIRECTORY]";
        }
        return ditaOtDirPath;
    }

    protected String getAntProperty(Project antProject, String prop) {
        String val = null;
        if (antProject != null) {
            val = antProject.getProperty(prop);
        }
        return val;
    }

    private void writeWebhelpHTMLFragmentsProperties() {
        List<HTMLFragment> htmlFragments;
        if (this.antProject != null && (htmlFragments = this.publishingTemplate.getWebhelpTemplateInfo().getHTMLFragments()) != null) {
            this.log("Settig ANT properties for custom HTML fragments...");
            for (HTMLFragment htmlFragment : htmlFragments) {
                File htmlFragFile = new File(this.publishingTemplate.getPackageRoot(), htmlFragment.getFilePath());
                HTMLFragmentFileInfo fragmentInfo = this.htmlFragmentProcessor.processFileFragment(htmlFragment.getPlaceholder(), htmlFragFile);
                this.log(MessageFormat.format(HTML_FRAGMENT_PROPETY_LOG, fragmentInfo.getFragmentId(), fragmentInfo.getAbsolutePath()));
                this.setANTProperty(fragmentInfo.getFragmentId(), fragmentInfo.getAbsolutePath());
            }
        }
    }

    private void writeWebHelpANTProperties() {
        List<Parameter> paramsList;
        if (this.antProject != null && (paramsList = this.publishingTemplate.getWebhelpTemplateInfo().getParamsList()) != null) {
            for (Parameter parameter : paramsList) {
                HTMLFragmentFileInfo fragmentInfo;
                String value = parameter.getValue();
                String paramName = parameter.getName();
                boolean isHtmlFragmentParameter = HtmlFragmentUtil.isHtmlFragmentParameter(paramName);
                if ("filePath".equals(parameter.getType())) {
                    File res = new File(this.templateRootFile, value);
                    if (!res.exists()) {
                        this.log(MessageFormat.format("The resource referenced by the ''{0}'' property does not exists: {1}", parameter.getName(), value), LogLevel.WARN.getLevel());
                    }
                    if (isHtmlFragmentParameter) {
                        HTMLFragmentFileInfo fragmentInfo2 = this.htmlFragmentProcessor.processFileFragment(paramName, res);
                        this.log(MessageFormat.format(HTML_FRAGMENT_PROPETY_LOG, fragmentInfo2.getFragmentId(), fragmentInfo2.getAbsolutePath()));
                        value = fragmentInfo2.getAbsolutePath();
                    } else {
                        value = res.getAbsolutePath();
                    }
                } else if (isHtmlFragmentParameter && (fragmentInfo = this.htmlFragmentProcessor.processHtmlFragmentParameter(paramName, value)) != null) {
                    this.log(MessageFormat.format(HTML_FRAGMENT_PROPETY_LOG, fragmentInfo.getFragmentId(), fragmentInfo.getAbsolutePath()));
                    value = fragmentInfo.getAbsolutePath();
                }
                this.setANTProperty(paramName, value);
            }
        }
    }

    private void writeWebHelpResourcesAntProperties() {
        if (this.antProject != null) {
            JsModule scriptFile;
            FaviconFile faviconFile;
            List<CSSFile> cssFiles = this.publishingTemplate.getWebhelpTemplateInfo().getWebhelpResources().getCssFiles();
            StringBuilder sb = new StringBuilder();
            Iterator<CSSFile> iterator = cssFiles.iterator();
            while (iterator.hasNext()) {
                CSSFile cssFile = iterator.next();
                sb.append(cssFile.getFilePath());
                if (!iterator.hasNext()) continue;
                sb.append(";");
            }
            this.setANTProperty(ANT_PROPERTY_CSS_SKIN_PATH, sb.toString());
            WebHelpResources webhelpResources = this.publishingTemplate.getWebhelpTemplateInfo().getWebhelpResources();
            LogoFile logoFile = webhelpResources.getLogoFile();
            if (logoFile != null) {
                this.setANTProperty(ANT_PROPERTY_LOGO_FILE_PATH, OUTPUT_TEMPLATE_FOLDER + File.separator + logoFile.getFilePath());
                if (logoFile.getTargetURL() != null && logoFile.getTargetURL().trim().length() > 0) {
                    this.setANTProperty(ANT_PROPERTY_LOGO_TARGET_URL, logoFile.getTargetURL());
                }
                if (logoFile.getInNewTab()) {
                    this.setANTProperty(ANT_PROPERTY_LOGO_TARGET_URL_NEW_TAB, "yes");
                }
                if (logoFile.getAlt() != null && logoFile.getAlt().trim().length() > 0) {
                    this.setANTProperty(ANT_PROPERTY_LOGO_ALT_TEXT, logoFile.getAlt());
                }
            }
            if ((faviconFile = webhelpResources.getFaviconFile()) != null) {
                this.setANTProperty(ANT_PROPERTY_FAVICON_FILE_PATH, OUTPUT_TEMPLATE_FOLDER + File.separator + faviconFile.getFilePath());
            }
            if ((scriptFile = webhelpResources.getJsModule()) != null) {
                this.setANTProperty(ANT_PROPERTY_JS_MODULE_REL_PATH, scriptFile.getFilePath());
            }
        }
    }

    private void writeWebHelpHTMLPageTemplatesProperties() {
        if (this.antProject != null && this.publishingTemplate.getWebhelpTemplateInfo().hasPageTemplates()) {
            HTMLPageTemplate pageTemplate = this.publishingTemplate.getWebhelpTemplateInfo().getHTMLPageTemplate("main");
            File ptFile = new File(this.publishingTemplate.getPackageRoot(), pageTemplate.getFilePath());
            this.antProject.setNewProperty("webhelp.template.index.file", ptFile.getAbsolutePath());
            pageTemplate = this.publishingTemplate.getWebhelpTemplateInfo().getHTMLPageTemplate("topic");
            ptFile = new File(this.publishingTemplate.getPackageRoot(), pageTemplate.getFilePath());
            this.antProject.setNewProperty("webhelp.template.file.path", ptFile.getAbsolutePath());
            pageTemplate = this.publishingTemplate.getWebhelpTemplateInfo().getHTMLPageTemplate("search");
            ptFile = new File(this.publishingTemplate.getPackageRoot(), pageTemplate.getFilePath());
            this.antProject.setNewProperty("webhelp.template.search.file", ptFile.getAbsolutePath());
            pageTemplate = this.publishingTemplate.getWebhelpTemplateInfo().getHTMLPageTemplate("index-terms");
            ptFile = new File(this.publishingTemplate.getPackageRoot(), pageTemplate.getFilePath());
            this.antProject.setNewProperty("webhelp.template.index.terms.file", ptFile.getAbsolutePath());
        }
    }

    void writeWebHelpCopyResourcesAntFile() {
        String outDirAbsolutePath = new File(this.outputDir).getAbsolutePath();
        BuildProject buildProject = new BuildProject(this.templateRootFile.getAbsolutePath(), outDirAbsolutePath, OUTPUT_TEMPLATE_FOLDER);
        WebHelpTemplateInfo webhelpTemplateInfo = this.publishingTemplate.getWebhelpTemplateInfo();
        if (webhelpTemplateInfo != null) {
            List<TemplateFileset> fileSets;
            JsModule scriptFile;
            LogoFile logoFile;
            WebHelpResources webhelpResources = webhelpTemplateInfo.getWebhelpResources();
            List<CSSFile> cssFiles = webhelpResources.getCssFiles();
            for (CSSFile cssF : cssFiles) {
                buildProject.addFileResource(cssF.getFilePath());
            }
            FaviconFile faviconFile = webhelpResources.getFaviconFile();
            if (faviconFile != null) {
                buildProject.addFileResource(faviconFile.getFilePath());
            }
            if ((logoFile = webhelpResources.getLogoFile()) != null) {
                buildProject.addFileResource(logoFile.getFilePath());
            }
            if ((scriptFile = webhelpResources.getJsModule()) != null) {
                buildProject.addFileResource(scriptFile.getFilePath());
            }
            if ((fileSets = webhelpResources.getFileSets()) != null) {
                buildProject.addFilesetList(fileSets);
            }
        }
        try {
            this.copyResourcesAntFile = new File(this.tempFileFolder, "wh-template-copy-resources.xml");
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{BuildProject.class});
            Marshaller marshaller = contextObj.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)buildProject, this.copyResourcesAntFile);
            if (this.antProject != null) {
                this.setANTProperty(ANT_PROPERTY_COPY_RESOURCES_ANT_FILE_PATH, this.copyResourcesAntFile.getAbsolutePath());
            }
        }
        catch (JAXBException e) {
            logger.error("Cannot write copy resources ANT file. Reason: " + e, (Throwable)e);
            throw new BuildException("Cannot write copy resources ANT file. Reason: " + e);
        }
    }

    void loadWebHelpTemplateDescriptor() {
        this.initialTemplateRootFile = new File(this.initialTemplateRootPath);
        if (!this.initialTemplateRootFile.exists()) {
            if (TRANSTYPE_WEBHELP.equals(this.transtype)) {
                throw new BuildException("The publishing template package does not exist. Resource is: " + this.initialTemplateRootFile.getAbsolutePath());
            }
            return;
        }
        if (this.tempDir == null) {
            throw new BuildException("The transformation temporary folder should be specified.");
        }
        this.tempFileFolder = new File(this.tempDir);
        this.tempFileFolder.mkdirs();
        this.unpackPublishingTemplate();
        try {
            TemplateValidationListener validationListener = new TemplateValidationListener(true);
            PublishingTemplateBuilder publishingTemplateBuilder = new PublishingTemplateBuilder(validationListener);
            this.log("Loading publishing template from descriptor: " + this.templateRootFile.getAbsolutePath());
            this.publishingTemplate = publishingTemplateBuilder.loadWebHelpPublishingTemplate(this.templateRootFile, this.templateDescriptor);
            this.templateRootFile = this.publishingTemplate.getPackageRoot();
            List<String> errors = validationListener.getErrors();
            List<String> warnings = validationListener.getWarnings();
            if (!errors.isEmpty() || !warnings.isEmpty()) {
                this.log("The publishing template is not valid. The next problems were detected.", LogLevel.ERR.getLevel());
                for (String warn : warnings) {
                    this.log(warn, LogLevel.ERR.getLevel());
                }
                String lastError = null;
                for (String err : errors) {
                    this.log(err, LogLevel.ERR.getLevel());
                    lastError = err;
                }
                if (lastError != null) {
                    throw new BuildException(lastError);
                }
            }
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
        catch (PublishingTemplateLoadException e) {
            this.log(e.getMessage());
            this.log("Please open the template descriptor in editor and correct the validation errors.");
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void unpackPublishingTemplate() {
        boolean zipTemplate = false;
        try (ZipFile ptZipFile = new ZipFile(this.initialTemplateRootFile);){
            zipTemplate = true;
            this.templateRootFile = new File(this.tempFileFolder, PUBLISHING_TEMPLATE_TEMP_FOLDER_NAME);
            if (!this.templateRootFile.exists() && !this.templateRootFile.mkdirs()) {
                throw new BuildException("Cannot create ' publishing-template' folder in the transformation temporary folder to unzip the publishing template.");
            }
            try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(this.initialTemplateRootFile));){
                File possibleTemplateRoot;
                File[] listFiles;
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    File zipEntryFile = new File(this.templateRootFile, entry.getName());
                    if (!entry.isDirectory()) {
                        this.extractZipEntry(zipIn, zipEntryFile);
                    } else {
                        zipEntryFile.mkdir();
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
                String descrFromFolder = PublishingTemplateUtil.detectTemplateDescriptorFromFolder(this.templateRootFile);
                if (descrFromFolder == null && (listFiles = this.templateRootFile.listFiles()) != null && listFiles.length > 0 && listFiles[0].isDirectory() && (descrFromFolder = PublishingTemplateUtil.detectTemplateDescriptorFromFolder(possibleTemplateRoot = listFiles[0])) != null) {
                    this.templateRootFile = possibleTemplateRoot;
                }
            }
            catch (IOException e) {
                this.log("Error when extracting ZIP entry: " + e.getMessage(), e, LogLevel.DEBUG.getLevel());
                throw new BuildException("Error when extracting ZIP entry: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            this.log("The publishing template package is not an archive.", LogLevel.DEBUG.getLevel());
        }
        if (!zipTemplate) {
            this.templateRootFile = this.initialTemplateRootFile;
        }
    }

    private void extractZipEntry(ZipInputStream zipIn, File destFile) throws IOException {
        destFile.getParentFile().mkdirs();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    void writeWebHelpXSLTExtensionsCatalog() {
        WebHelpTemplateInfo webhelpTemplateInfo = this.publishingTemplate.getWebhelpTemplateInfo();
        if (webhelpTemplateInfo != null) {
            this.writeXSLTExtensionsCatalog(webhelpTemplateInfo.getXSLTExtensionPoints());
        }
    }

    void writePDFXSLTExtensionsCatalog() {
        PDFTemplateInfo pdfTemplateInfo = this.publishingTemplate.getPDFTemplateInfo();
        if (pdfTemplateInfo != null) {
            this.writeXSLTExtensionsCatalog(pdfTemplateInfo.getXSLTExtensionPoints());
        }
    }

    private void writeXSLTExtensionsCatalog(List<XSLTExtensionPoint> xsltExtensionPoints) {
        if (xsltExtensionPoints != null && !xsltExtensionPoints.isEmpty()) {
            XMLCatalog xmlCatalog = new XMLCatalog(this.defaultXMLCatalogURL);
            for (XSLTExtensionPoint xsltExtensionPoint : xsltExtensionPoints) {
                File xsltFile = new File(this.publishingTemplate.getPackageRoot(), xsltExtensionPoint.getFilePath());
                xmlCatalog.addURIEntry(xsltExtensionPoint.getExtensionPointID(), new File(xsltFile.getAbsolutePath()).toURI().toString());
            }
            try {
                this.tempFileFolder.mkdirs();
                this.xslExtensionsCatalogFile = new File(this.tempFileFolder, "template-xsl-extensions-catalog.xml");
                JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{XMLCatalog.class});
                this.log("Write XML catalog for XSLT extension points in: " + this.xslExtensionsCatalogFile.getAbsolutePath(), LogLevel.INFO.getLevel());
                Marshaller marshaller = contextObj.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)xmlCatalog, this.xslExtensionsCatalogFile);
                if (this.antProject != null) {
                    this.setANTProperty(ANT_PROPERTY_XSL_EXTENSIONS_CATALOG_FILE_PATH, this.xslExtensionsCatalogFile.getAbsolutePath());
                }
            }
            catch (JAXBException e) {
                logger.error("Cannot write XML catalog for XSLT extensions. Reason: " + e, (Throwable)e);
                throw new BuildException("Cannot write XML catalog for XSLT extensions. Reason: " + e);
            }
        }
    }

    public void setPluginDir(String pluginDirPath) {
        this.pluginDirPath = pluginDirPath;
    }

    private void setANTProperty(String propName, String propValue) {
        if (this.antProject != null) {
            this.log("Set ANT property: '" + propName + "' -> " + propValue, LogLevel.INFO.getLevel());
            if (propName != null) {
                propName = propName.trim();
            }
            if (propValue != null) {
                propValue = propValue.trim();
            }
            this.antProject.setNewProperty(propName, propValue);
            if (WH_PROPERTIES_AS_SYSTEM_PROPS.contains(propName)) {
                System.setProperty(propName, propValue);
            }
        }
    }

    private void writePDFANTProperties() {
        List<Parameter> paramsList;
        if (this.antProject != null && this.publishingTemplate.getPDFTemplateInfo() != null && (paramsList = this.publishingTemplate.getPDFTemplateInfo().getParamsList()) != null) {
            for (Parameter parameter : paramsList) {
                String value = parameter.getValue();
                if ("filePath".equals(parameter.getType())) {
                    File res = new File(this.templateRootFile, value);
                    if (!res.exists()) {
                        this.log("The resource referenced by the '" + parameter.getName() + "' property does not exists: " + value, LogLevel.WARN.getLevel());
                    }
                    value = res.getAbsolutePath();
                }
                this.setANTProperty(parameter.getName(), value);
            }
        }
    }

    static {
        WH_PROPERTIES_AS_SYSTEM_PROPS.add(PROPERTY_FIX_EXTERNAL_REFERENCES);
    }
}

