/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

final class SandboxCore {
    private static final ConfirmInfrastructure CONFIRM_INFRASTRUCTURE = new ConfirmInfrastructure();

    private SandboxCore() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static boolean shouldAsk(ConfirmInfrastructure.Type opType) {
        return CONFIRM_INFRASTRUCTURE.shouldAsk(opType, Thread.currentThread());
    }

    static String getMessage(ConfirmInfrastructure.Type opType) {
        return CONFIRM_INFRASTRUCTURE.getMessage(opType, Thread.currentThread());
    }

    static String getConfirmationMessage(ConfirmInfrastructure.Type opType, String param) {
        return CONFIRM_INFRASTRUCTURE.getConfirmationMessage(opType, Thread.currentThread(), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T runWithConfirmation(ConfirmInfrastructure.Type type, String message, PrivilegedAction<T> action) {
        Thread currentThread = Thread.currentThread();
        CONFIRM_INFRASTRUCTURE.push(type, message, currentThread);
        try {
            T t = action.run();
            return t;
        }
        finally {
            CONFIRM_INFRASTRUCTURE.pop(type, currentThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T runWithConfirmation(ConfirmInfrastructure.Type type, String message, PrivilegedExceptionAction<T> action) throws Exception {
        Thread currentThread = Thread.currentThread();
        CONFIRM_INFRASTRUCTURE.push(type, message, currentThread);
        try {
            T t = action.run();
            return t;
        }
        finally {
            CONFIRM_INFRASTRUCTURE.pop(type, currentThread);
        }
    }

    static final class ConfirmInfrastructure {
        private final Map<Type, Map<Thread, LinkedList<String>>> tmts = new EnumMap<Type, Map<Thread, LinkedList<String>>>(Type.class);

        private ConfirmInfrastructure() {
            for (Type type : Type.values()) {
                this.tmts.put(type, new HashMap());
            }
        }

        private boolean shouldAsk(Type opType, Thread currentThread) {
            LinkedList<String> stack = this.tmts.get((Object)opType).get(currentThread);
            return stack != null && stack.peek() != null;
        }

        private String getMessage(Type opType, Thread currentThread) {
            LinkedList<String> stack = this.tmts.get((Object)opType).get(currentThread);
            return stack == null ? null : stack.peek();
        }

        private String getConfirmationMessage(Type opType, Thread currentThread, String param) {
            String message = this.getMessage(opType, currentThread);
            if (message == null) {
                message = "The application tried to connect to {0}.";
            }
            message = MessageFormat.format(message, param, param);
            String startMarker = "<<";
            String endMarker = ">>";
            if (message != null && message.startsWith("<<")) {
                int start = "<<".length();
                int end = message.length() - 1;
                if (message.endsWith(">>")) {
                    end = message.lastIndexOf(">>");
                }
                throw new AccessControlException(message.substring(start, end));
            }
            return message;
        }

        private synchronized void push(Type opType, String message, Thread currentThread) {
            this.tmts.get((Object)opType).computeIfAbsent(currentThread, currentThreadKey -> new LinkedList()).push(message);
        }

        private synchronized void pop(Type opType, Thread currentThread) {
            Map<Thread, LinkedList<String>> ttc = this.tmts.get((Object)opType);
            LinkedList<String> stack = ttc.get(currentThread);
            if (stack != null) {
                stack.pop();
                if (stack.isEmpty()) {
                    ttc.remove(currentThread);
                }
            }
        }

        static enum Type {
            CONNECT,
            WRITE,
            THREAD;

        }
    }
}

