/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.security.ConnectionsSandbox;
import ro.sync.security.DefaultPermissionsFactory;
import ro.sync.security.FilesSandbox;
import ro.sync.security.ThreadsSandbox;

public final class Sandbox {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Sandbox.class.getName());
    private static ThreadLocal<Integer> restrictedContext = ThreadLocal.withInitial(() -> 0);

    public static void additionalCheckConnect(String host, int port) {
        ConnectionsSandbox.additionalCheckConnect(host, port);
    }

    public static void additionalCheckWrite(String file) {
        FilesSandbox.additionalCheckWrite(file);
    }

    public static void additionalCheckThread(ThreadGroup group) {
        ThreadsSandbox.additionalCheckThread(group);
    }

    public static void additionalCheckURL(String urlStr, boolean alwaysAskConfirmation) {
        ConnectionsSandbox.additionalCheckURL(urlStr, alwaysAskConfirmation);
    }

    private static AccessControlContext createAllPermsContext() {
        AllPermissionCollection allPermissionCollection = new AllPermissionCollection();
        allPermissionCollection.add(new AllPermission());
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), allPermissionCollection);
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    public static <T> T runWithAllPerms(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return AccessController.doPrivileged(action, Sandbox.createAllPermsContext());
    }

    public static <T> T runWithNoPerms(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null);
        AccessControlContext context = new AccessControlContext(new ProtectionDomain[]{domain});
        return Sandbox.runInContext(action, context);
    }

    public static <T> T runWithPerms(PrivilegedExceptionAction<T> action, PermissionCollection perms) throws PrivilegedActionException {
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        AccessControlContext context = new AccessControlContext(new ProtectionDomain[]{domain});
        return Sandbox.runInContext(action, context);
    }

    public static <T> T runWithPerms(long flags, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        AccessController.doPrivileged(() -> {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new SecurityPermission("*"));
            }
            return null;
        });
        Permissions perms = Sandbox.getPermissionsFromFlags(flags);
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        AccessControlContext context = new AccessControlContext(new ProtectionDomain[]{domain});
        LOGGER.debug("Running with protection domain: {}", (Object)domain);
        return Sandbox.runInContext(action, context);
    }

    private static Permissions getPermissionsFromFlags(long flags) {
        return DefaultPermissionsFactory.getPermissionsFromFlags(flags, 1L, 512L, 1024L, 2L, 128L, 4L, 8L, 16L, 32L, 256L, 4096L, 64L, 2048L);
    }

    public static <T> T runWithAllPerms(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action, Sandbox.createAllPermsContext());
    }

    public static <T> T runWithPerms(long flags, PrivilegedAction<T> action) {
        Permissions perms = Sandbox.getPermissionsFromFlags(flags);
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        AccessControlContext context = new AccessControlContext(new ProtectionDomain[]{domain});
        return Sandbox.runInContext(action, context);
    }

    public static <T> T runWithConnectConfirmation(String message, PrivilegedExceptionAction<T> action) throws Exception {
        return ConnectionsSandbox.runWithConnectConfirmation(message, action);
    }

    public static <T> T runWithConnectConfirmation(String message, PrivilegedAction<T> action) {
        return ConnectionsSandbox.runWithConnectConfirmation(message, action);
    }

    public static <T> T runInSafeConnectContext(PrivilegedExceptionAction<T> action) throws Exception {
        return ConnectionsSandbox.runInSafeConnectContext(action);
    }

    public static <T> T runInSafeConnectContext(PrivilegedAction<T> action) {
        return ConnectionsSandbox.runInSafeConnectContext(action);
    }

    public static <T> T runWithWriteConfirmation(String message, PrivilegedExceptionAction<T> action) throws Exception {
        return FilesSandbox.runWithWriteConfirmation(message, action);
    }

    public static <T> T runWithThreadConfirmation(String message, PrivilegedExceptionAction<T> action) throws Exception {
        return ThreadsSandbox.runWithThreadConfirmation(message, action);
    }

    private Sandbox() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static <T> T runInContext(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        Sandbox.increaseRestrictedContextCounter();
        try {
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            Sandbox.decreaseRestrictedContextCounter();
        }
    }

    private static <T> T runInContext(PrivilegedAction<T> action, AccessControlContext context) {
        Sandbox.increaseRestrictedContextCounter();
        try {
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            Sandbox.decreaseRestrictedContextCounter();
        }
    }

    private static void increaseRestrictedContextCounter() {
        Sandbox.runWithAllPerms(() -> {
            restrictedContext.set(restrictedContext.get() + 1);
            return null;
        });
    }

    private static void decreaseRestrictedContextCounter() {
        Sandbox.runWithAllPerms(() -> {
            restrictedContext.set(Math.max(0, restrictedContext.get() - 1));
            return null;
        });
    }

    public static boolean inRestrictedContext() {
        return Sandbox.runWithAllPerms(() -> {
            Integer counter = restrictedContext == null ? 0 : restrictedContext.get();
            return counter > 0;
        });
    }

    static final class AllPermissionCollection
    extends PermissionCollection {
        private boolean all_allowed = false;
        private AllPermission allPerms = new AllPermission();

        @Override
        public void add(Permission permission) {
            if (!(permission instanceof AllPermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            this.all_allowed = true;
        }

        @Override
        public boolean implies(Permission permission) {
            return this.all_allowed;
        }

        @Override
        public Enumeration<Permission> elements() {
            return new Enumeration<Permission>(){
                private boolean hasMore;
                {
                    this.hasMore = all_allowed;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.hasMore;
                }

                @Override
                public Permission nextElement() {
                    this.hasMore = false;
                    return allPerms;
                }
            };
        }
    }
}

