/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

public final class PermissionFlags {
    public static final long PERM_READ_FILES = 1L;
    public static final long PERM_READ_PROPERTIES = 2L;
    public static final long PERM_READ_ENVIRONMENT = 4L;
    public static final long PERM_GENERIC_READ = 7L;
    public static final long PERM_SET_CONTEXT_CLASSLOADER = 8L;
    public static final long PERM_CREATE_CLASSLOADER = 16L;
    public static final long PERM_GET_CLASSLOADER = 32L;
    public static final long PERM_ALL = 64L;
    public static final long PERM_WRITE_PROPERTIES = 128L;
    public static final long PERM_SOCKET = 256L;
    public static final long PERM_WRITE_FILES = 512L;
    public static final long PERM_DELETE_FILES = 1024L;
    public static final long PERM_URL_CONNECT = 2048L;
    public static final long PERM_MODIFY_THREAD = 4096L;

    private PermissionFlags() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static boolean isPermissionFlagSet(long flags, long flagToCheck) {
        return (flags & flagToCheck) != 0L;
    }

    public static boolean hasReadFilesPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 1L);
    }

    public static boolean hasWriteFilesPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 512L);
    }

    public static boolean hasDeleteFilesPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 1024L);
    }

    public static boolean hasReadPropertiesPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 2L);
    }

    public static boolean hasWritePropertiesPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 128L);
    }

    public static boolean hasReadEnvironmentPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 4L);
    }

    public static boolean hasSetContextClassLoaderPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 8L);
    }

    public static boolean hasCreateClassLoaderPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 16L);
    }

    public static boolean hasGetClassLoaderPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 32L);
    }

    public static boolean hasSocketPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 256L);
    }

    public static boolean hasModifyThreadPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 4096L);
    }

    public static boolean hasAllPermissions(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 64L);
    }

    public static boolean hasURLConnectPermission(long flags) {
        return PermissionFlags.isPermissionFlagSet(flags, 2048L);
    }
}

