/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import ro.sync.security.SandboxCore;
import ro.sync.security.SecurityChecker;
import ro.sync.security.UntrustedFileException;

public final class FilesSandbox {
    private FilesSandbox() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static boolean shouldAskForWrite() {
        return SandboxCore.shouldAsk(SandboxCore.ConfirmInfrastructure.Type.WRITE);
    }

    public static void additionalCheckWrite(String file) {
        AccessController.doPrivileged(() -> {
            if (FilesSandbox.shouldAskForWrite()) {
                try {
                    SecurityChecker.getInstance().verifyFile(file, SandboxCore.getConfirmationMessage(SandboxCore.ConfirmInfrastructure.Type.WRITE, file));
                }
                catch (UntrustedFileException ex) {
                    throw new AccessControlException(ex.getMessage());
                }
            }
            return null;
        });
    }

    public static <T> T runWithWriteConfirmation(String message, PrivilegedExceptionAction<T> action) throws Exception {
        return SandboxCore.runWithConfirmation(SandboxCore.ConfirmInfrastructure.Type.WRITE, message, action);
    }
}

