/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ro.sync.basic.util.URLUtil;
import ro.sync.security.SandboxCore;
import ro.sync.security.SecurityChecker;
import ro.sync.security.UntrustedHostException;

public class ConnectionsSandbox {
    private static final String SAFE_CONNECT_CONFIRMATION_MARKER = "SAFE_CONNECT_CONFIRMATION_MARKER";
    private static final Map<Thread, Integer> THREADS_IN_RESOLVE = new ConcurrentHashMap<Thread, Integer>();
    private static final Map<String, String> IP_TO_HOST_MAP = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void countThread() {
        Map<Thread, Integer> map = THREADS_IN_RESOLVE;
        synchronized (map) {
            THREADS_IN_RESOLVE.compute(Thread.currentThread(), (currentThreadKey, threadCount) -> threadCount == null ? 1 : threadCount + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uncountThread() {
        Map<Thread, Integer> map = THREADS_IN_RESOLVE;
        synchronized (map) {
            Thread currentThread = Thread.currentThread();
            Integer count = THREADS_IN_RESOLVE.get(currentThread) - 1;
            if (count == 0) {
                THREADS_IN_RESOLVE.remove(currentThread);
            } else {
                THREADS_IN_RESOLVE.put(currentThread, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateReverse(String host) {
        block7: {
            ConnectionsSandbox.countThread();
            try {
                InetSocketAddress isa = new InetSocketAddress(host, 0);
                InetAddress address = isa.getAddress();
                if (address == null) break block7;
                byte[] adr = address.getAddress();
                StringBuilder sb = new StringBuilder();
                for (byte b : adr) {
                    sb.append(b);
                    sb.append('.');
                }
                Map<String, String> map = IP_TO_HOST_MAP;
                synchronized (map) {
                    IP_TO_HOST_MAP.put(sb.substring(0, sb.length() - 1), host);
                }
            }
            finally {
                ConnectionsSandbox.uncountThread();
            }
        }
    }

    private static UrlConnectionContext getUrlConnectionContext() {
        String msg = SandboxCore.getMessage(SandboxCore.ConfirmInfrastructure.Type.CONNECT);
        UrlConnectionContext urlConContext = null;
        urlConContext = SAFE_CONNECT_CONFIRMATION_MARKER.equals(msg) ? UrlConnectionContext.SAFE : (msg != null ? UrlConnectionContext.SANDBOXED : UrlConnectionContext.OTHER);
        return urlConContext;
    }

    static boolean shouldAskForConnect() {
        return ConnectionsSandbox.getUrlConnectionContext() == UrlConnectionContext.SANDBOXED;
    }

    public static void additionalCheckConnect(String host, int port) {
        if (!THREADS_IN_RESOLVE.containsKey(Thread.currentThread())) {
            AccessController.doPrivileged(() -> {
                if (port == -1) {
                    ConnectionsSandbox.updateReverse(host);
                } else if (ConnectionsSandbox.shouldAskForConnect()) {
                    String aHost = host;
                    String resolved = IP_TO_HOST_MAP.get(host);
                    if (resolved != null) {
                        aHost = resolved;
                    }
                    String hostName = aHost + ":" + port;
                    try {
                        SecurityChecker.getInstance().verifyHost(hostName, SandboxCore.getConfirmationMessage(SandboxCore.ConfirmInfrastructure.Type.CONNECT, hostName), true);
                    }
                    catch (UntrustedHostException ex) {
                        throw new AccessControlException(ex.getMessage(hostName));
                    }
                }
                return null;
            });
        }
    }

    public static void additionalCheckURL(String urlStr, boolean alwaysAskConfirmation) {
        AccessController.doPrivileged(() -> {
            UrlConnectionContext connectionContext = ConnectionsSandbox.getUrlConnectionContext();
            if (connectionContext != UrlConnectionContext.SAFE) {
                try {
                    boolean isSandboxed;
                    boolean bl = isSandboxed = connectionContext == UrlConnectionContext.SANDBOXED;
                    if (isSandboxed || alwaysAskConfirmation) {
                        String hostName = URLUtil.getHostnameAndPort((String)urlStr);
                        SecurityChecker.getInstance().verifyHost(hostName, SandboxCore.getConfirmationMessage(SandboxCore.ConfirmInfrastructure.Type.CONNECT, urlStr), isSandboxed);
                    }
                }
                catch (MalformedURLException e) {
                    throw new AccessControlException("Cannot check URL " + urlStr);
                }
                catch (UntrustedHostException ex) {
                    throw new AccessControlException(ex.getMessage(urlStr));
                }
            }
            return null;
        });
    }

    public static <T> T runWithConnectConfirmation(String message, PrivilegedAction<T> action) {
        return SandboxCore.runWithConfirmation(SandboxCore.ConfirmInfrastructure.Type.CONNECT, message, action);
    }

    public static <T> T runWithConnectConfirmation(String message, PrivilegedExceptionAction<T> action) throws Exception {
        return SandboxCore.runWithConfirmation(SandboxCore.ConfirmInfrastructure.Type.CONNECT, message, action);
    }

    public static <T> T runInSafeConnectContext(PrivilegedAction<T> action) {
        return SandboxCore.runWithConfirmation(SandboxCore.ConfirmInfrastructure.Type.CONNECT, SAFE_CONNECT_CONFIRMATION_MARKER, action);
    }

    public static <T> T runInSafeConnectContext(PrivilegedExceptionAction<T> action) throws Exception {
        return SandboxCore.runWithConfirmation(SandboxCore.ConfirmInfrastructure.Type.CONNECT, SAFE_CONNECT_CONFIRMATION_MARKER, action);
    }

    private static enum UrlConnectionContext {
        SAFE,
        SANDBOXED,
        OTHER;

    }
}

