/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.GlyfTable;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.render.pdf.pdfbox.FontContainer;
import org.apache.fop.render.pdf.pdfbox.MaximumProfileTable;
import org.apache.fop.render.pdf.pdfbox.MergeFonts;

public class MergeTTFonts
extends TTFSubSetFile
implements MergeFonts {
    private Map<Integer, Glyph> added = new TreeMap<Integer, Glyph>();
    private int origIndexesLen;
    private int size;
    protected MaximumProfileTable maxp = new MaximumProfileTable();
    private Integer nhmtxDiff = null;
    private List<Cmap> cmap;
    private Set<Integer> composedGlyphs = Collections.emptySet();
    private Set<Integer> compositeGlyphs = Collections.emptySet();

    public MergeTTFonts(List<Cmap> cmap) {
        this.cmap = cmap;
    }

    private void readGlyf(Map<Integer, Integer> glyphs, FontFileReader in) throws IOException {
        OFDirTabEntry entry = (OFDirTabEntry)this.dirTabs.get(OFTableName.GLYF);
        if (entry != null) {
            int[] origIndexes = this.buildSubsetIndexToOrigIndexMap(glyphs);
            for (int i = 0; i < origIndexes.length; ++i) {
                int glyphOffset;
                int nextOffset = 0;
                int origGlyphIndex = origIndexes[i];
                nextOffset = origGlyphIndex >= this.mtxTab.length - 1 ? (int)this.lastLoca : (int)this.mtxTab[origGlyphIndex + 1].getOffset();
                int glyphLength = nextOffset - (glyphOffset = (int)this.mtxTab[origGlyphIndex].getOffset());
                if (glyphLength < 0) continue;
                byte[] glyphData = in.getBytes((int)entry.getOffset() + glyphOffset, glyphLength);
                Glyph g = new Glyph(glyphData, this.mtxTab[origGlyphIndex], this.composedGlyphs.contains(origGlyphIndex), this.compositeGlyphs.contains(origGlyphIndex), origGlyphIndex);
                if (!this.cid && (this.origIndexesLen == 0 || glyphLength > 0 && i > 0)) {
                    this.added.put(i, g);
                    continue;
                }
                if (!this.cid) continue;
                this.added.put(i + this.origIndexesLen, g);
            }
            this.origIndexesLen = !this.cid ? origIndexes.length : (this.origIndexesLen += origIndexes.length);
        } else {
            throw new IOException("Can't find glyf table");
        }
    }

    private void createGlyf() throws IOException {
        OFDirTabEntry entry = (OFDirTabEntry)this.dirTabs.get(OFTableName.GLYF);
        int size = 0;
        int startPos = 0;
        int endOffset = 0;
        if (entry != null) {
            this.pad4();
            startPos = this.currentPos;
            this.glyphOffsets = new int[this.origIndexesLen];
            for (Map.Entry<Integer, Glyph> gly : this.added.entrySet()) {
                byte[] glyphData = gly.getValue().data;
                int glyphLength = glyphData.length;
                int i = gly.getKey();
                if (i >= this.origIndexesLen) continue;
                int endOffset1 = endOffset;
                this.writeBytes(glyphData);
                if (this.cid || this.locaFormat == 1) {
                    this.writeULong(this.locaOffset + i * 4, this.currentPos - startPos);
                }
                if (this.currentPos - startPos + glyphLength > endOffset1) {
                    endOffset1 = this.currentPos - startPos + glyphLength;
                }
                this.glyphOffsets[i] = this.currentPos;
                this.currentPos += glyphLength;
                this.realSize += glyphLength;
                endOffset = endOffset1;
            }
            size = this.currentPos - startPos;
            this.currentPos += 12;
            this.realSize += 12;
            this.updateCheckSum(startPos, size + 12, OFTableName.GLYF);
            if (this.cid || this.locaFormat == 1) {
                this.writeULong(this.locaOffset + this.added.size() * 4, endOffset);
            }
            int locaSize = this.added.size() * 4 + 4;
            int checksum = MergeTTFonts.getCheckSum((byte[])this.output, (int)this.locaOffset, (int)locaSize);
            this.writeULong((Integer)this.offsets.get(OFTableName.LOCA), checksum);
            int padSize = (this.locaOffset + locaSize) % 4;
            this.newDirTabs.put(OFTableName.LOCA, new OFDirTabEntry((long)this.locaOffset, (long)(locaSize + padSize)));
            if (!this.cid && this.locaFormat == 0) {
                int i = 0;
                int offset = 0;
                for (Glyph e : this.added.values()) {
                    this.writeUShort(this.locaOffset + i * 2, offset / 2);
                    offset += e.data.length;
                    ++i;
                }
                this.writeUShort(this.locaOffset + i * 2, offset / 2);
            }
        } else {
            throw new IOException("Can't find glyf table");
        }
    }

    protected void createHmtx() throws IOException {
        OFTableName hmtx = OFTableName.HMTX;
        OFDirTabEntry entry = (OFDirTabEntry)this.dirTabs.get(hmtx);
        if (entry != null) {
            this.pad4();
            int longHorMetricSize = this.added.size() * 2;
            int leftSideBearingSize = this.added.size() * 2;
            int hmtxSize = longHorMetricSize + leftSideBearingSize;
            for (Map.Entry<Integer, Glyph> e : this.added.entrySet()) {
                Integer subsetIndex = e.getKey();
                OFMtxEntry mtx = e.getValue().mtx;
                this.writeUShort(this.currentPos + subsetIndex * 4, mtx.getWx());
                this.writeUShort(this.currentPos + subsetIndex * 4 + 2, mtx.getLsb());
            }
            this.updateCheckSum(this.currentPos, hmtxSize, hmtx);
            this.currentPos += hmtxSize;
            this.realSize += hmtxSize;
        } else {
            throw new IOException("Can't find hmtx table");
        }
    }

    @Override
    public void readFont(InputStream is, String name, FontContainer fontContainer, Map<Integer, Integer> subsetGlyphs, boolean cid) throws IOException {
        this.cid = cid;
        if (subsetGlyphs.isEmpty()) {
            return;
        }
        this.fontFile = new FontFileReader(is);
        this.size += this.fontFile.getAllBytes().length;
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.readIndexToLocation();
        int sgsize = subsetGlyphs.size();
        if (!cid && subsetGlyphs.size() <= 1) {
            for (int i = 0; i < this.mtxTab.length; ++i) {
                subsetGlyphs.put(i, i);
            }
        }
        this.scanGlyphs(this.fontFile, subsetGlyphs);
        this.readGlyf(subsetGlyphs, this.fontFile);
        if (this.nhmtxDiff == null) {
            this.nhmtxDiff = sgsize - this.nhmtx;
            if (this.nhmtxDiff < 0) {
                this.nhmtxDiff = 0;
            }
        }
    }

    protected void scanGlyphs(FontFileReader in, Map<Integer, Integer> subsetGlyphs) throws IOException {
        OFDirTabEntry glyfTableInfo = (OFDirTabEntry)this.dirTabs.get(OFTableName.GLYF);
        if (glyfTableInfo == null) {
            throw new IOException("Glyf table could not be found");
        }
        MergeGlyfTable mergeGlyfTable = new MergeGlyfTable(in, this.mtxTab, glyfTableInfo, subsetGlyphs);
        this.composedGlyphs = mergeGlyfTable.getComposedGlyphs();
        this.compositeGlyphs = mergeGlyfTable.getCompositeGlyphs();
    }

    private void reorderGlyphs() throws IOException {
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        TreeMap<Integer, Glyph> glyphMap = new TreeMap<Integer, Glyph>();
        int i = 0;
        for (Glyph glyph : this.added.values()) {
            if (glyph.composed) continue;
            glyphMap.put(i, glyph);
            remap.put(glyph.origGlyphIndex, i);
            ++i;
        }
        for (Glyph glyph : this.added.values()) {
            if (!glyph.composed) continue;
            glyphMap.put(i, glyph);
            remap.put(glyph.origGlyphIndex, i);
            ++i;
        }
        for (Glyph glyph : glyphMap.values()) {
            if (!glyph.composite || glyph.data.length <= 0) continue;
            this.remapComposite(glyph.data, remap);
        }
        this.added = glyphMap;
    }

    private void remapComposite(byte[] data, Map<Integer, Integer> remap) throws IOException {
        short flags;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        byte[] header = new byte[10];
        this.read(dis, header);
        dos.write(header);
        do {
            flags = dis.readShort();
            dos.writeShort(flags);
            short glyphIndex = dis.readShort();
            int indexInSubset = remap.get(glyphIndex);
            dos.writeShort(indexInSubset);
            int skip = GlyfTable.GlyfFlags.getOffsetToNextComposedGlyf((int)flags);
            byte[] rest = new byte[skip];
            this.read(dis, rest);
            dos.write(rest);
        } while (GlyfTable.GlyfFlags.hasMoreComposites((int)flags));
        System.arraycopy(bos.toByteArray(), 0, data, 0, bos.size());
    }

    private void read(DataInputStream dis, byte[] data) throws IOException {
        int size = dis.read(data);
        assert (size == data.length);
    }

    @Override
    public byte[] getMergedFontSubset() throws IOException {
        int sgsize = this.added.size();
        if (sgsize == 1 && this.size == this.fontFile.getAllBytes().length) {
            return this.fontFile.getAllBytes();
        }
        this.reorderGlyphs();
        this.output = new byte[this.size * 2];
        this.createDirectory();
        if (!this.cid) {
            this.writeCMAP(this.cmap);
        }
        this.createHmtx();
        this.createLoca(sgsize);
        this.createHead(this.fontFile);
        this.createOS2(this.fontFile);
        if (!this.cid) {
            this.createHhea(this.fontFile, sgsize - this.nhmtxDiff);
        } else {
            this.createHhea(this.fontFile, sgsize);
        }
        if (this.maxp.getVersion() == 0.0f) {
            this.createMaxp(this.fontFile, sgsize);
        } else {
            this.writeMaxp();
        }
        this.createCvt(this.fontFile);
        this.createFpgm(this.fontFile);
        this.createPost(this.fontFile);
        this.createPrep(this.fontFile);
        this.createName(this.fontFile);
        this.createGlyf();
        this.pad4();
        this.createCheckSumAdjustment();
        return this.getFontSubset();
    }

    private void writeMaxp() {
        int checksum = this.currentPos;
        this.pad4();
        int startPos = this.currentPos;
        this.writeUShort((int)this.maxp.getVersion());
        this.writeUShort(0);
        this.writeUShort(this.added.size());
        this.writeUShort(this.maxp.getMaxPoints());
        this.writeUShort(this.maxp.getMaxContours());
        this.writeUShort(this.maxp.getMaxCompositePoints());
        this.writeUShort(this.maxp.getMaxCompositeContours());
        this.writeUShort(this.maxp.getMaxZones());
        this.writeUShort(this.maxp.getMaxTwilightPoints());
        this.writeUShort(this.maxp.getMaxStorage());
        this.writeUShort(this.maxp.getMaxFunctionDefs());
        this.writeUShort(this.maxp.getMaxInstructionDefs());
        this.writeUShort(this.maxp.getMaxStackElements());
        this.writeUShort(this.maxp.getMaxSizeOfInstructions());
        this.writeUShort(this.maxp.getMaxComponentElements());
        this.writeUShort(this.maxp.getMaxComponentDepth());
        this.updateCheckSum(checksum, this.currentPos - startPos, OFTableName.MAXP);
        this.realSize += this.currentPos - startPos;
    }

    /*
     * Could not resolve type clashes
     */
    private void writeCMAP(List<Cmap> cmaps) {
        this.mergeUniCmap(cmaps);
        int checksum = this.currentPos;
        this.pad4();
        int cmapPos = this.currentPos;
        this.writeUShort(0);
        this.writeUShort(cmaps.size());
        int tablesSize = 8 * cmaps.size();
        for (int i = 0; i < cmaps.size(); ++i) {
            Cmap cmap = cmaps.get(i);
            this.writeUShort(cmap.platformId);
            this.writeUShort(cmap.platformEncodingId);
            this.writeULong(this.currentPos, 4 + tablesSize + this.getCmapOffset(cmaps, i));
            this.currentPos += 4;
        }
        for (Cmap cmap : cmaps) {
            if (cmap.platformId != 0) {
                int c;
                this.writeUShort(4);
                int segCount = cmap.glyphIdToCharacterCode.size() + 1;
                this.writeUShort(16 + segCount * 8);
                this.writeUShort(0);
                this.writeUShort(segCount * 2);
                double searchRange = Math.pow(2.0, Math.floor(this.logBase2(segCount))) * 2.0;
                this.writeUShort((int)searchRange);
                double entrySelector = Math.floor(this.logBase2(segCount));
                this.writeUShort((int)entrySelector);
                double rangeShift = (double)(segCount * 2) - searchRange;
                this.writeUShort((int)rangeShift);
                Iterator<Object> iterator = cmap.glyphIdToCharacterCode.keySet().iterator();
                while (iterator.hasNext()) {
                    c = iterator.next();
                    this.writeUShort(c);
                }
                this.writeUShort(65535);
                this.writeUShort(0);
                iterator = cmap.glyphIdToCharacterCode.keySet().iterator();
                while (iterator.hasNext()) {
                    c = iterator.next();
                    this.writeUShort(c);
                }
                this.writeUShort(65535);
                for (Map.Entry entry : cmap.glyphIdToCharacterCode.entrySet()) {
                    this.writeUShort((Integer)entry.getValue() - (Integer)entry.getKey());
                }
                this.writeUShort(0);
                iterator = cmap.glyphIdToCharacterCode.keySet().iterator();
                while (iterator.hasNext()) {
                    int g = (Integer)iterator.next();
                    this.writeUShort(0);
                }
                this.writeUShort(0);
                continue;
            }
            this.writeUShort(12);
            this.writeUShort(0);
            this.writeULong(this.currentPos, cmap.glyphIdToCharacterCode.size() * 12 + 16);
            this.currentPos += 4;
            this.writeULong(this.currentPos, 0);
            this.currentPos += 4;
            this.writeULong(this.currentPos, cmap.glyphIdToCharacterCode.size());
            this.currentPos += 4;
            for (Map.Entry<Integer, Integer> g : cmap.glyphIdToCharacterCode.entrySet()) {
                this.writeULong(this.currentPos, g.getKey());
                this.currentPos += 4;
                this.writeULong(this.currentPos, g.getKey());
                this.currentPos += 4;
                this.writeULong(this.currentPos, g.getValue());
                this.currentPos += 4;
            }
        }
        this.updateCheckSum(checksum, this.currentPos - cmapPos, OFTableName.CMAP);
        this.realSize += this.currentPos - cmapPos;
    }

    private int logBase2(int n) {
        return (int)(Math.log(n) / Math.log(2.0));
    }

    private void mergeUniCmap(List<Cmap> cmaps) {
        Cmap uniCmap = null;
        for (Cmap cmap : cmaps) {
            if (cmap.platformId != 3 || cmap.platformEncodingId != 1) continue;
            uniCmap = cmap;
        }
        if (uniCmap != null) {
            for (Cmap cmap : cmaps) {
                uniCmap.glyphIdToCharacterCode.putAll(cmap.glyphIdToCharacterCode);
            }
        }
    }

    private int getCmapOffset(List<Cmap> cmaps, int index) {
        int result = 0;
        for (int i = 0; i < index; ++i) {
            Cmap curCmap = cmaps.get(i);
            if (curCmap.platformId != 0) {
                int segCount = curCmap.glyphIdToCharacterCode.size() + 1;
                result += 16 + segCount * 8;
                continue;
            }
            result += curCmap.glyphIdToCharacterCode.size() * 12 + 16;
        }
        return result;
    }

    protected int[] buildSubsetIndexToOrigIndexMap(Map<Integer, Integer> glyphs) {
        int[] origIndexes = new int[glyphs.size()];
        int minIndex = Integer.MAX_VALUE;
        Iterator<Object> iterator = glyphs.values().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            if (minIndex <= n) continue;
            minIndex = n;
        }
        for (Map.Entry entry : glyphs.entrySet()) {
            int origIndex = (Integer)entry.getKey();
            int subsetIndex = (Integer)entry.getValue() - minIndex;
            origIndexes[subsetIndex] = origIndex;
        }
        return origIndexes;
    }

    public static class Cmap {
        int platformId;
        int platformEncodingId;
        Map<Integer, Integer> glyphIdToCharacterCode = new TreeMap<Integer, Integer>();

        public Cmap(int platformID, int platformEncodingID) {
            this.platformId = platformID;
            this.platformEncodingId = platformEncodingID;
        }
    }

    static class MergeGlyfTable
    extends GlyfTable {
        public MergeGlyfTable(FontFileReader in, OFMtxEntry[] metrics, OFDirTabEntry dirTableEntry, Map<Integer, Integer> glyphs) throws IOException {
            super(in, metrics, dirTableEntry, glyphs);
            this.populateGlyphsWithComposites();
        }

        protected void populateGlyphsWithComposites() throws IOException {
            Iterator iterator = this.subset.keySet().iterator();
            while (iterator.hasNext()) {
                int indexInOriginal = (Integer)iterator.next();
                this.scanGlyphsRecursively(indexInOriginal);
            }
            this.addAllComposedGlyphsToSubset();
        }

        private void scanGlyphsRecursively(int indexInOriginal) throws IOException {
            if (!this.subset.containsKey(indexInOriginal)) {
                this.composedGlyphs.add(indexInOriginal);
            }
            if (this.isComposite(indexInOriginal)) {
                this.compositeGlyphs.add(indexInOriginal);
                Set composedGlyphs = this.retrieveComposedGlyphs(indexInOriginal);
                for (Integer composedGlyph : composedGlyphs) {
                    this.scanGlyphsRecursively(composedGlyph);
                }
            }
        }

        Set<Integer> getComposedGlyphs() {
            return this.composedGlyphs;
        }

        Set<Integer> getCompositeGlyphs() {
            return this.compositeGlyphs;
        }

        protected void addAllComposedGlyphsToSubset() {
            int newIndex = -1;
            Iterator<Object> iterator = this.subset.values().iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                if (v <= newIndex) continue;
                newIndex = v;
            }
            iterator = this.composedGlyphs.iterator();
            while (iterator.hasNext()) {
                int composedGlyph = (Integer)iterator.next();
                this.subset.put(composedGlyph, ++newIndex);
            }
        }
    }

    static class Glyph {
        final byte[] data;
        final OFMtxEntry mtx;
        final boolean composed;
        final boolean composite;
        final int origGlyphIndex;

        Glyph(byte[] data, OFMtxEntry mtx, boolean composed, boolean composite, int origGlyphIndex) {
            this.data = data;
            this.mtx = mtx;
            this.composed = composed;
            this.composite = composite;
            this.origGlyphIndex = origGlyphIndex;
        }
    }
}

