/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlVisitor;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DomBuilder
implements XmlVisitor {
    private Document document;
    private Element destinationElement;
    private CleanerProperties props;
    protected boolean escapeXml = true;
    protected boolean deserializeCdataEntities = false;
    protected boolean strictErrorChecking = true;
    private static final String CSS_COMMENT_START = "/*";

    public DomBuilder(CleanerProperties props, boolean escapeXml, boolean deserializeCdataEntities, boolean strictErrorChecking) {
        this.props = props;
        this.escapeXml = escapeXml;
        this.deserializeCdataEntities = deserializeCdataEntities;
        this.strictErrorChecking = strictErrorChecking;
    }

    public Document getDocument() {
        return this.document;
    }

    private boolean shouldEscapeOrTranslateEntities() {
        return this.escapeXml || this.props.isRecognizeUnicodeChars() || this.props.isTranslateSpecialEntities();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void head(HtmlNode node, int depth) {
        CDATASection cdata = null;
        if (node instanceof TagNode && this.props.isUseCdataFor(((TagNode)node).getName())) {
            cdata = this.document.createCDATASection("");
            this.destinationElement.appendChild(this.document.createTextNode(CSS_COMMENT_START));
            this.destinationElement.appendChild(cdata);
        }
        if (node instanceof CommentNode) {
            CommentNode commentNode = (CommentNode)node;
            Comment comment = this.document.createComment(commentNode.getContent());
            this.destinationElement.appendChild(comment);
        } else if (node instanceof ContentNode) {
            ContentNode contentNode = (ContentNode)node;
            String content = contentNode.getContent();
            boolean specialCase = this.props.isUseCdataFor(node.getParent().getName());
            if (this.shouldEscapeOrTranslateEntities() && !specialCase) {
                content = Utils.escapeXml(content, this.props, true);
            }
            if (specialCase && node instanceof CData) {
                content = ((CData)node).getContentWithoutStartAndEndTokens();
            }
            if (specialCase && this.deserializeCdataEntities) {
                content = this.deserializeCdataEntities(content);
            }
            if (cdata != null) {
                cdata.appendData(content);
            } else {
                this.destinationElement.appendChild(this.document.createTextNode(content));
            }
        } else if (node instanceof TagNode) {
            TagNode subTagNode = (TagNode)node;
            String name = Utils.sanitizeXmlIdentifier(subTagNode.getName(), this.props.getInvalidXmlAttributeNamePrefix());
            if (name == null) {
                ContentNode contentNode = new ContentNode(subTagNode.getName() + subTagNode.getText().toString());
                String content = contentNode.getContent();
                content = Utils.escapeXml(content, this.props, true);
                this.destinationElement.appendChild(this.document.createTextNode(content));
            } else {
                if (this.document == null) {
                    try {
                        this.document = this.createDocument(subTagNode);
                    }
                    catch (ParserConfigurationException e) {
                        e.printStackTrace();
                    }
                }
                Element element = this.document.createElement(name);
                Map<String, String> attributes = subTagNode.getAttributes();
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    void var10_18;
                    String string = entry.getKey();
                    String attrValue = entry.getValue();
                    if (this.escapeXml) {
                        attrValue = Utils.deserializeEntities(attrValue, this.props.isRecognizeUnicodeChars());
                        attrValue = Utils.escapeXml(attrValue, this.props, true);
                    }
                    if (!this.props.isAllowInvalidAttributeNames()) {
                        String string2 = Utils.sanitizeXmlIdentifier(string, this.props.getInvalidXmlAttributeNamePrefix());
                    }
                    if (var10_18 == null || !Utils.isValidXmlIdentifier((String)var10_18) && !this.props.isAllowInvalidAttributeNames()) continue;
                    element.setAttribute((String)var10_18, attrValue);
                    if (!var10_18.equalsIgnoreCase("id")) continue;
                    element.setIdAttribute((String)var10_18, true);
                }
                if (this.destinationElement == null) {
                    this.destinationElement = this.document.getDocumentElement();
                } else {
                    this.destinationElement.appendChild(element);
                    this.destinationElement = element;
                }
                for (BaseToken baseToken : subTagNode.getAllChildren()) {
                    if (!(baseToken instanceof ContentNode)) continue;
                    ((ContentNode)baseToken).setParent(subTagNode);
                }
            }
        }
    }

    protected String deserializeCdataEntities(String input) {
        return Utils.deserializeEntities(input, this.props.isRecognizeUnicodeChars());
    }

    @Override
    public void tail(HtmlNode node, int depth) {
        if (node instanceof TagNode && this.destinationElement.getParentNode() instanceof Element) {
            this.destinationElement = (Element)this.destinationElement.getParentNode();
        }
    }

    protected Document createDocument(TagNode rootNode) throws ParserConfigurationException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        if (rootNode.getDocType() != null) {
            String qualifiedName = rootNode.getDocType().getPart1();
            String publicId = rootNode.getDocType().getPublicId();
            String systemId = rootNode.getDocType().getSystemId();
            if (qualifiedName == null) {
                qualifiedName = "html";
            }
            DocumentType documentType = impl.createDocumentType(qualifiedName, publicId, systemId);
            if (qualifiedName.equals("HTML")) {
                qualifiedName = "html";
            }
            document = impl.createDocument(rootNode.getNamespaceURIOnPath(""), qualifiedName, documentType);
        } else {
            document = builder.newDocument();
            Element rootElement = document.createElement(rootNode.getName());
            document.appendChild(rootElement);
        }
        if (this.props.isAllowInvalidAttributeNames() || !this.strictErrorChecking) {
            document.setStrictErrorChecking(false);
        }
        Map<String, String> attributes = rootNode.getAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (!this.props.isAllowInvalidAttributeNames()) {
                attrName = Utils.sanitizeXmlIdentifier(attrName, this.props.getInvalidXmlAttributeNamePrefix());
            }
            if (attrName == null || !Utils.isValidXmlIdentifier(attrName) && !this.props.isAllowInvalidAttributeNames()) continue;
            if (this.escapeXml) {
                attrValue = Utils.deserializeEntities(attrValue, this.props.isRecognizeUnicodeChars());
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            document.getDocumentElement().setAttribute(attrName, attrValue);
            if (!attrName.equalsIgnoreCase("id")) continue;
            document.getDocumentElement().setIdAttribute(attrName, true);
        }
        return document;
    }
}

