/*
 * Decompiled with CFR 0.152.
 */
package org.dita4publishers.epub.fontobfuscator;

import com.sun.crypto.provider.SunJCE;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import org.apache.commons.io.FilenameUtils;

public class FontObfuscator {
    public static void main(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        if (stringArray.length < 2) {
            System.err.println("\nUsage: \n");
            System.err.println("FontObfuscator \"{EPUB Unique ID}\" \"{font file}\" [{destination file}]");
            System.err.println("\nThe EPUB Unique ID must be the value of the dc:identifier element\nfrom the EPUB's OPF file.");
            System.err.println("\nIf destination file is not specified, the obfuscated font will be in a \ndirectory named \"obfuscated\" under the input font's directory.\n");
            System.err.println("\nIf destination file is a directory it will create a file with the samename as the input font file.\n");
            System.exit(1);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Path path = Paths.get("", new String[0]);
        System.out.println("pwd=\"" + path.toAbsolutePath() + "\"");
        File file = path.toAbsolutePath().toFile();
        InputStream inputStream = null;
        File file2 = null;
        if (string3.matches("^\\w+:/.+")) {
            try {
                object2 = new URL(string3);
                try {
                    inputStream = ((URL)object2).openStream();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getClass().getSimpleName() + " opening URL \"" + string3 + "\":");
                    System.err.println(iOException.getMessage());
                    System.exit(1);
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("- [DEBUG] font file path \"" + string3 + "\"" + "looks like an absolute URI but is not a valid URL:" + malformedURLException.getMessage());
            }
        }
        if (inputStream == null) {
            file2 = new File(string3);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string3);
            }
            if (!file2.exists()) {
                System.err.println("Failed to find font file \"" + file2.getAbsolutePath() + "\"");
                System.exit(1);
            }
        }
        object2 = FilenameUtils.getName((String)string3);
        File file3 = null;
        if (stringArray.length > 2) {
            object = stringArray[2];
            string = FilenameUtils.getExtension((String)object);
            file3 = new File((String)object);
            if (!file3.isAbsolute()) {
                file3 = new File(file, (String)object);
            }
            if (string == null || "".equals(string)) {
                file3 = new File(file3, (String)object2);
            }
        } else {
            object = new File(file2.getParentFile(), "obfuscated");
            file3 = new File((File)object, (String)object2);
        }
        if (file2 != null && file3.getAbsolutePath().equals(file2.getAbsolutePath())) {
            System.err.println("[ERROR] Input and destination font file are the same. Cannot continue.");
            System.exit(1);
        }
        System.out.println("Obfuscating font " + string3 + " ...");
        try {
            if (inputStream == null) {
                inputStream = new FileInputStream(file2);
            }
            file3.getParentFile().mkdirs();
            object = new FileOutputStream(file3);
            string = FontObfuscator.makeObfuscationKey(string2);
            System.out.println("Using obfuscation key \"" + string + "\"");
            FontObfuscator.obfuscateFont(inputStream, (OutputStream)object, string);
            System.out.println("Font obfuscated to " + file3.getAbsolutePath());
        }
        catch (Exception exception) {
            System.err.println(exception.getClass().getSimpleName() + ": " + exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private static byte[] makeXORMask(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Security.addProvider(new SunJCE());
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            String string2 = string.trim();
            messageDigest.update(string2.getBytes("UTF-8"), 0, string2.length());
            byteArrayOutputStream.write(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("No such Algorithm (really, did I misspell SHA-1?");
            System.err.println(noSuchAlgorithmException.toString());
            return null;
        }
        catch (IOException iOException) {
            System.err.println("IO Exception. check out mask.write...");
            System.err.println(iOException.toString());
            return null;
        }
        if (byteArrayOutputStream.size() != 20) {
            System.err.println("makeXORMask should give 20 byte mask, but isn't");
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void obfuscateFont(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        byte[] byArray = FontObfuscator.makeXORMask(string);
        try {
            int n;
            byte[] byArray2 = new byte[4096];
            boolean bl = true;
            while ((n = inputStream.read(byArray2)) > 0) {
                if (bl && byArray != null) {
                    bl = false;
                    for (int i = 0; i < 1040; ++i) {
                        byArray2[i] = (byte)(byArray2[i] ^ byArray[i % byArray.length]);
                    }
                }
                outputStream.write(byArray2, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        outputStream.close();
    }

    public static String makeObfuscationKey(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (String string2 : stringArray) {
            String string3 = string2.replaceAll("[\\s\\t\\n\\r]", "");
            stringBuilder.append(string).append(string3);
            string = " ";
        }
        return stringBuilder.toString();
    }
}

