/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.word.styles;

import com.oxygenxml.batch.converter.core.word.styles.CustomToDefaultStyleRelation;
import com.oxygenxml.batch.converter.core.word.styles.ResultedHtml;
import com.oxygenxml.batch.converter.core.word.styles.WordStyleMap;
import com.oxygenxml.batch.converter.core.word.styles.WordStyleToHtmlRelation;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwobble.mammoth.internal.conversion.UnknownStylesReporter;
import ro.sync.basic.util.URLUtil;

public final class WordStyleMapLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)WordStyleMapLoader.class.getName());
    private static final String STYLE_MAP_PATH = "config/wordStyleMap.xml";
    private static final StyleMapData STYLE_MAP_DATA = new StyleMapData();
    private static UnknownStylesReporter unknownStylesReporter;
    private static JAXBContext context;

    private WordStyleMapLoader() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String loadStyleMap(ClassLoader classLoader) throws JAXBException {
        STYLE_MAP_DATA.loadStyleMap(classLoader);
        return WordStyleMapLoader.STYLE_MAP_DATA.styleMap;
    }

    public static String readStyleMap(ClassLoader classLoader) throws JAXBException {
        String readStyleMap = null;
        WordStyleMap styleMapObj = WordStyleMapLoader.loadStyleMapObject(classLoader);
        if (styleMapObj != null) {
            readStyleMap = WordStyleMapLoader.convertToStringFormat(styleMapObj);
        }
        return readStyleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WordStyleMap loadStyleMapObject(ClassLoader classLoader) throws JAXBException {
        WordStyleMap styleMapObj = null;
        URL styleMapLocation = WordStyleMapLoader.STYLE_MAP_DATA.imposedStyleMapURL != null ? WordStyleMapLoader.STYLE_MAP_DATA.imposedStyleMapURL : classLoader.getResource(STYLE_MAP_PATH);
        if (styleMapLocation == null) return styleMapObj;
        Class<WordStyleMapLoader> clazz = WordStyleMapLoader.class;
        synchronized (WordStyleMapLoader.class) {
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{WordStyleMap.class});
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (WordStyleMap)unmarshaller.unmarshal(styleMapLocation);
        }
    }

    private static String convertToStringFormat(WordStyleMap styleMap) {
        StringBuilder toRet = new StringBuilder();
        List<WordStyleToHtmlRelation> styleToHtmlList = styleMap.getStyleToHtmlList();
        if (styleToHtmlList != null) {
            for (WordStyleToHtmlRelation styleToHtmlRelation : styleToHtmlList) {
                WordStyleMapLoader.appendStyleInfo(toRet, styleToHtmlRelation.getElement(), styleToHtmlRelation.getStyleName(), styleToHtmlRelation.getResultedHTML());
            }
            List<CustomToDefaultStyleRelation> customToDefaultList = styleMap.getCustomToDefaultList();
            if (customToDefaultList != null) {
                block1: for (int i = 0; i < customToDefaultList.size(); ++i) {
                    CustomToDefaultStyleRelation styleRelation = customToDefaultList.get(i);
                    String defaultStyle = styleRelation.getDefaultStyle();
                    for (WordStyleToHtmlRelation styleToHtmlRelation : styleToHtmlList) {
                        String styleName = styleToHtmlRelation.getStyleName();
                        if (styleName == null || !styleName.equals(defaultStyle)) continue;
                        WordStyleMapLoader.appendStyleInfo(toRet, styleToHtmlRelation.getElement(), styleRelation.getCustomStyle(), styleToHtmlRelation.getResultedHTML());
                        continue block1;
                    }
                }
            }
        }
        return toRet.toString();
    }

    private static void appendStyleInfo(StringBuilder stringBuilder, String element, String style, ResultedHtml htmlElement) {
        stringBuilder.append(element != null ? element : "p");
        if (style != null) {
            stringBuilder.append("[style-name='").append(style).append("']");
        }
        stringBuilder.append(" => ").append(htmlElement.getName());
        if (Boolean.parseBoolean(htmlElement.getFresh())) {
            stringBuilder.append(":fresh");
        }
        stringBuilder.append('\n');
    }

    public static void imposeStyleMapURL(URL styleMapURL) {
        STYLE_MAP_DATA.imposeStyleMapURL(styleMapURL);
    }

    public static void imposeStyleMap(String styleMapToImpose) {
        WordStyleMapLoader.STYLE_MAP_DATA.styleMap = styleMapToImpose;
    }

    public static void imposeStyleMapFile(File styleMapFile) {
        try {
            STYLE_MAP_DATA.imposeStyleMapURL(URLUtil.correct((File)styleMapFile));
        }
        catch (MalformedURLException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void setUnknownStylesReporter(UnknownStylesReporter reporter) {
        unknownStylesReporter = reporter;
    }

    public static UnknownStylesReporter getUnknownStylesReporter() {
        return unknownStylesReporter;
    }

    private static class StyleMapData {
        URL imposedStyleMapURL;
        String styleMap;

        StyleMapData() {
        }

        void loadStyleMap(ClassLoader classLoader) throws JAXBException {
            if (this.styleMap == null) {
                this.styleMap = WordStyleMapLoader.readStyleMap(classLoader);
            }
        }

        void imposeStyleMapURL(URL styleMapURL) {
            this.imposedStyleMapURL = styleMapURL;
            this.styleMap = null;
        }
    }
}

