/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.utils;

import java.util.regex.Pattern;
import ro.sync.basic.util.URLUtil;

public final class XmlUtil {
    private static final Pattern ILLEGAL_ID_CHARS_REGEX = Pattern.compile("[^A-Za-z0-9._-]");
    private static final Pattern MINUS_UNDERSCORE_REGEX = Pattern.compile("(_-_|-_|_-)");
    private static final Pattern DOT_UNDERSCORE_REGEX = Pattern.compile("(_\\._|\\._|_\\.)");
    private static final Pattern CONSECUTIVE_MINUSES_REGEX = Pattern.compile("-+");
    private static final Pattern CONSECUTIVE_DOTS_REGEX = Pattern.compile("\\.+");
    private static final Pattern CONSECUTIVE_UNDERSCORES_REGEX = Pattern.compile("_+");

    private XmlUtil() {
    }

    public static String getValidIDFromName(String fileName) {
        Object toReturn = URLUtil.uncorrect((String)fileName.trim());
        toReturn = ILLEGAL_ID_CHARS_REGEX.matcher((CharSequence)toReturn).replaceAll("_");
        toReturn = MINUS_UNDERSCORE_REGEX.matcher((CharSequence)toReturn).replaceAll("-");
        toReturn = DOT_UNDERSCORE_REGEX.matcher((CharSequence)toReturn).replaceAll(".");
        toReturn = CONSECUTIVE_UNDERSCORES_REGEX.matcher((CharSequence)toReturn).replaceAll("_");
        toReturn = CONSECUTIVE_MINUSES_REGEX.matcher((CharSequence)toReturn).replaceAll("-");
        char firstChar = ((String)(toReturn = CONSECUTIVE_DOTS_REGEX.matcher((CharSequence)toReturn).replaceAll("."))).charAt(0);
        if (firstChar >= '0' && firstChar <= '9' || firstChar == '.' || firstChar == '-') {
            toReturn = "_" + (String)toReturn;
        }
        return toReturn;
    }
}

