/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.printers;

import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.printers.ContentPrinter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinterUtils;
import com.oxygenxml.batch.converter.core.printers.SimpleContentPrinterImpl;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class TransformerContentPrinterImpl
implements ContentPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TransformerContentPrinterImpl.class.getName());

    @Override
    public void print(ConversionResult conversionResult, TransformerFactoryCreator transformerCreator, String converterType, File outputFile) throws TransformerException {
        Transformer transformer = transformerCreator.createTransformer(null);
        transformer = ContentPrinterUtils.configureDoctypeInTransformer(transformer, conversionResult, converterType);
        transformer.setOutputProperty("indent", "true");
        try (StringReader convertedContent = new StringReader(conversionResult.getConvertedContent());){
            InputSource inputSource = new InputSource(convertedContent);
            transformer.transform(new SAXSource(inputSource), new StreamResult(outputFile));
        }
        catch (TransformerException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            SimpleContentPrinterImpl simpleContentPrinter = new SimpleContentPrinterImpl();
            simpleContentPrinter.print(conversionResult, transformerCreator, converterType, outputFile);
        }
    }
}

