/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.extensions;

import com.oxygenxml.batch.converter.core.ConversionFormatUtil;
import com.oxygenxml.batch.converter.core.extensions.FileExtensionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ExtensionGetter {
    private static final String[] NO_EXTENSIONS_ARRAY = new String[0];
    private static final Map<String, String[]> CONVERTER_TYPE_TO_INPUT_EXTENSIONS;
    private static final Map<String, String> CONVERTER_TYPE_TO_OUTPUT_EXTENSION;

    private ExtensionGetter() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String[] getInputExtension(String inputFormat, String outputFormat) {
        String[] toRet = null;
        String converterType = ConversionFormatUtil.getConverterType(inputFormat, outputFormat);
        if (converterType != null) {
            toRet = ExtensionGetter.getInputExtension(converterType);
        }
        return toRet;
    }

    public static String[] getInputExtension(String converterType) {
        String[] extensions = CONVERTER_TYPE_TO_INPUT_EXTENSIONS.get(converterType);
        return extensions == null ? NO_EXTENSIONS_ARRAY : extensions;
    }

    public static String getOutputExtension(String converterType) {
        return CONVERTER_TYPE_TO_OUTPUT_EXTENSION.get(converterType);
    }

    static {
        HashMap<String, String[]> coverterTypeToInputExtensions = new HashMap<String, String[]>(18);
        coverterTypeToInputExtensions.put("_html.to.dita", FileExtensionType.INPUT_HTML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_html.to.xhtml", FileExtensionType.INPUT_HTML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_html.to.db4", FileExtensionType.INPUT_HTML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_html.to.db5", FileExtensionType.INPUT_HTML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_md.to.dita", FileExtensionType.INPUT_MD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_md.to.xhtml", FileExtensionType.INPUT_MD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_md.to.db5", FileExtensionType.INPUT_MD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_md.to.db4", FileExtensionType.INPUT_MD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_xml.to.json", FileExtensionType.INPUT_XML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_json.to.xml", FileExtensionType.INPUT_JSON_EXTENSIONS);
        coverterTypeToInputExtensions.put("_yaml.to.json", FileExtensionType.INPUT_YAML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_json.to.yaml", FileExtensionType.INPUT_JSON_EXTENSIONS);
        coverterTypeToInputExtensions.put("_yaml.to.xml", FileExtensionType.INPUT_YAML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_xsd.to.json", FileExtensionType.INPUT_XSD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_xml.to.yaml", FileExtensionType.INPUT_XML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_excel.to.dita", FileExtensionType.INPUT_EXCEL_EXTENSIONS);
        coverterTypeToInputExtensions.put("_word.to.xhtml", FileExtensionType.INPUT_WORD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_word.to.dita", FileExtensionType.INPUT_WORD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_word.to.db4", FileExtensionType.INPUT_WORD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_word.to.db5", FileExtensionType.INPUT_WORD_EXTENSIONS);
        coverterTypeToInputExtensions.put("_confluence.to.ditamap", FileExtensionType.INPUT_HTML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_confluence.topic.to.dita", FileExtensionType.INPUT_HTML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_docbook.to.dita", FileExtensionType.INPUT_XML_EXTENSIONS);
        coverterTypeToInputExtensions.put("_openapi.to.dita", FileExtensionType.INPUT_OPEN_API_EXTENSIONS);
        CONVERTER_TYPE_TO_INPUT_EXTENSIONS = Collections.unmodifiableMap(coverterTypeToInputExtensions);
        HashMap<String, String> coverterTypeToOutputExtension = new HashMap<String, String>(18);
        coverterTypeToOutputExtension.put("_html.to.dita", "dita");
        coverterTypeToOutputExtension.put("_md.to.dita", "dita");
        coverterTypeToOutputExtension.put("_excel.to.dita", "dita");
        coverterTypeToOutputExtension.put("_word.to.dita", "dita");
        coverterTypeToOutputExtension.put("_docbook.to.dita", "dita");
        coverterTypeToOutputExtension.put("_confluence.to.ditamap", "ditamap");
        coverterTypeToOutputExtension.put("_confluence.topic.to.dita", "dita");
        coverterTypeToOutputExtension.put("_openapi.to.dita", "dita");
        coverterTypeToOutputExtension.put("_html.to.xhtml", "xhtml");
        coverterTypeToOutputExtension.put("_md.to.xhtml", "xhtml");
        coverterTypeToOutputExtension.put("_word.to.xhtml", "xhtml");
        coverterTypeToOutputExtension.put("_xml.to.json", "json");
        coverterTypeToOutputExtension.put("_yaml.to.json", "json");
        coverterTypeToOutputExtension.put("_json.to.yaml", "yaml");
        coverterTypeToOutputExtension.put("_xsd.to.json", "json");
        coverterTypeToOutputExtension.put("_yaml.to.xml", "xml");
        coverterTypeToOutputExtension.put("_xml.to.yaml", "yaml");
        coverterTypeToOutputExtension.put("_json.to.xml", "xml");
        coverterTypeToOutputExtension.put("_md.to.db5", "xml");
        coverterTypeToOutputExtension.put("_md.to.db4", "xml");
        coverterTypeToOutputExtension.put("_html.to.db4", "xml");
        coverterTypeToOutputExtension.put("_html.to.db5", "xml");
        coverterTypeToOutputExtension.put("_word.to.db4", "xml");
        coverterTypeToOutputExtension.put("_word.to.db5", "xml");
        CONVERTER_TYPE_TO_OUTPUT_EXTENSION = Collections.unmodifiableMap(coverterTypeToOutputExtension);
    }
}

