/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.doctype;

import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DoctypeGetter {
    private static final Map<String, String> CONVERTER_TO_PUBLIC_DOCTYPE_MAP;
    private static final Map<String, String> CONVERTER_TO_SYSTEM_DOCTYPE_MAP;
    private static final Map<String, String> DOCTYPE_TO_CONVERTER_MAP;

    private DoctypeGetter() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static String getPublicDoctype(String converterType) {
        String docType = CONVERTER_TO_PUBLIC_DOCTYPE_MAP.get(converterType);
        return docType == null ? "" : docType;
    }

    private static String getSystemDoctype(String converterType) {
        String docType = CONVERTER_TO_SYSTEM_DOCTYPE_MAP.get(converterType);
        return docType == null ? "" : docType;
    }

    public static String getDoctype(ConversionResult result, String converterType) {
        String doctype = result.getImposedDoctype();
        if (doctype == null) {
            doctype = DoctypeGetter.getDoctype(converterType);
        }
        return doctype;
    }

    private static String getDoctype(String converterType) {
        String toReturn = DOCTYPE_TO_CONVERTER_MAP.get(converterType);
        return toReturn == null ? "" : toReturn;
    }

    public static String getPublicDoctype(ConversionResult result, String converterType) {
        String doctype = result.getImposedPublicDoctype();
        if (result.getImposedPublicDoctype() == null) {
            doctype = DoctypeGetter.getPublicDoctype(converterType);
        }
        return doctype;
    }

    public static String getSystemDoctype(ConversionResult result, String converterType) {
        String doctype = result.getImposedSystemDoctype();
        if (result.getImposedSystemDoctype() == null) {
            doctype = DoctypeGetter.getSystemDoctype(converterType);
        }
        return doctype;
    }

    static {
        HashMap<String, String> converterToPublicDoctypeMap = new HashMap<String, String>();
        converterToPublicDoctypeMap.put("_html.to.dita", "-//OASIS//DTD DITA Topic//EN");
        converterToPublicDoctypeMap.put("_md.to.dita", "-//OASIS//DTD DITA Topic//EN");
        converterToPublicDoctypeMap.put("_excel.to.dita", "-//OASIS//DTD DITA Topic//EN");
        converterToPublicDoctypeMap.put("_word.to.dita", "-//OASIS//DTD DITA Topic//EN");
        converterToPublicDoctypeMap.put("_docbook.to.dita", "-//OASIS//DTD DITA Composite//EN");
        converterToPublicDoctypeMap.put("_confluence.to.ditamap", "-//OASIS//DTD DITA Map//EN");
        converterToPublicDoctypeMap.put("_confluence.topic.to.dita", "-//OASIS//DTD DITA Topic//EN");
        converterToPublicDoctypeMap.put("_openapi.to.dita", "-//OASIS//DTD DITA Composite//EN");
        converterToPublicDoctypeMap.put("_md.to.db4", "-//OASIS//DTD DocBook XML V4.5//EN");
        converterToPublicDoctypeMap.put("_html.to.db4", "-//OASIS//DTD DocBook XML V4.5//EN");
        converterToPublicDoctypeMap.put("_word.to.db4", "-//OASIS//DTD DocBook XML V4.5//EN");
        CONVERTER_TO_PUBLIC_DOCTYPE_MAP = Collections.unmodifiableMap(converterToPublicDoctypeMap);
        HashMap<String, String> systemDoctypeToConverterMap = new HashMap<String, String>();
        systemDoctypeToConverterMap.put("_html.to.dita", "topic.dtd");
        systemDoctypeToConverterMap.put("_md.to.dita", "topic.dtd");
        systemDoctypeToConverterMap.put("_excel.to.dita", "topic.dtd");
        systemDoctypeToConverterMap.put("_word.to.dita", "topic.dtd");
        systemDoctypeToConverterMap.put("_docbook.to.dita", "ditabase.dtd");
        systemDoctypeToConverterMap.put("_confluence.to.ditamap", "map.dtd");
        systemDoctypeToConverterMap.put("_confluence.topic.to.dita", "topic.dtd");
        systemDoctypeToConverterMap.put("_openapi.to.dita", "ditabase.dtd");
        systemDoctypeToConverterMap.put("_html.to.xhtml", "about:legacy-compat");
        systemDoctypeToConverterMap.put("_md.to.xhtml", "about:legacy-compat");
        systemDoctypeToConverterMap.put("_word.to.xhtml", "about:legacy-compat");
        systemDoctypeToConverterMap.put("_md.to.db4", "http://docbook.org/xml/4.5/docbookx.dtd");
        systemDoctypeToConverterMap.put("_html.to.db4", "http://docbook.org/xml/4.5/docbookx.dtd");
        systemDoctypeToConverterMap.put("_word.to.db4", "http://docbook.org/xml/4.5/docbookx.dtd");
        CONVERTER_TO_SYSTEM_DOCTYPE_MAP = Collections.unmodifiableMap(systemDoctypeToConverterMap);
        HashMap<String, String> doctypeToConverterMap = new HashMap<String, String>();
        doctypeToConverterMap.put("_html.to.dita", "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        doctypeToConverterMap.put("_md.to.dita", "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        doctypeToConverterMap.put("_excel.to.dita", "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        doctypeToConverterMap.put("_word.to.dita", "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        doctypeToConverterMap.put("_docbook.to.dita", "<!DOCTYPE dita PUBLIC \"-//OASIS//DTD DITA Composite//EN\" \"ditabase.dtd\">");
        doctypeToConverterMap.put("_confluence.to.ditamap", "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Map//EN\" \"map.dtd\">");
        doctypeToConverterMap.put("_confluence.topic.to.dita", "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        doctypeToConverterMap.put("_openapi.to.dita", "<!DOCTYPE dita PUBLIC \"-//OASIS//DTD DITA Composite//EN\" \"ditabase.dtd\">");
        doctypeToConverterMap.put("_html.to.xhtml", "<!DOCTYPE html>");
        doctypeToConverterMap.put("_md.to.xhtml", "<!DOCTYPE html>");
        doctypeToConverterMap.put("_word.to.xhtml", "<!DOCTYPE html>");
        doctypeToConverterMap.put("_md.to.db4", "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\"\n                         \"http://docbook.org/xml/4.5/docbookx.dtd\">");
        doctypeToConverterMap.put("_html.to.db4", "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\"\n                         \"http://docbook.org/xml/4.5/docbookx.dtd\">");
        doctypeToConverterMap.put("_word.to.db4", "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\"\n                         \"http://docbook.org/xml/4.5/docbookx.dtd\">");
        DOCTYPE_TO_CONVERTER_MAP = Collections.unmodifiableMap(doctypeToConverterMap);
    }
}

