/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.openapi;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ro.sync.basic.io.IOUtil;

public class OpenApiXmlToDITAConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult;
        URL xsltURL = this.getClass().getClassLoader().getResource("stylesheets/open-api/openApiXml2dita.xsl");
        try {
            StringBuilder inputContent = IOUtil.read((Reader)contentReader);
            StreamSource src = new StreamSource(xsltURL.toExternalForm());
            Transformer transformer = transformerCreator.createTransformer(src);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            String formatValue = userInputsProvider.getFormatForSameTypeReferences();
            if (formatValue != null) {
                transformer.setParameter("openApiXrefFormat", formatValue);
            }
            transformer.transform(new StreamSource(new StringReader(inputContent.toString()), originalFile.toURI().toString()), result);
            String ditaContent = sw.toString();
            conversionResult = new ConversionResult(ditaContent);
        }
        catch (TransformerException e) {
            Throwable exception = e;
            if (e.getException() != null) {
                exception = e.getException();
            }
            throw ConverterUtils.getTransformerException(exception);
        }
        catch (IOException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        return conversionResult;
    }
}

