/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.openapi;

import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiPostProcessingUtil;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import ro.sync.basic.xml.BasicXmlUtil;

public class OpenApiOriginalFormatConverterXmlFilter
extends XMLFilterImpl {
    private static final Logger logger = LoggerFactory.getLogger((String)OpenApiOriginalFormatConverterXmlFilter.class.getName());
    private static final String CONVERT_TO_ORIGINAL_FORMAT_OUTPUTCLASS = "oxy-originalFormatConvert";
    private boolean isInContentGatheringState;
    private StringBuilder contentToConvertToOriginalFormat = new StringBuilder();
    private String elementWithContentToConvert;

    public OpenApiOriginalFormatConverterXmlFilter(XMLReader xmlReader) {
        super(xmlReader);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isInContentGatheringState) {
            this.contentToConvertToOriginalFormat.append(String.valueOf(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isInContentGatheringState) {
            OpenApiOriginalFormatConverterXmlFilter.appendStartElementContent(this.contentToConvertToOriginalFormat, qName, atts);
        } else {
            String currentOutputclassValue = atts.getValue("outputclass");
            if (currentOutputclassValue != null && currentOutputclassValue.contains(CONVERT_TO_ORIGINAL_FORMAT_OUTPUTCLASS)) {
                this.elementWithContentToConvert = localName;
                this.isInContentGatheringState = true;
                this.contentToConvertToOriginalFormat.setLength(0);
                atts = OpenApiPostProcessingUtil.removeTokenFromOutputClassAttributeValue(atts, CONVERT_TO_ORIGINAL_FORMAT_OUTPUTCLASS);
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(this.elementWithContentToConvert)) {
            this.elementWithContentToConvert = null;
            this.isInContentGatheringState = false;
            String originalContent = OpenApiOriginalFormatConverterXmlFilter.convertContentToOriginalFormat(this.contentToConvertToOriginalFormat.toString());
            if (originalContent != null) {
                super.characters(originalContent.toCharArray(), 0, originalContent.length());
            }
        }
        if (this.isInContentGatheringState) {
            this.contentToConvertToOriginalFormat.append("</").append(qName).append('>');
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    private static String convertContentToOriginalFormat(String contentToConvert) {
        String toRet = null;
        try {
            JSONObject jsonObj = XML.toJSONObject((String)contentToConvert);
            int indentFactor = 2;
            toRet = jsonObj.toString(2, false);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage(), e.getCause());
            toRet = contentToConvert;
        }
        return toRet;
    }

    private static void appendStartElementContent(StringBuilder collector, String qName, Attributes atts) {
        collector.append('<').append(qName);
        int attrLength = atts.getLength();
        if (attrLength > 0) {
            collector.append(' ');
            for (int i = 0; i < attrLength; ++i) {
                collector.append(atts.getQName(i)).append("=\"");
                collector.append(BasicXmlUtil.escapeAttributeValue((String)atts.getValue(i))).append("\" ");
            }
        }
        collector.append('>');
    }
}

