/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.openapi;

import com.elovirta.dita.markdown.ExternalOptionProvider;
import com.elovirta.dita.markdown.MarkdownReader;
import com.oxygenxml.batch.converter.core.converters.markdown.MarkdownToDitaFilter;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiPostProcessingUtil;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class OpenApiMarkdownConverterXmlFilter
extends XMLFilterImpl {
    private static final Logger logger = LoggerFactory.getLogger((String)OpenApiMarkdownConverterXmlFilter.class.getName());
    private static final String CONVERT_TO_MARKDOWN_OUTPUTCLASS = "oxy-markdownConvert";
    private static final String CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV = "oxy-inBodydiv-markdownConvert";
    private String currentOutputclassValue;
    private StringBuilder textToConvert = new StringBuilder();
    private TransformerFactoryCreator transformerCreator;

    public OpenApiMarkdownConverterXmlFilter(XMLReader xmlReader, TransformerFactoryCreator transformerCreator) {
        super(xmlReader);
        this.transformerCreator = transformerCreator;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentOutputclassValue != null && (this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS) || this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV))) {
            this.textToConvert.append(String.valueOf(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.currentOutputclassValue != null && (this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS) || this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV))) {
            this.convertMarkdownText();
        }
        this.currentOutputclassValue = atts.getValue("outputclass");
        if (this.currentOutputclassValue != null && (this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS) || this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV))) {
            atts = OpenApiPostProcessingUtil.removeTokenFromOutputClassAttributeValue(atts, CONVERT_TO_MARKDOWN_OUTPUTCLASS);
            atts = OpenApiPostProcessingUtil.removeTokenFromOutputClassAttributeValue(atts, CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV);
        }
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentOutputclassValue != null && (this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS) || this.currentOutputclassValue.contains(CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV))) {
            this.convertMarkdownText();
        }
        super.endElement(uri, localName, qName);
    }

    private void convertMarkdownText() throws SAXException {
        final String markdownConvertOutputClass = this.currentOutputclassValue;
        this.currentOutputclassValue = null;
        String mdText = this.textToConvert.toString();
        this.textToConvert.setLength(0);
        if (!mdText.isEmpty()) {
            try (StringReader contentReader = new StringReader(mdText);
                 StringWriter sw = new StringWriter();){
                Transformer transformer = this.transformerCreator.createTransformer(null);
                MarkdownReader r = new MarkdownReader(new ExternalOptionProvider(){

                    public boolean shouldCreateShortdescParagraph() {
                        return false;
                    }

                    public boolean shouldHandleKeyrefs() {
                        return false;
                    }

                    public boolean isBatchConverterContext() {
                        return false;
                    }
                });
                transformer.transform(new SAXSource(new XMLFilterImpl(new MarkdownToDitaFilter((XMLReader)r)){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                        boolean wasHandleSpecialElement = this.handleSpecialElementEvent(uri, qName, true);
                        if (!wasHandleSpecialElement) {
                            OpenApiMarkdownConverterXmlFilter.this.startElement(uri, localName, qName, atts);
                        }
                        super.startElement(uri, localName, qName, atts);
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        OpenApiMarkdownConverterXmlFilter.this.characters(ch, start, length);
                        super.characters(ch, start, length);
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        boolean wasHandleSpecialElement = this.handleSpecialElementEvent(uri, qName, false);
                        if (!wasHandleSpecialElement) {
                            OpenApiMarkdownConverterXmlFilter.this.endElement(uri, localName, qName);
                        }
                        super.endElement(uri, localName, qName);
                    }

                    private boolean handleSpecialElementEvent(String uri, String qName, boolean isStartElement) throws SAXException {
                        boolean wasHandle = true;
                        switch (qName) {
                            case "dita": {
                                break;
                            }
                            case "topic": {
                                if (markdownConvertOutputClass.contains(OpenApiMarkdownConverterXmlFilter.CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV)) {
                                    this.fireParseEvent(uri, "section", isStartElement);
                                    break;
                                }
                                this.fireParseEvent(uri, "dl", isStartElement);
                                this.fireParseEvent(uri, "dlentry", isStartElement);
                                break;
                            }
                            case "title": {
                                if (markdownConvertOutputClass.contains(OpenApiMarkdownConverterXmlFilter.CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV)) {
                                    this.fireParseEvent(uri, qName, isStartElement);
                                    break;
                                }
                                this.fireParseEvent(uri, "dt", isStartElement);
                                break;
                            }
                            case "body": {
                                if (markdownConvertOutputClass.contains(OpenApiMarkdownConverterXmlFilter.CONVERT_TO_MARKDOWN_OUTPUTCLASS_IN_BODYDIV)) break;
                                this.fireParseEvent(uri, "dd", isStartElement);
                                break;
                            }
                            default: {
                                wasHandle = false;
                            }
                        }
                        return wasHandle;
                    }

                    private void fireParseEvent(String uri, String elementName, boolean isStartElement) throws SAXException {
                        if (isStartElement) {
                            OpenApiMarkdownConverterXmlFilter.this.startElement(uri, elementName, elementName, new AttributesImpl());
                        } else {
                            OpenApiMarkdownConverterXmlFilter.this.endElement(uri, elementName, elementName);
                        }
                    }
                }, new InputSource(contentReader)), new StreamResult(sw));
            }
            catch (RuntimeException | TransformerException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                this.characters(mdText.toCharArray(), 0, mdText.length());
            }
            catch (IOException e1) {
                logger.debug(e1.getMessage(), (Throwable)e1);
            }
        }
    }
}

