/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.markdown;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Extension;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.TransformerException;

public class MarkdownToHtmlConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        String convertedContent = null;
        DataHolder options = PegdownOptionsAdapter.flexmarkOptions((boolean)true, (int)-4128769, (Extension[])new Extension[0]);
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        String contentToParse = "";
        try {
            contentToParse = contentReader == null ? ConverterFileUtils.readFile(originalFile) : ConverterReaderUtils.getString(contentReader);
            Document document = parser.parse(contentToParse);
            convertedContent = renderer.render((Node)document);
        }
        catch (IOException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        return new ConversionResult(convertedContent);
    }
}

