/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.json;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.everit.json.schema.loader.SpecificationVersion;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.oxygen.jsonix.schema.compiler.ConversionOptions;
import ro.sync.oxygen.jsonix.schema.compiler.XSDtoJSONSchemaConverter;

public class XsdToJsonSchemaConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        final ArrayList<String> errors = new ArrayList<String>();
        try {
            Boolean restrictContent;
            ConversionOptions options = new ConversionOptions();
            options.setXsdSystemId(originalFile.toURI().toString());
            options.setOutputFolder(userInputsProvider.getOutputFolder());
            File outputFile = ConverterFileUtils.getUniqueOutputFile(originalFile, "json", userInputsProvider.getOutputFolder());
            options.setJsonSchemaName(outputFile.getName());
            options.setSchemaVersion(SpecificationVersion.DRAFT_2020_12.toString());
            Boolean preserveCase = userInputsProvider.getAdditionalOptionValue("preserve.case.of.names");
            if (preserveCase != null) {
                options.setPreserveCase(preserveCase.booleanValue());
            }
            if ((restrictContent = userInputsProvider.getAdditionalOptionValue("restrict.additional.content")) != null) {
                options.setRestrictAdditionalContent(restrictContent.booleanValue());
            }
            new XSDtoJSONSchemaConverter(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    errors.add(exception.getMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    errors.add(exception.getMessage());
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    errors.add(exception.getMessage());
                }
            }).convertXSDtoJSONSchema(options);
        }
        catch (IOException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        ConversionResult result = new ConversionResult(null);
        result.setShouldSkipPrinting(true);
        if (!errors.isEmpty()) {
            result.addConversionProblems(errors);
        }
        return result;
    }
}

