/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.json;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.TransformerException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class XmlToJsonConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        String convertedContent = null;
        String contentToParse = "";
        try {
            contentToParse = contentReader == null ? ConverterFileUtils.readFile(originalFile) : ConverterReaderUtils.getString(contentReader);
            JSONObject jsonObj = XML.toJSONObject((String)contentToParse);
            int indentFactor = 2;
            convertedContent = jsonObj.toString(2, false);
        }
        catch (IOException | JSONException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        return new ConversionResult(convertedContent);
    }
}

