/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.StylesheetConverter;
import java.net.URL;
import javax.xml.transform.Transformer;

public class XHTMLToDocbook5Converter
extends StylesheetConverter {
    private static final String[] ROOT_ATTRIBUTES = new String[]{"xmlns=\"http://docbook.org/ns/docbook\"", "xmlns:xlink=\"http://www.w3.org/1999/xlink\"", "version=\"5.0\""};
    private static final String ROOT_ELEMENT = "article";
    private static final String MATHML_MODELS = "<?xml-model href=\"http://docbook.org/xml/5.0/rng/docbook.rng\" type=\"application/xml\" schematypens=\"http://purl.oclc.org/dsdl/schematron\"?>\r\n<?xml-model href=\"http://www.oxygenxml.com/docbook/xml/5.0/rng/dbmathml.rng\" schematypens=\"http://relaxng.org/ns/structure/1.0\"?>\n";

    @Override
    public String getStylesheetPath() {
        URL xsltURL = this.getClass().getClassLoader().getResource("stylesheets/docbook/xhtml2db5Driver.xsl");
        return xsltURL.toExternalForm();
    }

    @Override
    public void setTransformationParam(Transformer transformer, ConversionInputsProvider inputsProvider) {
        transformer.setParameter("context.path.names", ROOT_ELEMENT);
        transformer.setParameter("context.path.uris", "http://docbook.org/ns/docbook");
        transformer.setParameter("replace.entire.root.contents", Boolean.TRUE);
        transformer.setParameter("wrapMultipleSectionsInARoot", Boolean.TRUE);
    }

    @Override
    public ConversionResult processConversionResult(String docbookContent) {
        ConversionResult conversionResult;
        if ((docbookContent = XHTMLToDocbook5Converter.updateArticleRootAttributes(docbookContent)).contains("mml:math")) {
            docbookContent = XHTMLToDocbook5Converter.addMathmlModels(docbookContent);
            conversionResult = new ConversionResult(docbookContent, "<!DOCTYPE article PUBLIC \"-//W3C//DTD MathML 2.0//EN\"\n                         \"http://www.w3.org/Math/DTD/mathml2/mathml2.dtd\">", "-//W3C//DTD MathML 2.0//EN", "http://www.w3.org/Math/DTD/mathml2/mathml2.dtd");
        } else {
            conversionResult = new ConversionResult(docbookContent);
        }
        return conversionResult;
    }

    private static String addMathmlModels(String documentContent) {
        int indexOfRootTag = ((String)documentContent).indexOf(ROOT_ELEMENT);
        if (indexOfRootTag != -1) {
            documentContent = ((String)documentContent).substring(0, indexOfRootTag - 1) + MATHML_MODELS + ((String)documentContent).substring(indexOfRootTag - 1);
        }
        return documentContent;
    }

    private static String updateArticleRootAttributes(String documentContent) {
        int indexOfRootTag = documentContent.indexOf(ROOT_ELEMENT);
        if (indexOfRootTag != -1) {
            int rootCloseTag = documentContent.indexOf(62);
            String rootContent = documentContent.substring(0, rootCloseTag);
            int nuOfAttributes = ROOT_ATTRIBUTES.length;
            StringBuilder attributesBuilder = new StringBuilder();
            for (int i = 0; i < nuOfAttributes; ++i) {
                String currentAttr = ROOT_ATTRIBUTES[i];
                if (rootContent.contains(currentAttr)) continue;
                attributesBuilder.append(' ').append(currentAttr);
            }
            if (attributesBuilder.length() > 0) {
                attributesBuilder.insert(0, documentContent.substring(0, rootCloseTag));
                attributesBuilder.append(documentContent.substring(rootCloseTag));
                documentContent = attributesBuilder.toString();
            }
        }
        return documentContent;
    }
}

