/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.w3c.tidy.Tidy;

public class HtmlToXhtmlConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFileLocation, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        String convertedContent = null;
        try (StringWriter sw = new StringWriter();){
            Tidy t = new Tidy();
            t.setXHTML(true);
            t.setQuiet(true);
            t.setDocType("omit");
            t.setShowWarnings(false);
            t.setTidyMark(false);
            t.setForceOutput(true);
            t.setDropProprietaryTags(false);
            t.setDropProprietaryAttributes(false);
            t.setTrimEmptyElements(false);
            t.setFixUri(false);
            if (contentReader == null) {
                contentReader = ConverterReaderUtils.createReader(originalFileLocation);
            }
            StringBuilder sb = new StringBuilder();
            int charBufSize = 1024;
            char[] cbuf = new char[1024];
            int len = -1;
            while ((len = contentReader.read(cbuf)) != -1) {
                sb.append(cbuf, 0, len);
            }
            t.parse((Reader)new StringReader(sb.toString()), (Writer)sw);
            convertedContent = sw.toString();
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
        finally {
            if (contentReader != null) {
                try {
                    contentReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new ConversionResult(convertedContent);
    }
}

