/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.PipelineConverter;
import com.oxygenxml.batch.converter.core.converters.html.CopyXHTMLResourcesConverter;
import com.oxygenxml.batch.converter.core.converters.html.HTML5Cleaner;
import com.oxygenxml.batch.converter.core.converters.html.HtmlToXhtmlConverter;
import com.oxygenxml.batch.converter.core.converters.html.XHTMLToDITAConverter;
import com.oxygenxml.batch.converter.core.converters.map.MapWithTopicsConverter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.util.ArrayList;

public class HtmlToDitaConverter
extends PipelineConverter {
    private final boolean shouldUpdateLocalFileReferences;
    private boolean shouldConvertClassToOutputclass;
    private boolean shouldCopyResources = true;

    public HtmlToDitaConverter() {
        this(false, true, true);
    }

    public HtmlToDitaConverter(boolean shouldUpdateLocalFileReferences) {
        this(shouldUpdateLocalFileReferences, true, true);
    }

    public HtmlToDitaConverter(boolean shouldUpdateLocalFileReferences, boolean shouldConvertClassToOutputclass, boolean shoudCopyResources) {
        this.shouldUpdateLocalFileReferences = shouldUpdateLocalFileReferences;
        this.shouldConvertClassToOutputclass = shouldConvertClassToOutputclass;
        this.shouldCopyResources = shoudCopyResources;
    }

    @Override
    protected Converter[] getUsedConverters(File fileToConvert, ConversionInputsProvider userInputsProvider, TransformerFactoryCreator transformerCreator) {
        Boolean filterDivElements;
        ArrayList<Converter> converters = new ArrayList<Converter>();
        converters.add(new HtmlToXhtmlConverter());
        converters.add(new HTML5Cleaner());
        Boolean shouldForbidCreatingExternalContent = userInputsProvider.getAdditionalOptionValue("forbid.creating.external.content");
        if (this.shouldCopyResources && (shouldForbidCreatingExternalContent == null || !shouldForbidCreatingExternalContent.booleanValue())) {
            converters.add(new CopyXHTMLResourcesConverter());
        }
        if ((filterDivElements = userInputsProvider.getAdditionalOptionValue("ignore.div.elements.from.html")) == null) {
            filterDivElements = false;
        }
        converters.add(new XHTMLToDITAConverter(this.shouldUpdateLocalFileReferences, this.shouldConvertClassToOutputclass, filterDivElements){

            @Override
            public boolean shouldAddAutoWidthColspecs() {
                return HtmlToDitaConverter.this.shouldAddAutoWidthColspecs();
            }
        });
        Boolean shouldCreateDitaMap = userInputsProvider.getAdditionalOptionValue("create.dita.map.from.html");
        if (shouldCreateDitaMap != null && shouldCreateDitaMap.booleanValue()) {
            converters.add(new MapWithTopicsConverter());
        }
        return converters.toArray(new Converter[0]);
    }

    public void setShouldCopyResources(boolean shouldCopyResources) {
        this.shouldCopyResources = shouldCopyResources;
    }

    public boolean shouldAddAutoWidthColspecs() {
        return false;
    }
}

