/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.excel;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.xml.BasicXmlUtil;

public class ExcelToDITAConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger((String)ExcelToDITAConverter.class.getName());

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        try {
            ConversionResult conversionResult = new ConversionResult(ExcelToDITAConverter.convertInternal(originalFile));
            return conversionResult;
        }
        catch (IOException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        finally {
            if (contentReader != null) {
                try {
                    contentReader.close();
                }
                catch (IOException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static String convertInternal(File originalFile) throws IOException {
        URL url = originalFile.toURI().toURL();
        InputStream is = ExcelToDITAConverter.getFileURLWithoutQuery(url).openStream();
        String[] nameAndExtension = ExcelToDITAConverter.getNameAndExtension(originalFile);
        StringBuilder topicContentBuilder = new StringBuilder().append("<topic id='").append(XmlUtil.getValidIDFromName(nameAndExtension[0])).append("'>").append("<title>").append(BasicXmlUtil.escape((String)nameAndExtension[0])).append("</title>").append("<body>");
        int headerRowsNo = ExcelToDITAConverter.getURLParamValueHeadersRowNo(url.getQuery());
        Workbook workbook = ExcelToDITAConverter.createWorkbook(nameAndExtension[1], is);
        int noSheets = workbook == null ? 0 : workbook.getNumberOfSheets();
        for (int i = 0; i < noSheets; ++i) {
            ExcelToDITAConverter.processSheet(workbook.getSheetAt(i), headerRowsNo, topicContentBuilder);
        }
        topicContentBuilder.append("</body>").append("</topic>");
        return topicContentBuilder.toString();
    }

    private static void processSheet(Sheet datatypeSheet, int headerRowsNo, StringBuilder sb) {
        Iterator iterator = datatypeSheet.iterator();
        if (iterator.hasNext()) {
            sb.append("<table id='").append(XmlUtil.getValidIDFromName(datatypeSheet.getSheetName())).append("'>");
            sb.append("<title>").append(BasicXmlUtil.escape((String)datatypeSheet.getSheetName())).append("</title>");
            ArrayList<String> rowsData = new ArrayList<String>();
            int maxColCount = 0;
            StringBuilder rowData = new StringBuilder();
            while (iterator.hasNext()) {
                rowData.append("<row>");
                Row currentRow = (Row)iterator.next();
                Iterator cellIterator = currentRow.iterator();
                int colCount = 0;
                while (cellIterator.hasNext()) {
                    ++colCount;
                    Cell currentCell = (Cell)cellIterator.next();
                    rowData.append("<entry>").append(BasicXmlUtil.escape((String)ExcelToDITAConverter.getImportRepresentation(currentCell, true))).append("</entry>");
                }
                maxColCount = Math.max(colCount, maxColCount);
                rowData.append("</row>");
                rowsData.add(rowData.toString());
                rowData.delete(0, rowData.length());
            }
            sb.append("<tgroup cols='").append(maxColCount).append("'>");
            if (headerRowsNo > 0) {
                sb.append("<thead>");
                for (int j = 0; j < headerRowsNo && j < rowsData.size(); ++j) {
                    sb.append((String)rowsData.get(j));
                }
                sb.append("</thead>");
            }
            sb.append("<tbody>");
            for (int j = headerRowsNo; j < rowsData.size(); ++j) {
                sb.append((String)rowsData.get(j));
            }
            sb.append("</tbody>").append("</tgroup>").append("</table>");
        }
    }

    public static String[] getNameAndExtension(File file) {
        String name = file.getName();
        String extension = "";
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex > -1) {
            extension = name.substring(dotIndex + 1);
            name = name.substring(0, dotIndex);
        }
        if (name.contains("/") && (name = name.substring(name.lastIndexOf(47) + 1, name.length())).contains(".")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return new String[]{name, extension};
    }

    private static final int getURLParamValueHeadersRowNo(String query) {
        int headerRowsNo = 1;
        if (query != null) {
            String[] paramNameValue = query.split("&");
            for (int i = 0; i < paramNameValue.length; ++i) {
                String nameValue = paramNameValue[i];
                String[] nameAndValue = nameValue.split("=");
                if (nameAndValue == null || nameAndValue.length != 2 || !"headerRowsNo".equals(nameAndValue[0])) continue;
                try {
                    headerRowsNo = NumberParserUtil.parseInt((String)nameAndValue[1]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return headerRowsNo;
    }

    private static final URL getFileURLWithoutQuery(URL url) throws MalformedURLException {
        String urlStr;
        if ("file".equals(url.getProtocol()) && (urlStr = url.toExternalForm()).contains("?")) {
            url = new URL(urlStr.substring(0, urlStr.indexOf(63)));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Workbook createWorkbook(String extension, InputStream is) throws IOException {
        XSSFWorkbook wb = null;
        try {
            if ("xlsx".equals(extension)) {
                wb = new XSSFWorkbook(is);
            } else {
                POIFSFileSystem fs = new POIFSFileSystem(is);
                wb = new HSSFWorkbook(fs);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return wb;
    }

    private static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        return DateUtil.isCellDateFormatted((Cell)cell);
    }

    private static String getImportRepresentation(Cell cell, boolean displayDataAsInExcel) {
        Object importPresentationString = "";
        if (cell == null) {
            return importPresentationString;
        }
        if (displayDataAsInExcel && cell.getCellType() == CellType.FORMULA) {
            displayDataAsInExcel = ExcelToDITAConverter.formulaCanBeEvaluated(cell);
        }
        DataFormatter df = new DataFormatter();
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (ExcelToDITAConverter.isCellDateFormatted(cell)) {
                    importPresentationString = ExcelToDITAConverter.getDescriptionOfDate(cell);
                    break;
                }
                if (displayDataAsInExcel) {
                    importPresentationString = df.formatCellValue(cell);
                    break;
                }
                importPresentationString = ExcelToDITAConverter.getNumericRepresentation(cell);
                break;
            }
            case STRING: {
                importPresentationString = displayDataAsInExcel ? df.formatCellValue(cell) : cell.getRichStringCellValue().getString();
                break;
            }
            case BLANK: {
                importPresentationString = "";
                break;
            }
            case BOOLEAN: {
                importPresentationString = displayDataAsInExcel ? df.formatCellValue(cell) : Boolean.toString(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                importPresentationString = "#ERROR: " + Byte.toString(cell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                importPresentationString = displayDataAsInExcel ? df.formatCellValue(cell) : ExcelToDITAConverter.getDescriptionOfFormula(cell);
                break;
            }
            default: {
                logger.debug("unsuported cell type {}", (Object)cell.getCellType());
            }
        }
        return importPresentationString;
    }

    private static final String getNumericRepresentation(Cell cell) {
        int intValue;
        double doubleValue = cell.getNumericCellValue();
        return doubleValue == (double)(intValue = (int)doubleValue) ? Integer.toString(intValue) : Double.toString(doubleValue);
    }

    private static boolean formulaCanBeEvaluated(Cell cell) {
        boolean formulaCanBeEvaluated = true;
        try {
            Object fe = null;
            fe = cell.getSheet().getWorkbook() instanceof HSSFWorkbook ? new HSSFFormulaEvaluator((HSSFWorkbook)cell.getSheet().getWorkbook()) : new XSSFFormulaEvaluator(new XSSFWorkbook());
            fe.evaluateInCell(cell);
        }
        catch (Exception e) {
            logger.warn("Could not evaluate the cell formula: {}", (Object)e.getMessage(), (Object)e);
            formulaCanBeEvaluated = false;
        }
        return formulaCanBeEvaluated;
    }

    private static String getDescriptionOfFormula(Cell cell) {
        Object descr = "";
        switch (cell.getCachedFormulaResultType()) {
            case NUMERIC: {
                if (ExcelToDITAConverter.isCellDateFormatted(cell)) {
                    descr = ExcelToDITAConverter.getDescriptionOfDate(cell);
                    break;
                }
                descr = ExcelToDITAConverter.getNumericRepresentation(cell);
                break;
            }
            case BOOLEAN: {
                descr = Boolean.toString(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                descr = "#ERROR: " + cell.getCellFormula();
                break;
            }
            case STRING: {
                descr = cell.getRichStringCellValue().getString();
                break;
            }
        }
        return descr;
    }

    private static String getDescriptionOfDate(Cell cell) {
        DataFormatter formatter = new DataFormatter();
        return formatter.formatCellValue(cell);
    }
}

