/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.confluence;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.converters.StylesheetConverter;
import com.oxygenxml.batch.converter.core.converters.confluence.ConfluenceTopicToDitaConverter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinterCreater;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.sync.basic.util.URLUtil;

public class ConfluenceIndexHTMLToDitaMapConverter
extends StylesheetConverter {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceIndexHTMLToDitaMapConverter.class);
    private static final String MAPPING_FILE_PATH = "oxy-confluence-topics-mapping.xml";
    private static final String MAPPING_XPATH_STRING = "//mapping";
    protected Boolean shouldDeleteMappingFile;

    public ConfluenceIndexHTMLToDitaMapConverter(boolean shouldDeleteMappingFile) {
        this.shouldDeleteMappingFile = shouldDeleteMappingFile;
    }

    @Override
    public String getStylesheetPath() {
        URL confXsltURL = this.getClass().getClassLoader().getResource("stylesheets/confluence/index2DITAMAP.xsl");
        return confXsltURL.toExternalForm();
    }

    @Override
    public void setTransformationParam(Transformer transformer, ConversionInputsProvider inputsProvider) {
        transformer.setParameter("output.base.uri", URLUtil.convertToURL((String)inputsProvider.getOutputFolder().getAbsolutePath()).toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult = super.convert(originalFile, contentReader, transformerCreator, userInputsProvider);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        File mappingFile = new File(userInputsProvider.getOutputFolder(), MAPPING_FILE_PATH);
        try {
            NodeList nodes = ConfluenceIndexHTMLToDitaMapConverter.getTopicsMappingNodes(factory, mappingFile);
            if (nodes != null) {
                ConfluenceIndexHTMLToDitaMapConverter.convertConfluenceTopics2DitaTopics(originalFile, transformerCreator, userInputsProvider, nodes);
            }
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        catch (IOException e) {
            conversionResult.addConversionProblem(e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            if (Boolean.TRUE.equals(this.shouldDeleteMappingFile)) {
                try {
                    Files.delete(mappingFile.toPath());
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return conversionResult;
    }

    private static NodeList getTopicsMappingNodes(DocumentBuilderFactory factory, File mappingFile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        factory.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(mappingFile);
        XPathFactory xpathfactory = XPathFactory.newInstance();
        XPath xpath = xpathfactory.newXPath();
        XPathExpression expr = xpath.compile(MAPPING_XPATH_STRING);
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        return (NodeList)result;
    }

    private static void convertConfluenceTopics2DitaTopics(File originalFile, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider, NodeList nodes) throws TransformerException, IOException {
        ConfluenceTopicToDitaConverter topicConverter = new ConfluenceTopicToDitaConverter();
        ContentPrinter printer = ContentPrinterCreater.create("_confluence.topic.to.dita");
        File inputDirectoryPath = originalFile.getParentFile();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attributes = nodes.item(i).getAttributes();
            if (attributes == null) continue;
            String inputFilePath = attributes.getNamedItem("in").getNodeValue();
            String outputFilePath = attributes.getNamedItem("out").getNodeValue();
            outputFilePath = URLUtil.uncorrect((String)outputFilePath);
            File inputTopicFile = new File(inputDirectoryPath, inputFilePath);
            File outputTopicFile = new File(userInputsProvider.getOutputFolder(), outputFilePath);
            ConversionInputsProvider userTopicInputsProvider = ConfluenceIndexHTMLToDitaMapConverter.createInputsProviderForTopic(userInputsProvider, outputTopicFile);
            ConversionResult conversionTopicResult = topicConverter.convert(inputTopicFile, ConverterReaderUtils.createReader(inputTopicFile), transformerCreator, userTopicInputsProvider);
            printer.print(conversionTopicResult, transformerCreator, "_confluence.topic.to.dita", outputTopicFile);
        }
    }

    private static ConversionInputsProvider createInputsProviderForTopic(final ConversionInputsProvider userInputsProvider, final File outputTopicFile) {
        return new ConversionInputsProvider(){

            @Override
            public File getOutputFolder() {
                return outputTopicFile.getParentFile();
            }

            @Override
            public Integer getMaxHeadingLevelForCreatingTopics() {
                return userInputsProvider.getMaxHeadingLevelForCreatingTopics();
            }

            @Override
            public List<File> getInputFiles() {
                return userInputsProvider.getInputFiles();
            }

            @Override
            public Boolean getAdditionalOptionValue(String additionalOptionId) {
                Boolean toReturn = userInputsProvider.getAdditionalOptionValue(additionalOptionId);
                if ("ignore.div.elements.from.html".equals(additionalOptionId)) {
                    toReturn = true;
                }
                return toReturn;
            }

            @Override
            public String getFormatForSameTypeReferences() {
                return userInputsProvider.getFormatForSameTypeReferences();
            }
        };
    }
}

