/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class StylesheetConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult;
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        StreamSource src = new StreamSource(this.getStylesheetPath());
        Transformer transformer = transformerCreator.createTransformer(src);
        this.setTransformationParam(transformer, userInputsProvider);
        try {
            transformer.transform(this.createTransformationSource(originalFile, contentReader, userInputsProvider), result);
            conversionResult = this.processConversionResult(sw.toString());
        }
        catch (TransformerException e) {
            if (e.getException() != null) {
                throw ConverterUtils.getTransformerException(e);
            }
            throw e;
        }
        return conversionResult;
    }

    public abstract String getStylesheetPath();

    public Source createTransformationSource(File originalFile, Reader contentReader, ConversionInputsProvider userInputsProvider) {
        return new StreamSource(contentReader, originalFile.toURI().toString());
    }

    public void setTransformationParam(Transformer transformer, ConversionInputsProvider inputsProvider) {
    }

    public ConversionResult processConversionResult(String conversionResult) {
        return new ConversionResult(conversionResult);
    }
}

