/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.TransformerException;

public abstract class PipelineConverter
implements Converter {
    protected abstract Converter[] getUsedConverters(File var1, ConversionInputsProvider var2, TransformerFactoryCreator var3);

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult result = new ConversionResult("");
        Converter[] converters = this.getUsedConverters(originalFile, userInputsProvider, transformerCreator);
        int noOfCoverters = converters.length;
        for (int i = 0; i < noOfCoverters; ++i) {
            ConversionResult currentResult;
            if (i != 0) {
                contentReader = new StringReader(result.getConvertedContent());
            }
            if ((currentResult = converters[i].convert(originalFile, contentReader, transformerCreator, userInputsProvider)).shouldSkipConversionResult()) continue;
            currentResult.addConversionProblems(result.getConversionProblems());
            currentResult.reconfigureImposedDoctype(result);
            result = currentResult;
        }
        return result;
    }
}

