/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import java.util.ArrayList;
import java.util.List;

public class ConversionResult {
    String convertedContent;
    String imposedDoctype;
    String imposedPublicDoctype;
    String imposedSystemDoctype;
    String imposedOutputFileExtension;
    private boolean shouldSkipConversionResult;
    private boolean shouldPreserveInitialImposedDoctype;
    private boolean shouldSkipPrinting;
    private final List<String> conversionProblems = new ArrayList<String>();

    public ConversionResult(String convertedContent) {
        this(convertedContent, null, null, null);
    }

    public ConversionResult(String convertedContent, String imposedDoctype, String imposedPublicDoctype, String imposedSystemDoctype, String imposedOutputFileExtension) {
        this.convertedContent = convertedContent;
        this.imposedDoctype = imposedDoctype;
        this.imposedPublicDoctype = imposedPublicDoctype;
        this.imposedSystemDoctype = imposedSystemDoctype;
        this.imposedOutputFileExtension = imposedOutputFileExtension;
    }

    public ConversionResult(String convertedContent, String imposedDoctypeType, String imposedPublicDoctype, String imposedSystemDoctype) {
        this(convertedContent, imposedDoctypeType, imposedPublicDoctype, imposedSystemDoctype, null);
    }

    public String getConvertedContent() {
        return this.convertedContent != null ? this.convertedContent : "";
    }

    public String getImposedDoctype() {
        return this.imposedDoctype;
    }

    public String getImposedPublicDoctype() {
        return this.imposedPublicDoctype;
    }

    public String getImposedSystemDoctype() {
        return this.imposedSystemDoctype;
    }

    public String getImposedOutputFileExtension() {
        return this.imposedOutputFileExtension;
    }

    public void setSkipConversionResult() {
        this.shouldSkipConversionResult = true;
    }

    public boolean shouldSkipConversionResult() {
        return this.shouldSkipConversionResult;
    }

    public void setPreserveInitialImposedDoctype(boolean preserveInitialImposedDoctype) {
        this.shouldPreserveInitialImposedDoctype = preserveInitialImposedDoctype;
    }

    public void addConversionProblem(String problem) {
        this.conversionProblems.add(problem);
    }

    public void addConversionProblems(List<String> problems) {
        this.conversionProblems.addAll(problems);
    }

    public List<String> getConversionProblems() {
        return this.conversionProblems;
    }

    public void reconfigureImposedDoctype(ConversionResult previous) {
        if (this.shouldPreserveInitialImposedDoctype) {
            this.imposedDoctype = previous.getImposedDoctype();
            this.imposedPublicDoctype = previous.getImposedPublicDoctype();
            this.imposedSystemDoctype = previous.getImposedSystemDoctype();
            this.shouldPreserveInitialImposedDoctype = false;
        }
    }

    public boolean shouldSkipPrinting() {
        return this.shouldSkipPrinting;
    }

    public void setShouldSkipPrinting(boolean shouldSkipPrinting) {
        this.shouldSkipPrinting = shouldSkipPrinting;
    }
}

