/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractXMLResourcesParser
implements Converter {
    protected static final EntityResolver DEFAULT_ENTITY_RESOLVER = (publicId, systemId) -> new InputSource(new StringReader(""));

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult = null;
        try {
            ArrayList<String> problemsCollector = new ArrayList<String>();
            Transformer transformer = transformerCreator.createTransformer(null);
            XMLReader reader = this.createResourcesProcessor(originalFile, userInputsProvider, problemsCollector);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(new SAXSource(reader, new InputSource(contentReader)), result);
            conversionResult = new ConversionResult(sw.toString());
            conversionResult.addConversionProblems(problemsCollector);
        }
        catch (Exception e) {
            throw new TransformerException(e.getMessage(), e);
        }
        return conversionResult;
    }

    protected XMLReader createResourcesProcessor(File inputFile, ConversionInputsProvider userInputsProvider, List<String> problemsCollector) throws SAXException, ParserConfigurationException {
        XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(DEFAULT_ENTITY_RESOLVER);
        return this.createXMLFilterImp(xmlReader, inputFile, userInputsProvider, problemsCollector);
    }

    protected abstract XMLReader createXMLFilterImp(XMLReader var1, File var2, ConversionInputsProvider var3, List<String> var4);
}

