/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.AbstractXMLResourcesParser;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import com.oxygenxml.batch.converter.core.utils.ResourceTypes;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;

public abstract class AbstractCopyResourcesConverter
extends AbstractXMLResourcesParser {
    protected static final Set<String> IMAGE_FILES_EXTENSIONS = new HashSet<String>(Arrays.asList(".gif", ".jpg", ".jpeg", ".png", ".bmp", ".tif", ".tiff", ".emf", ".svg", ".svgz"));
    protected static final Set<String> BINARY_FILES_EXTENSIONS = new HashSet<String>(Arrays.asList(".ttf", ".eot", ".woff*", ".otf", ".webm", ".pdf", ".doc", ".eps", ".exe", ".dll", ".icns", ".so", ".sys", ".avi", ".swf", ".fla", ".mp3", ".m4a", ".mpa", ".mp4", ".mpg", ".mpeg", ".wmv", ".qt", ".vob", ".wav", ".flv", ".class", ".chm", ".epub", ".mobi", ".zip", ".jar", ".docx", ".dotx", ".dotm", ".ods", ".odp", ".odt", ".ott", ".rar", ".tar", ".gz", ".bz2", ".o", ".a", ".ai", ".pfm", ".ttc"));
    protected static final Set<String> MEDIA_FILES_EXTENSION = new HashSet<String>(Arrays.asList(".mp3", ".mp4", ".m4a", ".flac", ".waw", ".wav", ".wma", ".aac", ".mov", ".wmw", ".avi", ".flv", ".avchd", ".webm", ".gifv"));

    protected abstract ResourceTypes getResourceType(String var1);

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult = null;
        if (URLUtil.getCanonicalFile((File)originalFile.getParentFile()).equals(URLUtil.getCanonicalFile((File)userInputsProvider.getOutputFolder()))) {
            try {
                conversionResult = new ConversionResult(IOUtil.read((Reader)contentReader).toString());
            }
            catch (IOException e) {
                throw new TransformerException(e.getMessage(), e);
            }
        } else {
            conversionResult = super.convert(originalFile, contentReader, transformerCreator, userInputsProvider);
        }
        return conversionResult;
    }

    protected Attributes copyResourceAndGetUpdatedAttribute(File resourceToCopy, ResourceTypes resourceType, Attributes atts, String attrQualifiedName, File outputFolder, List<String> problemsCollector) {
        String newSrcValue = ConverterFileUtils.copyResource(resourceToCopy, resourceType, outputFolder, problemsCollector);
        AttributesImpl attributesImpl = new AttributesImpl(atts);
        attributesImpl.setValue(attributesImpl.getIndex(attrQualifiedName), newSrcValue);
        return attributesImpl;
    }

    protected static boolean isAlowedToCopy(String path) {
        return path != null && URLUtil.isRelativePath((String)path);
    }
}

