/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core;

import com.oxygenxml.batch.converter.core.ConversionFormat;
import java.util.HashMap;
import java.util.Map;

public class ConversionFormatUtil {
    private static final String HTML = "html";
    private static final String XHTML = "xhtml";
    private static final String DITA = "dita";
    private static final String EXCEL = "excel";
    private static final String WORD = "word";
    private static final String XML = "xml";
    private static final String JSON = "json";
    private static final String YAML = "yaml";
    private static final String MARKDOWN = "markdown";
    private static final String MD = "md";
    private static final String DB = "db";
    private static final String DB5 = "db5";
    private static final String DB4 = "db4";
    private static final String DOCBOOK = "docbook";
    private static final String DOCBOOK4 = "docbook4";
    private static final String DOCBOOK5 = "docbook5";
    private static final String CONFLUENCE = "confluence";
    private static final String OPENAPI = "openapi";
    private static final String XSD = "xsd";
    private static final String JSON_SCHEMA = "json";
    private static final Map<ConversionFormat, String> CONVERSION_FORMATS_TO_CONVERTER_TYPES = new HashMap<ConversionFormat, String>();

    protected ConversionFormatUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getConverterType(String inputFormat, String outputFormat) {
        return CONVERSION_FORMATS_TO_CONVERTER_TYPES.get(new ConversionFormat(inputFormat.toLowerCase(), outputFormat.toLowerCase()));
    }

    public static boolean isSupportedConversionFormat(String inputFormat, String outputFormat) {
        return CONVERSION_FORMATS_TO_CONVERTER_TYPES.containsKey(new ConversionFormat(inputFormat.toLowerCase(), outputFormat.toLowerCase()));
    }

    static {
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(HTML, DITA), "_html.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MD, DITA), "_md.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MARKDOWN, DITA), "_md.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(EXCEL, DITA), "_excel.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(WORD, DITA), "_word.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(CONFLUENCE, DITA), "_confluence.to.ditamap");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(DOCBOOK, DITA), "_docbook.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(DB, DITA), "_docbook.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(DB4, DITA), "_docbook.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(DB5, DITA), "_docbook.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(DOCBOOK4, DITA), "_docbook.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(DOCBOOK5, DITA), "_docbook.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(OPENAPI, DITA), "_openapi.to.dita");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(XML, "json"), "_xml.to.json");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat("json", XML), "_json.to.xml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(YAML, "json"), "_yaml.to.json");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat("json", YAML), "_json.to.yaml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(XSD, "json"), "_xsd.to.json");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(YAML, XML), "_yaml.to.xml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(XML, YAML), "_xml.to.yaml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(HTML, XHTML), "_html.to.xhtml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MD, XHTML), "_md.to.xhtml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MARKDOWN, XHTML), "_md.to.xhtml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(WORD, XHTML), "_word.to.xhtml");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(HTML, DB4), "_html.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(HTML, DOCBOOK4), "_html.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MD, DB4), "_md.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MD, DOCBOOK4), "_md.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MARKDOWN, DB4), "_md.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MARKDOWN, DOCBOOK4), "_md.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(WORD, DB4), "_word.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(WORD, DOCBOOK4), "_word.to.db4");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(HTML, DB5), "_html.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(HTML, DOCBOOK5), "_html.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MD, DB5), "_md.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MD, DOCBOOK5), "_md.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MARKDOWN, DB5), "_md.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(MARKDOWN, DOCBOOK5), "_md.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(WORD, DB5), "_word.to.db5");
        CONVERSION_FORMATS_TO_CONVERTER_TYPES.put(new ConversionFormat(WORD, DOCBOOK5), "_word.to.db5");
    }
}

