/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.ChunkMapReader;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractChunkTopicParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ChunkTopicParser
extends AbstractChunkTopicParser {
    @Override
    public void write(URI currentFile) {
        this.currentFile = currentFile;
        try {
            this.output = new StringWriter();
            this.processChunk(this.rootTopicref, null);
        }
        finally {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processChunk(Element topicref, URI outputFile) {
        URI hrefValue = URLUtils.toURI((String)XMLUtils.getValue((Element)topicref, (String)"href"));
        Collection chunkValue = StringUtils.split((String)XMLUtils.getValue((Element)topicref, (String)"chunk"));
        URI copytoValue = URLUtils.toURI((String)XMLUtils.getValue((Element)topicref, (String)"copy-to"));
        String scopeValue = XMLUtils.getCascadeValue((Element)topicref, (String)"scope");
        String classValue = XMLUtils.getValue((Element)topicref, (String)"class");
        String processRoleValue = XMLUtils.getCascadeValue((Element)topicref, (String)"processing-role");
        String formatValue = XMLUtils.getValue((Element)topicref, (String)"format");
        URI outputFileName = outputFile;
        Writer tempWriter = null;
        Set tempTopicID = null;
        this.targetTopicId = null;
        this.selectMethod = "select-document";
        this.include = false;
        boolean needWriteDitaTag = true;
        try {
            URI parseFilePath = copytoValue != null && !chunkValue.contains("to-content") ? (hrefValue.getFragment() != null ? URLUtils.setFragment((URI)copytoValue, (String)hrefValue.getFragment()) : copytoValue) : hrefValue;
            if (parseFilePath != null && !"external".equals(scopeValue) && GenListModuleReader.isFormatDita((String)formatValue)) {
                String s;
                String firstTopicID;
                if (chunkValue.contains("to-content")) {
                    tempWriter = this.output;
                    tempTopicID = this.topicID;
                    this.output = new StringWriter();
                    this.topicID = new HashSet();
                    if (Constants.MAP_MAP.matches(classValue)) {
                        outputFileName = this.currentFile.resolve(parseFilePath);
                        needWriteDitaTag = false;
                    } else {
                        String firstTopic;
                        outputFileName = copytoValue != null ? this.currentFile.resolve(copytoValue) : (hrefValue != null ? (chunkValue.contains("select-topic") || chunkValue.contains("select-branch") ? (hrefValue.getFragment() != null ? this.currentFile.resolve(hrefValue.getFragment() + ".dita") : ((firstTopic = this.getFirstTopicId(new File(URLUtils.stripFragment((URI)this.currentFile.resolve(hrefValue))))) != null ? this.currentFile.resolve(firstTopic + ".dita") : this.currentFile.resolve(hrefValue))) : this.currentFile.resolve(hrefValue)) : this.generateOutputFile(this.currentFile));
                    }
                    if (this.job.getStore().exists(outputFileName) && !Constants.MAP_MAP.matches(classValue)) {
                        URI t = outputFileName;
                        outputFileName = this.generateOutputFile(this.currentFile);
                        this.conflictTable.put(outputFileName, t);
                    }
                    this.changeTable.put(outputFileName, outputFileName);
                    Job.FileInfo fi = this.generateFileInfo(outputFileName);
                    this.job.add(fi);
                }
                this.outputFile = outputFileName;
                URI path = this.currentFile.resolve(parseFilePath);
                URI newpath = path.getFragment() != null ? URLUtils.setFragment((URI)outputFileName, (String)path.getFragment()) : ((firstTopicID = this.getFirstTopicId(new File(path))) != null && !chunkValue.contains("to-content") ? URLUtils.setFragment((URI)outputFileName, (String)firstTopicID) : outputFileName);
                this.changeTable.put(path, newpath);
                topicref.setAttribute("href", URLUtils.getRelativePath((URI)this.currentFile.resolve("stub.ditamap"), (URI)newpath).toString());
                if (parseFilePath.getFragment() != null) {
                    this.targetTopicId = parseFilePath.getFragment();
                }
                if ((s = ChunkMapReader.getChunkByToken(chunkValue, "select-", null)) != null) {
                    this.selectMethod = s;
                    if (this.targetTopicId == null) {
                        this.selectMethod = "select-document";
                    }
                }
                URI tempPath = this.currentParsingFile;
                this.currentParsingFile = this.currentFile.resolve(parseFilePath);
                if (!"resource-only".equals(processRoleValue)) {
                    this.currentParsingFileTopicIDChangeTable = new HashMap();
                    this.logger.info("Processing " + this.currentParsingFile);
                    this.job.getStore().transform(this.currentParsingFile, (ContentHandler)((Object)this));
                    if (this.currentParsingFileTopicIDChangeTable.size() > 0) {
                        String new_elementid;
                        String old_elementid;
                        URI href = URLUtils.toURI((String)topicref.getAttribute("href"));
                        String pathtoElem = href.getFragment() != null ? href.getFragment() : "";
                        String string = old_elementid = pathtoElem.contains("/") ? pathtoElem.substring(0, pathtoElem.indexOf("/")) : pathtoElem;
                        if (!old_elementid.isEmpty() && (new_elementid = (String)this.currentParsingFileTopicIDChangeTable.get(old_elementid)) != null && !new_elementid.isEmpty()) {
                            topicref.setAttribute("href", URLUtils.setFragment((URI)href, (String)new_elementid).toString());
                        }
                    }
                    this.currentParsingFileTopicIDChangeTable = null;
                }
                this.currentParsingFile = tempPath;
            }
            if (topicref.hasChildNodes()) {
                StringWriter tempOutput = (StringWriter)this.output;
                this.output = new StringWriter();
                NodeList children = topicref.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node current = children.item(i);
                    if (!Constants.MAP_TOPICREF.matches(current)) continue;
                    this.processChunk((Element)current, outputFileName);
                }
                StringBuffer parentResult = tempOutput.getBuffer();
                StringBuffer tmpContent = ((StringWriter)this.output).getBuffer();
                if (parentResult.length() > 0 && parseFilePath != null && !"resource-only".equals(processRoleValue)) {
                    this.insertAfter(hrefValue, parentResult, tmpContent);
                } else {
                    parentResult.append((CharSequence)tmpContent);
                }
                this.output = tempOutput;
            }
            if (chunkValue.contains("to-content")) {
                String tmpContent = this.output.toString();
                this.writeToContentChunk(tmpContent, outputFileName, needWriteDitaTag);
                this.output = tempWriter;
                this.topicID = tempTopicID;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void insertAfter(URI hrefValue, StringBuffer parentResult, CharSequence tmpContent) {
        int insertpoint = parentResult.lastIndexOf("</");
        int end = parentResult.indexOf(">", insertpoint);
        if (insertpoint == -1 || end == -1) {
            this.logger.error(MessageUtils.getMessage((String)"DOTJ033E", (String[])new String[]{hrefValue.toString()}).toString());
        } else {
            if ("dita".equals(parentResult.substring(insertpoint, end).trim())) {
                insertpoint = parentResult.lastIndexOf("</", insertpoint - 1);
            }
            parentResult.insert(insertpoint, tmpContent);
        }
    }

    private void writeToContentChunk(String tmpContent, URI outputFileName, boolean needWriteDitaTag) throws IOException {
        assert (outputFileName.isAbsolute());
        this.logger.info("Writing " + outputFileName);
        try (OutputStreamWriter ditaFileOutput = new OutputStreamWriter(this.job.getStore().getOutputStream(outputFileName), StandardCharsets.UTF_8);){
            if (outputFileName.equals(this.changeTable.get(outputFileName))) {
                this.writeStartDocument(ditaFileOutput);
                URI workDir = outputFileName.resolve(".");
                if (!Constants.OS_NAME.toLowerCase().contains("windows")) {
                    this.writeProcessingInstruction(ditaFileOutput, "workdir", new File(workDir).getAbsolutePath());
                } else {
                    this.writeProcessingInstruction(ditaFileOutput, "workdir", "/" + new File(workDir).getAbsolutePath());
                }
                this.writeProcessingInstruction(ditaFileOutput, "workdir-uri", workDir.toString());
                File path2rootmap = URLUtils.toFile((URI)URLUtils.getRelativePath((URI)outputFileName, (URI)this.job.getInputMap())).getParentFile();
                this.writeProcessingInstruction(ditaFileOutput, "path2rootmap-uri", path2rootmap == null ? "./" : URLUtils.toURI((File)path2rootmap).toString());
                URI initialLocation = (URI)this.conflictTable.get(outputFileName);
                String relativePath = FileUtils.getRelativeUnixPath((String)(new File(this.currentFile.resolve(".")) + "/stub.ditamap"), (String)new File(initialLocation != null ? initialLocation : outputFileName).getAbsolutePath());
                String path2project = FileUtils.getRelativeUnixPath((String)relativePath);
                if (null == path2project) {
                    path2project = "";
                }
                this.writeProcessingInstruction(ditaFileOutput, "path2project", path2project);
                this.writeProcessingInstruction(ditaFileOutput, "path2project-uri", path2project.isEmpty() ? "./" : URLUtils.toURI((String)path2project).toString());
            }
            if (needWriteDitaTag) {
                AttributesImpl atts = new AttributesImpl();
                XMLUtils.addOrSetAttribute((AttributesImpl)atts, (String)"xmlns:ditaarch", (String)"http://dita.oasis-open.org/architecture/2005/");
                XMLUtils.addOrSetAttribute((AttributesImpl)atts, (String)"ditaarch:DITAArchVersion", (String)"1.3");
                this.writeStartElement(ditaFileOutput, "dita", atts);
            }
            ditaFileOutput.write(tmpContent);
            if (needWriteDitaTag) {
                this.writeEndElement(ditaFileOutput, "dita");
            }
            ((Writer)ditaFileOutput).flush();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String cls = atts.getValue("class");
        String id = atts.getValue("id");
        if (this.skip && this.skipLevel > 0) {
            ++this.skipLevel;
        }
        if (Constants.TOPIC_TOPIC.matches(cls)) {
            this.topicSpecSet.add(qName);
            this.processSelect(id);
        }
        if (this.include) {
            ++this.includelevel;
            AttributesImpl resAtts = new AttributesImpl(this.checkForNSDeclaration(atts, uri));
            this.writeStartElement(this.output, qName, resAtts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!Objects.equals(uri, "") && this.namespaceMap.containsKey(uri)) {
            this.decreaseNamespaceLevel(uri);
        }
        if (this.skip && this.skipLevel > 0) {
            --this.skipLevel;
        } else if (this.skip) {
            this.include = true;
            this.skip = false;
            this.skipLevel = 0;
        }
        if (this.include) {
            --this.includelevel;
            if (this.includelevel >= 0) {
                this.writeEndElement(this.output, qName);
            }
            if (this.includelevel == 0 && !"select-document".equals(this.selectMethod)) {
                this.include = false;
            }
        }
    }

    private void increaseNamespaceLevel(String uri) {
        this.namespaceMap.put(uri, (Integer)this.namespaceMap.get(uri) + 1);
    }

    private void decreaseNamespaceLevel(String uri) {
        this.namespaceMap.put(uri, (Integer)this.namespaceMap.get(uri) - 1);
    }

    private Attributes checkForNSDeclaration(Attributes atts, String uri) {
        AttributesImpl resAtts = null;
        if (!Objects.equals(uri, "")) {
            if (this.namespaceMap.containsKey(uri)) {
                this.increaseNamespaceLevel(uri);
            } else {
                this.namespaceMap.put(uri, 1);
            }
            resAtts = new AttributesImpl(this.processAttributesNS(atts, uri));
        } else {
            resAtts = new AttributesImpl(this.processAttributes(atts));
        }
        return resAtts;
    }
}

