/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.ChunkModule;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.Job;
import org.dita.dost.util.TopicIdParser;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractChunkTopicParser
extends AbstractXMLWriter {
    LinkedHashMap<URI, URI> changeTable = null;
    Map<URI, URI> conflictTable = null;
    Element rootTopicref = null;
    URI currentFile = null;
    URI currentParsingFile = null;
    URI outputFile = null;
    String targetTopicId = null;
    String selectMethod = "select-document";
    boolean include = false;
    boolean skip = false;
    int includelevel = 0;
    int skipLevel = 0;
    final Set<String> topicSpecSet = new HashSet<String>(16);
    boolean startFromFirstTopic = false;
    Writer output = null;
    Set<String> topicID = new HashSet<String>();
    Map<String, String> currentParsingFileTopicIDChangeTable;
    TempFileNameScheme tempFileNameScheme;
    private ChunkModule.ChunkFilenameGenerator chunkFilenameGenerator;
    final NamespaceSupport namespaces = new NamespaceSupport();
    final HashMap<String, Integer> namespaceMap = new HashMap();
    private Map<String, String> lastPrefixNamespaceMappings = new HashMap<String, String>();

    public void setJob(Job job) {
        super.setJob(job);
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
    }

    public abstract void write(URI var1);

    public void write(File fileDir) throws DITAOTException {
        throw new UnsupportedOperationException();
    }

    public void setup(LinkedHashMap<URI, URI> changeTable, Map<URI, URI> conflictTable, Element rootTopicref, ChunkModule.ChunkFilenameGenerator chunkFilenameGenerator) {
        this.changeTable = changeTable;
        this.rootTopicref = rootTopicref;
        this.conflictTable = conflictTable;
        this.chunkFilenameGenerator = chunkFilenameGenerator;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.include) {
            try {
                this.output.write(XMLUtils.escapeXML((char[])ch, (int)start, (int)length));
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public void endDocument() throws SAXException {
        this.include = false;
        this.skip = false;
    }

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.include) {
            try {
                this.output.write(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.include || "workdir".equals(target) || "workdir-uri".equals(target) || "path2project".equals(target) || "path2project-uri".equals(target) || "path2rootmap-uri".equals(target)) {
            this.writeProcessingInstruction(this.output, target, data);
        }
    }

    public void startDocument() throws SAXException {
        if ("select-document".equals(this.selectMethod)) {
            if (this.currentParsingFile.equals(this.outputFile)) {
                this.include = true;
                this.skip = false;
                this.skipLevel = 0;
            } else {
                this.include = false;
                this.startFromFirstTopic = true;
                this.skip = false;
                this.skipLevel = 0;
            }
        }
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    void processSelect(String id) {
        if (this.include) {
            if ("select-topic".equals(this.selectMethod)) {
                this.include = false;
                this.skipLevel = 1;
                this.skip = true;
            } else if (!this.currentParsingFile.equals(this.outputFile)) {
                if (id != null) {
                    this.changeTable.put(URLUtils.setFragment((URI)this.currentParsingFile, (String)id), URLUtils.setFragment((URI)this.outputFile, (String)id));
                } else {
                    this.changeTable.put(URLUtils.stripFragment((URI)this.currentParsingFile), URLUtils.stripFragment((URI)this.outputFile));
                }
            }
        } else if (this.skip) {
            this.skipLevel = 1;
        } else if (id != null && (id.equals(this.targetTopicId) || this.startFromFirstTopic)) {
            this.include = true;
            this.includelevel = 0;
            this.skip = false;
            this.skipLevel = 0;
            this.startFromFirstTopic = false;
            if (!this.currentParsingFile.equals(this.outputFile)) {
                this.changeTable.put(URLUtils.setFragment((URI)this.currentParsingFile, (String)id), URLUtils.setFragment((URI)this.outputFile, (String)id));
            }
        }
    }

    Job.FileInfo generateFileInfo(URI output) {
        assert (output.isAbsolute());
        URI t = this.job.tempDirURI.relativize(output);
        URI result = this.job.getInputDir().resolve(t);
        URI temp = this.tempFileNameScheme.generateTempFileName(result);
        Job.FileInfo.Builder b = this.currentParsingFile != null && this.job.getFileInfo(URLUtils.stripFragment((URI)this.currentParsingFile)) != null ? new Job.FileInfo.Builder(this.job.getFileInfo(URLUtils.stripFragment((URI)this.currentParsingFile))) : new Job.FileInfo.Builder();
        Job.FileInfo fi = b.uri(temp).result(result).format("dita").build();
        return fi;
    }

    URI generateOutputFilename(String id) {
        Job.FileInfo cfi = this.job.getFileInfo(URLUtils.stripFragment((URI)this.currentParsingFile));
        URI result = cfi.result.resolve(id + ".dita");
        URI temp = this.tempFileNameScheme.generateTempFileName(result);
        if (id == null || this.job.getStore().exists(this.job.tempDirURI.resolve(temp))) {
            URI t = temp;
            result = cfi.result.resolve(this.generateFilename());
            temp = this.tempFileNameScheme.generateTempFileName(result);
            Job.FileInfo.Builder b = new Job.FileInfo.Builder(cfi);
            Job.FileInfo fi = b.uri(temp).result(result).format("dita").build();
            this.job.add(fi);
            this.conflictTable.put(this.job.tempDirURI.resolve(temp), this.job.tempDirURI.resolve(t));
        }
        return this.job.tempDirURI.resolve(temp);
    }

    Attributes processAttributes(Attributes atts) {
        String cls = atts.getValue("class");
        AttributesImpl resAtts = new AttributesImpl(atts);
        String id = resAtts.getValue("id");
        if (id != null && Constants.TOPIC_TOPIC.matches(cls)) {
            if (this.topicID.contains(id)) {
                URI tmpVal;
                String newId = this.chunkFilenameGenerator.generateID();
                this.topicID.add(newId);
                URI tmpId = this.changeTable.get(URLUtils.setFragment((URI)this.currentParsingFile, (String)id));
                if (tmpId != null && tmpId.equals(URLUtils.setFragment((URI)this.outputFile, (String)id))) {
                    this.changeTable.put(URLUtils.setFragment((URI)this.currentParsingFile, (String)id), URLUtils.setFragment((URI)this.outputFile, (String)newId));
                }
                if ((tmpVal = this.changeTable.get(this.currentParsingFile)) != null && tmpVal.equals(URLUtils.setFragment((URI)this.outputFile, (String)id))) {
                    this.changeTable.put(this.currentParsingFile, URLUtils.setFragment((URI)this.outputFile, (String)newId));
                }
                this.currentParsingFileTopicIDChangeTable.put(id, newId);
                XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"id", (String)newId);
            } else {
                this.topicID.add(id);
            }
        }
        String href = resAtts.getValue("href");
        String scope = resAtts.getValue("scope");
        if (href != null && !"external".equals(scope)) {
            URI relative = URLUtils.getRelativePath((URI)this.outputFile, (URI)this.currentParsingFile);
            if (this.conflictTable.containsKey(this.outputFile)) {
                URI realoutputfile = this.conflictTable.get(this.outputFile);
                relative = URLUtils.getRelativePath((URI)realoutputfile, (URI)this.currentParsingFile);
            }
            if (href.startsWith("#")) {
                URI hrefUri = URI.create(href);
                URI res = URLUtils.setFragment((URI)relative.resolve(hrefUri), (String)hrefUri.getFragment());
                XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"href", (String)res.toString());
            } else if (relative.toString().contains("/")) {
                XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"href", (String)relative.resolve(href).toString());
            }
        }
        if (Constants.TOPIC_TOPIC.matches(cls) && resAtts.getValue("xmlns:ditaarch") == null) {
            XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"xmlns:ditaarch", (String)"http://dita.oasis-open.org/architecture/2005/");
        }
        if (Constants.TOPIC_TOPIC.matches(cls) && resAtts.getValue("xmlns:dita-ot") == null) {
            XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"xmlns:dita-ot", (String)"http://dita-ot.sourceforge.net/ns/201007/dita-ot");
        }
        if (Constants.TOPIC_TOPIC.matches(cls) && resAtts.getValue("xsi:noNamespaceSchemaLocation") != null) {
            XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"xmlns:xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        }
        this.addExtraNamespaceMappingsForPrefixes(resAtts);
        return resAtts;
    }

    private void addExtraNamespaceMappingsForPrefixes(AttributesImpl resAtts) {
        HashMap<CallSite, String> mappingsToDefine = null;
        if (this.lastPrefixNamespaceMappings != null && !this.lastPrefixNamespaceMappings.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.lastPrefixNamespaceMappings.entrySet()) {
                String prefix = (String)entry.getKey();
                String ns = (String)entry.getValue();
                String declaration = "xmlns:" + prefix;
                if (resAtts.getValue(declaration) != null) continue;
                if (mappingsToDefine == null) {
                    mappingsToDefine = new HashMap<CallSite, String>();
                }
                mappingsToDefine.put((CallSite)((Object)declaration), ns);
            }
        }
        if (mappingsToDefine != null) {
            for (Map.Entry<Object, Object> entry : mappingsToDefine.entrySet()) {
                XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
        this.lastPrefixNamespaceMappings.clear();
    }

    Attributes processAttributesNS(Attributes atts, String uri) {
        String prefix;
        AttributesImpl resAtts = new AttributesImpl(this.processAttributes(atts));
        if (this.namespaceMap.get(uri) == 1 && (prefix = this.namespaces.getPrefix(uri)) != null) {
            if (!prefix.equals("")) {
                XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)("xmlns:" + prefix), (String)uri);
            } else {
                XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, (String)"xmlns", (String)uri);
            }
        }
        return resAtts;
    }

    String generateFilename() {
        return this.chunkFilenameGenerator.generateFilename("Chunk", ".dita");
    }

    URI generateOutputFile(URI ref) {
        Job.FileInfo srcFi = this.job.getFileInfo(ref);
        URI newSrc = srcFi.src.resolve(this.generateFilename());
        URI tmp = this.tempFileNameScheme.generateTempFileName(newSrc);
        if (this.job.getFileInfo(tmp) == null) {
            this.job.add(new Job.FileInfo.Builder().result(newSrc).uri(tmp).build());
        }
        return this.job.tempDirURI.resolve(tmp);
    }

    Element createTopicMeta(Element topic) {
        Document doc = this.rootTopicref.getOwnerDocument();
        Element topicmeta = doc.createElement(Constants.MAP_TOPICMETA.localName);
        topicmeta.setAttribute("class", Constants.MAP_TOPICMETA.toString());
        if (topic != null) {
            Element title = XMLUtils.getElementNode((Element)topic, (DitaClass)Constants.TOPIC_TITLE);
            Element titlealts = XMLUtils.getElementNode((Element)topic, (DitaClass)Constants.TOPIC_TITLEALTS);
            Element navtitle = titlealts != null ? XMLUtils.getElementNode((Element)titlealts, (DitaClass)Constants.TOPIC_NAVTITLE) : null;
            Element shortDesc = XMLUtils.getElementNode((Element)topic, (DitaClass)Constants.TOPIC_SHORTDESC);
            Element navtitleNode = doc.createElement(Constants.TOPIC_NAVTITLE.localName);
            navtitleNode.setAttribute("class", Constants.TOPIC_NAVTITLE.toString());
            if (navtitle != null) {
                text = XMLUtils.getText((Node)navtitle);
                titleText = doc.createTextNode(text);
                navtitleNode.appendChild(titleText);
                topicmeta.appendChild(navtitleNode);
            } else {
                text = XMLUtils.getText((Node)title);
                titleText = doc.createTextNode(text);
                navtitleNode.appendChild(titleText);
                topicmeta.appendChild(navtitleNode);
            }
            ProcessingInstruction pi = doc.createProcessingInstruction("ditaot", "gentext");
            topicmeta.appendChild(pi);
            Element linkTextNode = doc.createElement(Constants.TOPIC_LINKTEXT.localName);
            linkTextNode.setAttribute("class", Constants.MAP_LINKTEXT.toString());
            String text = XMLUtils.getText((Node)title);
            Text textNode = doc.createTextNode(text);
            linkTextNode.appendChild(textNode);
            topicmeta.appendChild(linkTextNode);
            ProcessingInstruction pii = doc.createProcessingInstruction("ditaot", "genshortdesc");
            topicmeta.appendChild(pii);
            Element shortDescNode = doc.createElement(Constants.TOPIC_SHORTDESC.localName);
            shortDescNode.setAttribute("class", Constants.MAP_SHORTDESC.toString());
            String shortDescText = XMLUtils.getText((Node)shortDesc);
            Text shortDescTextNode = doc.createTextNode(shortDescText);
            shortDescNode.appendChild(shortDescTextNode);
            topicmeta.appendChild(shortDescNode);
        }
        return topicmeta;
    }

    String getFirstTopicId(File ditaTopicFile) {
        assert (ditaTopicFile.isAbsolute());
        if (!ditaTopicFile.isAbsolute()) {
            return null;
        }
        StringBuilder firstTopicId = new StringBuilder();
        TopicIdParser parser = new TopicIdParser(firstTopicId);
        try {
            this.job.getStore().transform(ditaTopicFile.toURI(), (ContentHandler)parser);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (firstTopicId.length() == 0) {
            return null;
        }
        return firstTopicId.toString();
    }

    void writeStartDocument(Writer output) throws SAXException {
        try {
            output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    void writeStartElement(Writer output, String name, Attributes atts) throws SAXException {
        try {
            output.write("<");
            output.write(name);
            for (int i = 0; i < atts.getLength(); ++i) {
                output.write(" ");
                output.write(atts.getQName(i));
                output.write("=");
                output.write("\"");
                output.write(XMLUtils.escapeXML((String)atts.getValue(i)));
                output.write("\"");
            }
            output.write(">");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    void writeEndElement(Writer output, String name) throws SAXException {
        try {
            output.write("<");
            output.write("/");
            output.write(name);
            output.write(">");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    void writeProcessingInstruction(Writer output, String name, String value) throws SAXException {
        try {
            output.write("<");
            output.write("?");
            output.write(name);
            if (value != null) {
                output.write(" ");
                output.write(value);
            }
            output.write("?");
            output.write(">");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.namespaces.pushContext();
        this.namespaces.declarePrefix(prefix, uri);
        this.lastPrefixNamespaceMappings.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.namespaces.popContext();
    }
}

