/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.dita.dost.util.Configuration;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlresolver.Resolver;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolverConfiguration;

public final class CatalogUtils {
    private static final String DARGS_DISABLE_SECURITY_CHECKS = "-Dargs.disable.security.checks";
    private static Resolver catalogResolver = null;
    private static File ditaDir;

    private CatalogUtils() {
    }

    public static synchronized void setDitaDir(File ditaDir) {
        catalogResolver = null;
        CatalogUtils.ditaDir = ditaDir;
        if (CatalogUtils.ditaDir != null) {
            try {
                CatalogUtils.ditaDir = CatalogUtils.ditaDir.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized Resolver getCatalogResolver() {
        if (catalogResolver == null) {
            File catalogFilePath = new File(ditaDir, Configuration.pluginResourceDirs.get("org.dita.base") + File.separator + "catalog-dita.xml");
            XMLResolverConfiguration config = new XMLResolverConfiguration();
            config.setFeature(ResolverFeature.PREFER_PUBLIC, (Object)true);
            config.setFeature(ResolverFeature.CACHE_DIRECTORY, null);
            config.setFeature(ResolverFeature.CACHE_UNDER_HOME, (Object)false);
            config.addCatalog(catalogFilePath.toURI().toASCIIString());
            catalogResolver = CatalogUtils.isDisableSecurityChecks() ? new Resolver(config) : new RestrictedCatalogResolver(config);
        }
        return catalogResolver;
    }

    private static boolean isDisableSecurityChecks() {
        boolean isDisabled = false;
        Properties properties = System.getProperties();
        String command = properties.getProperty("sun.java.command");
        if (command != null && command.contains(DARGS_DISABLE_SECURITY_CHECKS)) {
            command = command.replace('=', ' ');
            String[] token = command.split("\\s");
            for (int i = 0; i < token.length - 1; ++i) {
                if (!token[i].equals(DARGS_DISABLE_SECURITY_CHECKS) || !token[i + 1].equalsIgnoreCase("yes") && !token[i + 1].equalsIgnoreCase("true")) continue;
                isDisabled = true;
            }
        }
        return isDisabled;
    }

    private static final class RestrictedCatalogResolver
    extends Resolver {
        private static final String VULNERABILITY_MESSAGE = "For security reasons files that are not listed in the DITA-OT catalogs and are not located in the DITA-OT directory are not read. You can disable this restriction by setting \"-Dargs.disable.security.checks=yes\" in the command line or the Oxygen transformation configuration dialog, the \"Advanced\" tab, in the \"JVM Arguments\" text field. Make sure all the input files come from a trusted source. ";

        private RestrictedCatalogResolver(XMLResolverConfiguration config) {
            super(config);
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource source;
            block6: {
                source = null;
                try {
                    boolean isResolvedTroughCatalog;
                    source = super.resolveEntity(publicId, systemId);
                    boolean bl = isResolvedTroughCatalog = systemId != null && source != null && !source.getSystemId().equals(systemId);
                    if (isResolvedTroughCatalog) break block6;
                    try {
                        File resolvingFile = new File(new URI(systemId));
                        if (ditaDir != null) {
                            if (resolvingFile.getAbsolutePath().startsWith(ditaDir.getAbsolutePath()) || resolvingFile.getName().toLowerCase().endsWith(".xsd")) {
                                return source;
                            }
                            throw new RuntimeException("The entity " + publicId + " / " + systemId + " cannot not be resolved through catalogs. For security reasons files that are not listed in the DITA-OT catalogs and are not located in the DITA-OT directory are not read. You can disable this restriction by setting \"-Dargs.disable.security.checks=yes\" in the command line or the Oxygen transformation configuration dialog, the \"Advanced\" tab, in the \"JVM Arguments\" text field. Make sure all the input files come from a trusted source. ");
                        }
                    }
                    catch (IllegalArgumentException | URISyntaxException exception) {}
                }
                catch (IOException | SAXException exception) {
                    // empty catch block
                }
            }
            return source;
        }
    }
}

