/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.dita.dost.platform.ImportAction;
import org.dita.dost.platform.Value;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class ImportAntLibAction
extends ImportAction {
    ImportAntLibAction() {
    }

    public void getResult(ContentHandler retBuf) throws SAXException {
        String templateFilePath = (String)this.paramTable.get("template");
        for (Value value : this.valueSet) {
            ArrayList<String> toProcess = new ArrayList<String>();
            if (value instanceof Value.PathValue) {
                Value.PathValue pathValue = (Value.PathValue)value;
                String path = pathValue.getPath();
                if (path.endsWith("*")) {
                    toProcess.addAll(this.expandPath(path));
                } else {
                    toProcess.add(path);
                }
            } else {
                this.logger.error("Ant import must be a file feature: " + value.value());
                continue;
            }
            for (String v : toProcess) {
                String resolvedValue = FileUtils.getRelativeUnixPath((String)templateFilePath, (String)v);
                if (FileUtils.isAbsolutePath((String)resolvedValue)) {
                    retBuf.startElement("", "pathelement", "pathelement", new XMLUtils.AttributesBuilder().add("location", resolvedValue).build());
                    retBuf.endElement("", "pathelement", "pathelement");
                    continue;
                }
                retBuf.startElement("", "pathelement", "pathelement", new XMLUtils.AttributesBuilder().add("location", "${dita.dir}${file.separator}" + resolvedValue).build());
                retBuf.endElement("", "pathelement", "pathelement");
            }
        }
    }

    private Collection<String> expandPath(String path) {
        ArrayList<String> expandedPaths = new ArrayList<String>();
        File parentDir = new File(path).getParentFile();
        Object[] matchingJars = parentDir.listFiles((dir, name) -> name.endsWith(".jar"));
        if (matchingJars == null) {
            this.logger.error("Cannot expand the wildcard expression: {0}, the parent directory cannot be listed: {1}", (Object)path, (Object)parentDir);
        } else {
            Arrays.sort(matchingJars);
            for (Object file : matchingJars) {
                expandedPaths.add(((File)file).getAbsolutePath());
            }
        }
        return expandedPaths;
    }
}

