/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.property.GetProperty;
import org.apache.tools.ant.property.ResolvePropertyMap;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ProxySetup;
import org.dita.dost.invoker.ArgumentParser;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.CliException;
import org.dita.dost.invoker.ConversionArguments;
import org.dita.dost.invoker.DefaultLogger;
import org.dita.dost.invoker.DeliverablesArguments;
import org.dita.dost.invoker.InitArguments;
import org.dita.dost.invoker.InstallArguments;
import org.dita.dost.invoker.PluginsArguments;
import org.dita.dost.invoker.TranstypesArguments;
import org.dita.dost.invoker.UninstallArguments;
import org.dita.dost.invoker.ValidateArguments;
import org.dita.dost.invoker.VersionArguments;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.log.StandardLogger;
import org.dita.dost.platform.PluginInstall;
import org.dita.dost.platform.PluginUninstall;
import org.dita.dost.platform.Plugins;
import org.dita.dost.platform.SemVerMatch;
import org.dita.dost.project.Project;
import org.dita.dost.project.ProjectFactory;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.LangUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Main
extends org.apache.tools.ant.Main
implements AntMain {
    private static final String SYSTEM_PROPERTY_DITA_HOME = "dita.dir";
    private static final String ANT_ARGS_INPUT = "args.input";
    static final String ANT_ARGS_RESOURCES = "args.resources";
    static final String ANT_ARGS_INPUTS = "args.inputs";
    protected static final String ANT_OUTPUT_DIR = "output.dir";
    private static final String ANT_BASE_TEMP_DIR = "base.temp.dir";
    private static final String ANT_TRANSTYPE = "transtype";
    private static final String ANT_PLUGIN_FILE = "plugin.file";
    private static final String ANT_PLUGIN_ID = "plugin.id";
    private static final String ANT_PROJECT_DELIVERABLE = "project.deliverable";
    private static final String ANT_PROJECT_CONTEXT = "project.context";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final Map<String, String> RESERVED_PARAMS = Map.of("output.dir", "output", "transtype", "transtype", "args.input", "input", "args.filter", "profiles");
    private static final String CONFIGURATION_FILE = ".ditaotrc";
    @Deprecated
    private static final String CONFIGURATION_FILE_OLD = "local.properties";
    private static final String DELIVERABLE_DESC = "deliverable.desc";
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private final Vector<String> targets = new Vector();
    private List<Map<String, Object>> projectProps;
    private boolean readyToRun = false;
    private final ArgumentParser argumentParser = new ArgumentParser();
    private Arguments args;
    public static final ResourceBundle locale = ResourceBundle.getBundle("cli", new Locale("en", "US"));
    final StandardLogger logger = new StandardLogger(System.out, System.err, 2, true);

    private void printMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null && !message.trim().isEmpty()) {
            this.printErrorMessage(message, t);
        }
    }

    private void printErrorMessage(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    @Deprecated
    public static void start(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        Main m = new Main();
        m.startAnt(args, additionalUserProperties, coreLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnt(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        try {
            this.processArgs(args);
        }
        catch (CliException exc) {
            this.handleLogfile();
            this.logger.setOutputLevel(2);
            this.printMessage(exc);
            if (exc.info != null) {
                this.logger.info(exc.info);
            }
            this.exit(1);
            return;
        }
        catch (BuildException exc) {
            this.handleLogfile();
            this.printMessage(exc);
            this.exit(1);
            return;
        }
        catch (RuntimeException e) {
            this.handleLogfile();
            e.printStackTrace();
            this.exit(1);
            return;
        }
        catch (Throwable exc) {
            this.handleLogfile();
            this.printMessage(exc);
            this.exit(1);
            return;
        }
        if (!this.readyToRun) {
            return;
        }
        if (additionalUserProperties != null) {
            for (Map<String, Object> props : this.projectProps) {
                Enumeration<Object> e = additionalUserProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String property = additionalUserProperties.getProperty(key);
                    props.put(key, property);
                }
            }
        }
        int exitCode = 1;
        try {
            int i;
            long[] durations = new long[this.args.repeat];
            for (i = 0; i < this.args.repeat; ++i) {
                long start;
                block25: {
                    start = System.currentTimeMillis();
                    try {
                        int nuOfProject = this.projectProps.size();
                        for (int j = 0; j < nuOfProject; ++j) {
                            Map<String, Object> props = this.projectProps.get(j);
                            if (props.containsKey(DELIVERABLE_DESC)) {
                                props.put(DELIVERABLE_DESC, j + 1 + " of " + nuOfProject + ": " + props.get(DELIVERABLE_DESC));
                            }
                            this.runBuild(coreLoader, props);
                        }
                        exitCode = 0;
                    }
                    catch (ExitStatusException ese) {
                        exitCode = ese.getStatus();
                        if (exitCode == 0) break block25;
                        throw ese;
                    }
                }
                long end = System.currentTimeMillis();
                durations[i] = end - start;
            }
            if (this.args.repeat > 1) {
                for (i = 0; i < durations.length; ++i) {
                    this.logger.info(locale.getString("conversion.repeatDuration").formatted(i + 1, durations[i]));
                }
            }
        }
        catch (BuildException be) {
            if (err != System.err) {
                this.printMessage(be);
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            this.printMessage(exc);
        }
        finally {
            this.handleLogfile();
        }
        this.exit(exitCode);
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    private void handleLogfile() {
        if (this.args != null && this.args.logFile != null) {
            FileUtils.close((OutputStream)out);
            FileUtils.close((OutputStream)err);
        }
    }

    @Deprecated
    public static void main(String[] args) {
        Main.start(args, null, null);
    }

    private void processArgs(String[] arguments) {
        this.args = this.argumentParser.processArgs(arguments);
        HashMap<String, Object> definedProps = new HashMap<String, Object>(this.args.definedProps);
        this.projectProps = Collections.singletonList(definedProps);
        this.buildFile = this.args.buildFile;
        this.logger.setOutputLevel(this.args.msgOutputLevel);
        this.logger.setUseColor(this.args.useColor);
        if (this.args.justPrintUsage) {
            this.logger.setOutputLevel(2);
            this.logger.info(this.args.getUsage(false));
            return;
        }
        if (this.args.justPrintDiagnostics) {
            Diagnostics.doReport((PrintStream)System.out, (int)this.args.msgOutputLevel);
            return;
        }
        if (this.args instanceof PluginsArguments) {
            this.printPlugins();
            return;
        }
        if (this.args instanceof VersionArguments) {
            this.printVersion();
            return;
        }
        Arguments arguments2 = this.args;
        if (arguments2 instanceof ValidateArguments) {
            ValidateArguments validateArgs = (ValidateArguments)arguments2;
            ditaDir = new File(System.getProperty(SYSTEM_PROPERTY_DITA_HOME));
            File basePluginDir = new File((File)ditaDir, ((File)Configuration.pluginResourceDirs.get("org.dita.base")).getPath());
            this.buildFile = this.findBuildFile(basePluginDir.getAbsolutePath(), "build.xml");
            definedProps.putAll(this.getLocalProperties((File)ditaDir));
            definedProps.put("dita.use-color", Boolean.toString(validateArgs.useColor));
            this.projectProps = validateArgs.projectFile == null ? Collections.singletonList(definedProps) : this.collectContextProperties(validateArgs.projectFile, definedProps);
            for (Map<String, Object> projectProp : this.projectProps) {
                String err = null;
                if (!projectProp.containsKey(ANT_ARGS_INPUT)) {
                    err = locale.getString("conversion.error.input_not_defined");
                }
                if (err != null) {
                    throw new CliException(err, this.args.getUsage(true));
                }
                if (projectProp.containsKey(ANT_BASE_TEMP_DIR)) continue;
                projectProp.put(ANT_BASE_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
            }
        } else {
            if (this.args instanceof TranstypesArguments) {
                this.printTranstypes();
                return;
            }
            ditaDir = this.args;
            if (ditaDir instanceof DeliverablesArguments) {
                DeliverablesArguments deliverablesArgs = (DeliverablesArguments)ditaDir;
                this.printDeliverables(deliverablesArgs);
                return;
            }
            ditaDir = this.args;
            if (ditaDir instanceof InitArguments) {
                InitArguments initArgs = (InitArguments)ditaDir;
                this.init(initArgs);
                return;
            }
            ditaDir = this.args;
            if (ditaDir instanceof InstallArguments) {
                InstallArguments installArgs = (InstallArguments)ditaDir;
                this.install(installArgs);
                return;
            }
            ditaDir = this.args;
            if (ditaDir instanceof UninstallArguments) {
                UninstallArguments installArgs = (UninstallArguments)ditaDir;
                this.uninstall(installArgs);
                return;
            }
            ditaDir = this.args;
            if (ditaDir instanceof ConversionArguments) {
                ConversionArguments conversionArgs = (ConversionArguments)((Object)ditaDir);
                ditaDir = new File(System.getProperty(SYSTEM_PROPERTY_DITA_HOME));
                File basePluginDir = new File((File)ditaDir, ((File)Configuration.pluginResourceDirs.get("org.dita.base")).getPath());
                this.buildFile = this.findBuildFile(basePluginDir.getAbsolutePath(), "build.xml");
                definedProps.putAll(this.getLocalProperties((File)ditaDir));
                definedProps.put("dita.use-color", Boolean.toString(conversionArgs.useColor));
                this.projectProps = conversionArgs.projectFile == null ? this.collectArguments(conversionArgs.inputs, conversionArgs.formats, definedProps) : this.collectProperties(conversionArgs.projectFile, definedProps);
                String tempDirToken = "temp" + LocalDateTime.now().format(dateTimeFormatter);
                for (Map<String, Object> projectProp : this.projectProps) {
                    Path tempDir;
                    String err = null;
                    if (!projectProp.containsKey(ANT_TRANSTYPE) && !projectProp.containsKey(ANT_ARGS_INPUT)) {
                        err = locale.getString("conversion.error.input_and_transformation_not_defined");
                    } else if (!projectProp.containsKey(ANT_TRANSTYPE)) {
                        err = locale.getString("conversion.error.transformation_not_defined");
                    } else if (!projectProp.containsKey(ANT_ARGS_INPUT)) {
                        err = locale.getString("conversion.error.input_not_defined");
                    }
                    if (err != null) {
                        throw new CliException(err, this.args.getUsage(true));
                    }
                    if (!definedProps.containsKey(ANT_OUTPUT_DIR)) {
                        definedProps.put(ANT_OUTPUT_DIR, new File(new File("."), "out").getAbsolutePath());
                    }
                    if (!projectProp.containsKey(ANT_BASE_TEMP_DIR)) {
                        projectProp.put(ANT_BASE_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
                    }
                    if (!projectProp.containsKey(ANT_PROJECT_DELIVERABLE)) continue;
                    if (projectProp.containsKey("dita.temp.dir")) {
                        tempDir = Paths.get(projectProp.get("dita.temp.dir").toString(), projectProp.get(ANT_PROJECT_DELIVERABLE).toString());
                        projectProp.put("dita.temp.dir", tempDir.toAbsolutePath().toString());
                        continue;
                    }
                    tempDir = Paths.get(projectProp.get(ANT_BASE_TEMP_DIR).toString(), tempDirToken, projectProp.get(ANT_PROJECT_DELIVERABLE).toString());
                    projectProp.put("dita.temp.dir", tempDir.toAbsolutePath().toString());
                }
            } else {
                throw new RuntimeException("Command or subcommand not supported: " + this.args.getClass().getCanonicalName());
            }
        }
        if (!this.buildFile.exists() || this.buildFile.isDirectory()) {
            throw new CliException("Buildfile " + this.buildFile + " does not exist!");
        }
        this.buildFile = FileUtils.getFileUtils().normalize(this.buildFile.getAbsolutePath());
        this.logger.debug("Buildfile " + this.buildFile);
        if (this.args.logFile != null) {
            PrintStream logTo;
            try {
                logTo = new PrintStream(new FileOutputStream(this.args.logFile));
            }
            catch (IOException ioe) {
                throw new CliException("Cannot write to the specified log file. Make sure the path exists and you have write permissions.");
            }
            out = logTo;
            err = logTo;
            System.setOut(out);
            System.setErr(err);
        }
        this.readyToRun = true;
    }

    private List<Map<String, Object>> collectArguments(List<String> inputs, List<String> formats, Map<String, Object> definedProps) {
        if (inputs.isEmpty() || formats.isEmpty()) {
            return List.of(definedProps);
        }
        String input = inputs.get(inputs.size() - 1);
        return formats.stream().map(format -> {
            HashMap<String, String> res = new HashMap<String, String>(definedProps);
            res.put(ANT_ARGS_INPUT, input);
            res.put(ANT_TRANSTYPE, (String)format);
            return res;
        }).toList();
    }

    private void uninstall(UninstallArguments installArgs) {
        if (installArgs.uninstallId == null) {
            throw new CliException(locale.getString("uninstall.error.identifier_not_defined"), this.args.getUsage(true));
        }
        PluginUninstall pluginUninstall = new PluginUninstall();
        pluginUninstall.setId(installArgs.uninstallId);
        pluginUninstall.setDitaDir(new File(System.getProperty(SYSTEM_PROPERTY_DITA_HOME)));
        pluginUninstall.setLogger((DITAOTLogger)this.logger);
        try {
            pluginUninstall.execute();
        }
        catch (CliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CliException(e.getMessage(), (Throwable)e);
        }
    }

    private void init(InitArguments initArguments) {
        if (initArguments.list) {
            this.printInitList();
            return;
        }
        if (initArguments.template == null) {
            throw new CliException(locale.getString("init.error.template_not_defined"), initArguments.getUsage(true));
        }
        final Path target = Optional.ofNullable(initArguments.output).orElseGet(() -> Paths.get(".", new String[0]).toAbsolutePath().normalize());
        final Path source = this.getTemplateDir(initArguments.template);
        try {
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = target.resolve(source.relativize(dir));
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path dst = target.resolve(source.relativize(file));
                    Main.this.logger.debug("Create {}", (Object)dst);
                    Files.copy(file, dst, new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
            this.logger.info(locale.getString("init.info.create").formatted(target, initArguments.template));
        }
        catch (FileAlreadyExistsException e) {
            throw new BuildException(locale.getString("init.error.file_already_exists").formatted(e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException(locale.getString("init.error.create_failed").formatted(e.getMessage()), (Throwable)e);
        }
    }

    private Path getTemplateDir(String template) {
        List plugins = XMLUtils.toList((NodeList)Plugins.getPluginConfiguration().getElementsByTagName("feature"));
        return plugins.stream().filter(feature -> Objects.equals(feature.getAttribute("extension"), "init.template")).map(feature -> Optional.ofNullable(feature.getAttributeNode("file")).map(Attr::getValue).map(value -> Paths.get(URI.create(feature.getBaseURI()).resolve((String)value))).orElse(null)).filter(dir -> Objects.equals(template, dir.getFileName().toString())).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findAny().orElseThrow(() -> new BuildException(locale.getString("init.error.template_not_found").formatted(template)));
    }

    private void printInitList() {
        List plugins = XMLUtils.toList((NodeList)Plugins.getPluginConfiguration().getElementsByTagName("feature"));
        List templates = plugins.stream().filter(feature -> Objects.equals(feature.getAttribute("extension"), "init.template")).map(feature -> Map.entry(Optional.ofNullable(feature.getAttributeNode("file")).map(Attr::getValue).map(value -> Paths.get(URI.create(feature.getBaseURI()).resolve((String)value)).getFileName().toString()).orElse(null), Optional.ofNullable(feature.getAttributeNode("desc")).map(Attr::getValue).orElse(null))).filter(entry -> Objects.nonNull(entry.getKey())).sorted(Map.Entry.comparingByKey()).toList();
        if (!templates.isEmpty()) {
            Integer width = templates.stream().map(stringStringEntry -> ((String)stringStringEntry.getKey()).length()).max(Integer::compare).get();
            templates.forEach(dir -> this.logger.info((String)dir.getKey() + " ".repeat(width - ((String)dir.getKey()).length()) + "  " + (String)dir.getValue()));
        }
    }

    private void install(InstallArguments installArgs) {
        PluginInstall pluginInstall = new PluginInstall();
        pluginInstall.setDitaDir(new File(System.getProperty(SYSTEM_PROPERTY_DITA_HOME)));
        pluginInstall.setLogger((DITAOTLogger)this.logger);
        if (installArgs.definedProps.containsKey("force")) {
            pluginInstall.setForce(Boolean.parseBoolean(installArgs.definedProps.get("force").toString()));
        }
        if (installArgs.installFile != null) {
            this.parseInstallFile(installArgs.installFile, pluginInstall);
        }
        try {
            File ditaDir = new File(System.getProperty(SYSTEM_PROPERTY_DITA_HOME));
            File plugins = new File(ditaDir, "config" + File.separator + "plugins.xml");
            if (!plugins.exists()) {
                try {
                    XMLUtils xmlUtils = new XMLUtils();
                    Document pluginsDoc = xmlUtils.newDocument();
                    Element root = pluginsDoc.createElement("plugins");
                    pluginsDoc.appendChild(root);
                    xmlUtils.writeDocument(pluginsDoc, plugins);
                }
                catch (IOException e) {
                    throw new CliException("Cannot create plugins.xml file.");
                }
            }
            pluginInstall.execute();
        }
        catch (CliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CliException(e.getMessage(), (Throwable)e);
        }
    }

    private void parseInstallFile(String installFile, PluginInstall pluginInstall) {
        File pluginFile = new File(installFile.replace('/', File.separatorChar)).getAbsoluteFile();
        if (pluginFile.exists()) {
            try {
                pluginInstall.setPluginFile(pluginFile.toPath());
                return;
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        try {
            URI uri = new URI(installFile);
            if (uri.isAbsolute()) {
                pluginInstall.setPluginUri(uri);
                return;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (installFile.contains("@")) {
            String[] tokens = installFile.split("@");
            pluginInstall.setPluginName(tokens[0]);
            pluginInstall.setPluginVersion(new SemVerMatch(tokens[1]));
        } else {
            pluginInstall.setPluginName(installFile);
            pluginInstall.setPluginVersion(null);
        }
    }

    private Map<String, Object> getLocalProperties(File ditaDir) {
        File installDirFileLegacy;
        File installDirFile;
        File homeFile;
        HashMap<String, Object> res = new HashMap<String, Object>();
        List files = Stream.of(new File("").getAbsoluteFile()).map(dir -> new File((File)dir, CONFIGURATION_FILE)).collect(Collectors.toList());
        if (!files.contains(homeFile = new File(new File(System.getProperty("user.home")), CONFIGURATION_FILE))) {
            files.add(homeFile);
        }
        if (!files.contains(installDirFile = new File(ditaDir, CONFIGURATION_FILE))) {
            files.add(installDirFile);
        }
        if (!files.contains(installDirFileLegacy = new File(ditaDir, CONFIGURATION_FILE_OLD))) {
            files.add(installDirFileLegacy);
        }
        Collections.reverse(files);
        files.stream().filter(File::exists).map(this::readProperties).forEach(res::putAll);
        return res;
    }

    private Map<String, Object> readProperties(File localPropertiesFile) {
        Map<String, Object> map;
        block8: {
            this.logger.debug("Reading " + localPropertiesFile);
            InputStream in = Files.newInputStream(localPropertiesFile.toPath(), new OpenOption[0]);
            try {
                Properties localProperties = new Properties();
                localProperties.load(in);
                map = localProperties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    this.logger.error("Failed to read " + localPropertiesFile, (Throwable)e2);
                    return Collections.emptyMap();
                }
            }
            in.close();
        }
        return map;
    }

    private List<Map<String, Object>> collectProperties(File projectFile, Map<String, Object> definedProps) {
        URI base = projectFile.toURI();
        Project project = this.readProjectFile(projectFile);
        return this.collectProperties(project, base, definedProps);
    }

    @VisibleForTesting
    List<Map<String, Object>> collectProperties(Project project, URI base, Map<String, Object> definedProps) {
        String runDeliverable = (String)definedProps.get(ANT_PROJECT_DELIVERABLE);
        List<Map<String, Object>> projectProps = LangUtils.zipWithIndex((List)project.deliverables()).filter(entry -> runDeliverable == null || Objects.equals(((Project.Deliverable)entry.getKey()).id(), runDeliverable)).map(entry -> {
            Project.Deliverable deliverable = (Project.Deliverable)entry.getKey();
            HashMap<String, Object> props = new HashMap<String, Object>(definedProps);
            props.put(ANT_PROJECT_DELIVERABLE, deliverable.id() != null ? deliverable.id() : String.format("deliverable-%d", (Integer)entry.getValue() + 1));
            StringBuilder deliverableDesc = new StringBuilder();
            if (deliverable.name() != null) {
                deliverableDesc.append(deliverable.name());
            }
            if (deliverable.id() != null) {
                deliverableDesc.append(" [").append(deliverable.id()).append("]");
            }
            props.put(DELIVERABLE_DESC, deliverableDesc.toString());
            Project.Context context = deliverable.context();
            URI input = base.resolve(((Project.Deliverable.Inputs.Input)context.inputs().inputs().get(0)).href());
            props.put(ANT_ARGS_INPUT, input.toString());
            Path output = this.getOutputDir(deliverable, props);
            props.put(ANT_OUTPUT_DIR, output.toString());
            Project.Publication publications = deliverable.publication();
            props.put(ANT_TRANSTYPE, publications.transtype());
            publications.params().forEach(param -> {
                if (props.containsKey(param.name())) {
                    return;
                }
                if (param.value() != null) {
                    Arguments.Argument argument = (Arguments.Argument)ArgumentParser.getPluginArguments().getOrDefault(param.name(), new Arguments.StringArgument(param.name(), null));
                    String value = argument.getValue(param.value());
                    props.put(param.name(), value);
                } else {
                    Arguments.Argument argument = (Arguments.Argument)ArgumentParser.getPluginArguments().get("--" + param.name());
                    String value = argument != null && (argument instanceof Arguments.FileArgument || argument instanceof Arguments.AbsoluteFileArgument) ? (param.href() != null ? Paths.get(base.resolve(param.href())).toString() : Paths.get(base).resolve(param.path()).toString()) : (param.href() != null ? param.href().toString() : URLUtils.toFile((String)param.path().toString()).toString());
                    props.put(param.name(), value);
                }
            });
            List ditavals = Stream.concat(publications.profiles().ditavals().stream(), context.profiles().ditavals().stream()).toList();
            if (!ditavals.isEmpty()) {
                String filters = ditavals.stream().map(ditaVal -> Paths.get(base.resolve(ditaVal.href())).toString()).collect(Collectors.joining(File.pathSeparator));
                props.put("args.filter", filters);
            }
            return props;
        }).collect(Collectors.toList());
        if (runDeliverable != null && projectProps.isEmpty()) {
            throw new CliException(locale.getString("project.error.deliverable_not_found").formatted(runDeliverable));
        }
        return projectProps;
    }

    private List<Map<String, Object>> collectContextProperties(File projectFile, Map<String, Object> definedProps) {
        URI base = projectFile.toURI();
        Project project = this.readProjectFile(projectFile);
        return this.collectContextProperties(project, base, definedProps);
    }

    @VisibleForTesting
    List<Map<String, Object>> collectContextProperties(Project project, URI base, Map<String, Object> definedProps) {
        String runContext = (String)definedProps.get(ANT_PROJECT_CONTEXT);
        List<Map<String, Object>> projectProps = LangUtils.zipWithIndex((List)project.contexts()).filter(entry -> runContext == null || Objects.equals(((Project.Context)entry.getKey()).id(), runContext)).map(entry -> {
            Project.Context context = (Project.Context)entry.getKey();
            HashMap<String, String> props = new HashMap<String, String>(definedProps);
            props.put(ANT_PROJECT_CONTEXT, context.id() != null ? context.id() : String.format("context-%d", (Integer)entry.getValue() + 1));
            URI input = base.resolve(((Project.Deliverable.Inputs.Input)context.inputs().inputs().get(0)).href());
            props.put(ANT_ARGS_INPUT, input.toString());
            props.put(ANT_TRANSTYPE, "validate");
            List ditavals = context.profiles().ditavals().stream().toList();
            if (!ditavals.isEmpty()) {
                String filters = ditavals.stream().map(ditaVal -> Paths.get(base.resolve(ditaVal.href())).toString()).collect(Collectors.joining(File.pathSeparator));
                props.put("args.filter", filters);
            }
            return props;
        }).collect(Collectors.toList());
        if (runContext != null && projectProps.isEmpty()) {
            throw new CliException(locale.getString("project.error.deliverable_not_found").formatted(runContext));
        }
        return projectProps;
    }

    @VisibleForTesting
    protected Path getOutputDir(Project.Deliverable deliverable, Map<String, Object> props) {
        URI outputDir = new File(props.getOrDefault(ANT_OUTPUT_DIR, "out").toString()).getAbsoluteFile().toURI();
        outputDir = outputDir.getPath().endsWith("/") ? outputDir : URLUtils.setPath((URI)outputDir, (String)(outputDir.getPath() + "/"));
        return Paths.get(deliverable.output() != null ? outputDir.resolve(deliverable.output()) : outputDir);
    }

    private Project readProjectFile(File projectFile) throws BuildException {
        if (!projectFile.exists()) {
            throw new CliException(locale.getString("project.error.project_file_not_found").formatted(projectFile));
        }
        try {
            ProjectFactory factory = ProjectFactory.getInstance();
            factory.setLax(true);
            Project res = factory.load(projectFile.toURI());
            this.validateProject(res);
            return res;
        }
        catch (Exception e) {
            throw new CliException(e.getMessage());
        }
    }

    private void validateProject(Project project) throws IOException {
        for (Project.Deliverable deliverable : project.deliverables()) {
            for (Project.Publication.Param param : deliverable.publication().params()) {
                if (!RESERVED_PARAMS.containsKey(param.name())) continue;
                this.printErrorMessage(MessageUtils.getMessage((String)"DOTJ085E", (String[])new String[]{param.name(), RESERVED_PARAMS.get(param.name())}).toString(), null);
            }
        }
    }

    private void printPlugins() {
        this.logger.setOutputLevel(2);
        List installedPlugins = Plugins.getInstalledPlugins();
        for (Map.Entry entry : installedPlugins) {
            if (entry.getValue() != null) {
                this.logger.info("{0}@{1}", entry.getKey(), entry.getValue());
                continue;
            }
            this.logger.info((String)entry.getKey());
        }
    }

    private void printTranstypes() {
        this.logger.setOutputLevel(2);
        for (String transtype : Configuration.transtypes) {
            this.logger.info(transtype);
        }
    }

    private void printDeliverables(DeliverablesArguments deliverablesArgs) {
        this.logger.setOutputLevel(2);
        if (deliverablesArgs.projectFile == null) {
            throw new CliException(locale.getString("deliverables.error.project_not_defined"), this.args.getUsage(true));
        }
        List<Map.Entry> pairs = this.readProjectFile(deliverablesArgs.projectFile).deliverables().stream().filter(deliverable -> deliverable.id() != null).map(deliverable -> LangUtils.pair((Object)deliverable.id(), (Object)deliverable.name())).toList();
        int length = pairs.stream().map(Map.Entry::getKey).map(String::length).reduce(Integer::max).orElse(0);
        for (Map.Entry pair : pairs) {
            this.logger.info(Strings.padEnd((String)((String)pair.getKey()), (int)length, (char)' ') + (String)(pair.getValue() != null ? "  " + (String)pair.getValue() : ""));
        }
    }

    @Deprecated
    private File getParentFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            this.logger.trace("Searching in " + parent.getAbsolutePath());
        }
        return parent;
    }

    private File findBuildFile(String start, String suffix) {
        this.logger.debug("Searching for " + suffix);
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                return null;
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(ClassLoader coreLoader, Map<String, Object> definedProps) throws BuildException {
        org.apache.tools.ant.Project project = new org.apache.tools.ant.Project();
        project.setCoreLoader(coreLoader);
        Throwable error = null;
        try {
            this.addBuildListeners(project);
            this.addInputHandler(project);
            PrintStream savedErr = System.err;
            PrintStream savedOut = System.out;
            InputStream savedIn = System.in;
            try {
                if (this.args.allowInput) {
                    project.setDefaultInputStream(System.in);
                }
                System.setIn((InputStream)new DemuxInputStream(project));
                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
                project.fireBuildStarted();
                if (this.args.threadPriority != null) {
                    try {
                        project.log("Setting Ant's thread priority to " + this.args.threadPriority, 3);
                        Thread.currentThread().setPriority(this.args.threadPriority);
                    }
                    catch (SecurityException swallowed) {
                        project.log("A security manager refused to set the -nice value");
                    }
                }
                if (definedProps.containsKey(DELIVERABLE_DESC)) {
                    project.log("\nPublishing deliverable " + definedProps.get(DELIVERABLE_DESC));
                }
                project.init();
                PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((org.apache.tools.ant.Project)project);
                HashMap<String, Object> props = new HashMap<String, Object>(definedProps);
                new ResolvePropertyMap(project, (GetProperty)propertyHelper, propertyHelper.getExpanders()).resolveAllProperties(props, null, false);
                for (Map.Entry<String, Object> ent : props.entrySet()) {
                    String arg = ent.getKey();
                    Object value = ent.getValue();
                    project.setUserProperty(arg, String.valueOf(value));
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                project.setUserProperty("ant.file.type", "file");
                project.setKeepGoingMode(this.args.keepGoingMode);
                if (this.args.proxy) {
                    ProxySetup proxySetup = new ProxySetup(project);
                    proxySetup.enableProxies();
                }
                ProjectHelper.configureProject((org.apache.tools.ant.Project)project, (File)this.buildFile);
                if (this.targets.size() == 0 && project.getDefaultTarget() != null) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            finally {
                System.setOut(savedOut);
                System.setErr(savedErr);
                System.setIn(savedIn);
            }
        }
        catch (Error | RuntimeException exc) {
            error = exc;
            throw exc;
        }
        finally {
            try {
                project.fireBuildFinished(error);
            }
            catch (Throwable t) {
                this.printErrorMessage("Caught an exception while logging the end of the build. Exception was:", null);
                t.printStackTrace();
                if (error != null) {
                    this.printErrorMessage("There has been an error prior to that:", null);
                    error.printStackTrace();
                }
                throw new BuildException(t);
            }
        }
    }

    protected void addBuildListeners(org.apache.tools.ant.Project project) {
        project.addBuildListener((BuildListener)this.createLogger());
        if (this.args.listeners != null) {
            for (String className : this.args.listeners) {
                BuildListener listener = (BuildListener)ClasspathUtils.newInstance((String)className, (ClassLoader)Main.class.getClassLoader(), BuildListener.class);
                project.setProjectReference((Object)listener);
                project.addBuildListener(listener);
            }
        }
    }

    private void addInputHandler(org.apache.tools.ant.Project project) throws BuildException {
        DefaultInputHandler handler;
        if (this.args.inputHandlerClassname == null) {
            handler = new DefaultInputHandler();
        } else {
            handler = (InputHandler)ClasspathUtils.newInstance((String)this.args.inputHandlerClassname, (ClassLoader)Main.class.getClassLoader(), InputHandler.class);
            project.setProjectReference((Object)handler);
        }
        project.setInputHandler((InputHandler)handler);
    }

    private BuildLogger createLogger() {
        BuildLogger logger;
        if (this.args.loggerClassname != null) {
            try {
                logger = (BuildLogger)ClasspathUtils.newInstance((String)this.args.loggerClassname, (ClassLoader)Main.class.getClassLoader(), BuildLogger.class);
            }
            catch (BuildException e) {
                this.printErrorMessage("The specified logger class " + this.args.loggerClassname + " could not be used because " + e.getMessage(), e);
                throw new RuntimeException();
            }
        } else if (Configuration.configuration.getOrDefault("cli.log-format", "legacy").equals("legacy")) {
            logger = new org.apache.tools.ant.DefaultLogger();
        } else {
            logger = new DefaultLogger();
            ((DefaultLogger)logger).useColor(this.args.useColor);
        }
        logger.setMessageOutputLevel(this.args.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.args.emacsMode);
        return logger;
    }

    private void printVersion() throws BuildException {
        this.logger.setOutputLevel(2);
        this.logger.info(locale.getString("version").formatted(Configuration.configuration.get("otversion")));
    }
}

