/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.xmlgraphics;

import java.io.IOException;
import java.util.Map;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;

public class ImageLoaderMathML
extends AbstractImageLoader {
    private final ImageFlavor targetFlavor;

    public ImageLoaderMathML(ImageFlavor imageFlavor) {
        if (!ImageFlavor.XML_DOM.equals((Object)imageFlavor)) {
            throw new IllegalArgumentException("Unsupported target ImageFlavor: " + imageFlavor);
        }
        this.targetFlavor = imageFlavor;
    }

    public ImageFlavor getTargetFlavor() {
        return this.targetFlavor;
    }

    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        if (!"application/mathml+xml".equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from an MathML image");
        }
        Image image = imageInfo.getOriginalImage();
        if (!(image instanceof ImageXMLDOM)) {
            throw new IllegalArgumentException("ImageInfo was expected to contain the MathML document as DOM");
        }
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        if (!"http://www.w3.org/1998/Math/MathML".equals(imageXMLDOM.getRootNamespace())) {
            throw new IllegalArgumentException("The Image is not in the MathML namespace: " + imageXMLDOM.getRootNamespace());
        }
        return imageXMLDOM;
    }
}

