/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.zendesk.client.v2.model.Collaborator;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SearchResultEntity;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Ticket
extends Request
implements SearchResultEntity {
    private static final long serialVersionUID = -7559199410302237012L;
    private String externalId;
    private String recipient;
    private Long submitterId;
    private Long assigneeId;
    private Long groupId;
    private List<Long> collaboratorIds;
    private List<Collaborator> collaborators;
    private Long forumTopicId;
    private Long problemId;
    private boolean hasIncidents;
    private Date dueAt;
    private List<String> tags;
    private SatisfactionRating satisfactionRating;
    private List<Long> sharingAgreementIds;
    private List<Long> followupIds;
    private Long ticketFormId;
    private Long brandId;
    private Boolean isPublic;
    private Boolean safeUpdate;

    public Ticket() {
    }

    public Ticket(Requester requester, String subject, Comment comment) {
        this.subject = subject;
        this.requester = requester;
        this.comment = comment;
    }

    public Ticket(long requesterId, String subject, Comment comment) {
        this.subject = subject;
        this.requesterId = requesterId;
        this.comment = comment;
    }

    @JsonProperty(value="assignee_id")
    public Long getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
    }

    @JsonProperty(value="collaborator_ids")
    public List<Long> getCollaboratorIds() {
        return this.collaboratorIds;
    }

    public void setCollaboratorIds(List<Long> collaboratorIds) {
        this.collaboratorIds = collaboratorIds;
    }

    @JsonProperty(value="collaborators")
    private List<Collaborator> getCollaborators() {
        return this.collaborators;
    }

    public void setCollaborators(List<Collaborator> collaborators) {
        this.collaborators = collaborators;
    }

    @JsonProperty(value="due_at")
    public Date getDueAt() {
        return this.dueAt;
    }

    public void setDueAt(Date dueAt) {
        this.dueAt = dueAt;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @JsonProperty(value="followup_ids")
    public List<Long> getFollowupIds() {
        return this.followupIds;
    }

    public void setFollowupIds(List<Long> followupIds) {
        this.followupIds = followupIds;
    }

    @JsonProperty(value="forum_topic_id")
    public Long getForumTopicId() {
        return this.forumTopicId;
    }

    public void setForumTopicId(Long forumTopicId) {
        this.forumTopicId = forumTopicId;
    }

    @JsonProperty(value="group_id")
    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @JsonProperty(value="has_incidents")
    public boolean isHasIncidents() {
        return this.hasIncidents;
    }

    public void setHasIncidents(boolean hasIncidents) {
        this.hasIncidents = hasIncidents;
    }

    @JsonProperty(value="problem_id")
    public Long getProblemId() {
        return this.problemId;
    }

    public void setProblemId(Long problemId) {
        this.problemId = problemId;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @JsonProperty(value="brand_id")
    public Long getBrandId() {
        return this.brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    @Override
    public Requester getRequester() {
        return this.requester;
    }

    @Override
    public void setRequester(Requester requester) {
        this.requester = requester;
        if (requester != null) {
            this.requesterId = null;
        }
    }

    @JsonProperty(value="satisfaction_rating")
    public SatisfactionRating getSatisfactionRating() {
        return this.satisfactionRating;
    }

    public void setSatisfactionRating(SatisfactionRating satisfactionRating) {
        this.satisfactionRating = satisfactionRating;
    }

    @JsonProperty(value="sharing_agreement_ids")
    public List<Long> getSharingAgreementIds() {
        return this.sharingAgreementIds;
    }

    public void setSharingAgreementIds(List<Long> sharingAgreementIds) {
        this.sharingAgreementIds = sharingAgreementIds;
    }

    @JsonProperty(value="submitter_id")
    public Long getSubmitterId() {
        return this.submitterId;
    }

    public void setSubmitterId(Long submitterId) {
        this.submitterId = submitterId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="ticket_form_id")
    public Long getTicketFormId() {
        return this.ticketFormId;
    }

    public void setTicketFormId(Long ticketFormId) {
        this.ticketFormId = ticketFormId;
    }

    @JsonProperty(value="is_public")
    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonProperty(value="safe_update")
    public Boolean getSafeUpdate() {
        return this.safeUpdate;
    }

    public void setSafeUpdate(Boolean safeUpdate) {
        this.safeUpdate = safeUpdate;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonProperty(value="updated_stamp")
    private Date getUpdatedStamp() {
        return Boolean.TRUE.equals(this.safeUpdate) ? this.updatedAt : null;
    }

    public String toString() {
        return "Ticket{assigneeId=" + this.assigneeId + ", id=" + this.id + ", url='" + this.url + "', externalId='" + this.externalId + "', type='" + this.type + "', subject='" + this.subject + "', description='" + this.description + "', priority='" + this.priority + "', status='" + this.status + "', recipient='" + this.recipient + "', requesterId=" + this.requesterId + ", submitterId=" + this.submitterId + ", organizationId=" + this.organizationId + ", groupId=" + this.groupId + ", collaboratorIds=" + this.collaboratorIds + ", forumTopicId=" + this.forumTopicId + ", problemId=" + this.problemId + ", hasIncidents=" + this.hasIncidents + ", dueAt=" + this.dueAt + ", tags=" + this.tags + ", via=" + this.via + ", customFields=" + this.customFields + ", satisfactionRating=" + this.satisfactionRating + ", sharingAgreementIds=" + this.sharingAgreementIds + ", followupIds=" + this.followupIds + ", ticketFormId=" + this.ticketFormId + ", brandId=" + this.brandId + ", isPublic=" + this.isPublic + ", safeUpdate=" + this.safeUpdate + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "}";
    }

    public static class Requester {
        private Integer localeId;
        private String name;
        private String email;

        public Requester() {
        }

        public Requester(String email) {
            this.email = email;
        }

        public Requester(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public Requester(Integer localeId, String name, String email) {
            this.localeId = localeId;
            this.name = name;
            this.email = email;
        }

        @JsonProperty(value="locale_id")
        public Integer getLocaleId() {
            return this.localeId;
        }

        public void setLocaleId(Integer localeId) {
            this.localeId = localeId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String toString() {
            return "Requester{localeId=" + this.localeId + ", name='" + this.name + "', email='" + this.email + "'}";
        }
    }
}

