/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.dita.dost.invoker.ArgumentParser;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.Main;
import org.dita.dost.invoker.UsageBuilder;

class ValidateArguments
extends Arguments {
    private static final Map<String, Arguments.Argument> ARGUMENTS = new HashMap<String, Arguments.Argument>();
    File projectFile;
    private final List<String> inputs = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();

    ValidateArguments() {
    }

    @Override
    ValidateArguments parse(String[] arguments) {
        String arg;
        this.msgOutputLevel = 1;
        ArrayDeque<String> args = new ArrayDeque<String>(Arrays.asList(arguments));
        while (!args.isEmpty()) {
            arg = (String)args.pop();
            if (arg.equals("validate")) {
                this.definedProps.put("transtype", "validate");
                break;
            }
            if (!arg.startsWith("-")) continue;
            this.parseCommonOptions(arg, args);
        }
        while (!args.isEmpty()) {
            arg = (String)args.pop();
            if (this.isLongForm(arg, "-project") || arg.equals("-p")) {
                this.handleArgProject(arg, args);
                continue;
            }
            if (this.isLongForm(arg, "-input") || arg.equals("-i")) {
                this.handleArgInput(arg, args, ARGUMENTS.get(this.getArgumentName(arg)));
                continue;
            }
            if (this.isLongForm(arg, "-context")) {
                this.handleContext(arg, args);
                continue;
            }
            if (this.isLongForm(arg, "-filter")) {
                this.handleArgFilter(arg, args, ARGUMENTS.get(this.getArgumentName(arg)));
                continue;
            }
            if (this.isLongForm(arg, "-resource") || arg.equals("-r")) {
                this.handleArgResource(arg, args, ARGUMENTS.get(this.getArgumentName(arg)));
                continue;
            }
            if (this.isLongForm(arg, "-verbose") || arg.equals("-v")) {
                this.msgOutputLevel = 2;
                continue;
            }
            if (this.isLongForm(arg, "-debug") || arg.equals("-d")) {
                this.msgOutputLevel = 3;
                continue;
            }
            if (ARGUMENTS.containsKey(this.getArgumentName(arg))) {
                this.definedProps.putAll(this.handleParameterArg(arg, args, ARGUMENTS.get(this.getArgumentName(arg))));
                continue;
            }
            if (ArgumentParser.getPluginArguments().containsKey(this.getArgumentName(arg))) {
                this.definedProps.putAll(this.handleParameterArg(arg, args, ArgumentParser.getPluginArguments().get(this.getArgumentName(arg))));
                continue;
            }
            this.parseCommonOptions(arg, args);
        }
        if (!this.inputs.isEmpty()) {
            this.definedProps.put("args.input", this.inputs.get(0));
        }
        if (!this.resources.isEmpty()) {
            this.definedProps.put("args.resources", String.join((CharSequence)File.pathSeparator, this.resources));
        }
        return this;
    }

    private Map<String, Object> handleParameterArg(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for property %s".formatted(entry.getKey()));
        }
        return ImmutableMap.of((Object)argument.property, (Object)argument.getValue(entry.getValue()));
    }

    private void handleContext(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException("Missing value for context %s".formatted(entry.getKey()));
        }
        this.definedProps.put(ValidateArguments.ARGUMENTS.get((Object)this.getArgumentName((String)arg)).property, entry.getValue());
    }

    private void handleArgInput(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException("Missing value for input " + entry.getKey());
        }
        this.inputs.add(argument.getValue(entry.getValue()));
    }

    private void handleArgFilter(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException("Missing value for input " + entry.getKey());
        }
        Object prev = this.definedProps.get(argument.property);
        String value = prev != null ? String.valueOf(prev) + File.pathSeparator + argument.getValue(entry.getValue()) : argument.getValue(entry.getValue());
        this.definedProps.put(argument.property, value);
    }

    private void handleArgResource(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException("Missing value for resource " + entry.getKey());
        }
        this.resources.add(argument.getValue(entry.getValue()));
    }

    private void handleArgProject(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException("Missing value for project " + entry.getKey());
        }
        this.projectFile = new File(entry.getValue()).getAbsoluteFile();
    }

    @Override
    String getUsage(boolean compact) {
        return UsageBuilder.builder(compact, this.useColor).usage(Main.locale.getString("validate.usage")).arguments("i", "input", "file", Main.locale.getString("conversion.argument.input")).arguments("p", "project", "file", Main.locale.getString("conversion.argument.project")).options("r", "resource", "file", Main.locale.getString("conversion.option.resource")).options(null, "filter", "files", Main.locale.getString("conversion.option.filter")).build();
    }

    static {
        ARGUMENTS.put("-i", new Arguments.FileOrUriArgument("args.input", null));
        ARGUMENTS.put("--input", new Arguments.FileOrUriArgument("args.input", null));
        ARGUMENTS.put("-r", new Arguments.FileOrUriArgument("args.resources", null));
        ARGUMENTS.put("--resource", new Arguments.FileOrUriArgument("args.resources", null));
        ARGUMENTS.put("--filter", new Arguments.AbsoluteFileListArgument("args.filter", null));
        ARGUMENTS.put("-t", new Arguments.AbsoluteFileArgument("dita.temp.dir", null));
        ARGUMENTS.put("--temp", new Arguments.AbsoluteFileArgument("dita.temp.dir", null));
        ARGUMENTS.put("-p", new Arguments.AbsoluteFileArgument("project.file", null));
        ARGUMENTS.put("--project", new Arguments.AbsoluteFileArgument("project.file", null));
        ARGUMENTS.put("--context", new Arguments.AbsoluteFileArgument("project.context", null));
        for (Map.Entry<String, Arguments.Argument> e : new HashSet<Map.Entry<String, Arguments.Argument>>(ARGUMENTS.entrySet())) {
            if (!e.getKey().startsWith("--")) continue;
            ARGUMENTS.put(e.getKey().substring(1), e.getValue());
        }
    }
}

