/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.NativeTextPainter;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextUtil;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.svg.font.FOPGVTGlyphVector;

class PDFTextPainter
extends NativeTextPainter {
    private PDFGraphics2D pdf;
    private PDFTextUtil textUtil;
    private double prevVisibleGlyphWidth;
    private boolean repositionNextGlyph;
    private static int[] paZero = new int[4];

    public PDFTextPainter(FontInfo fontInfo) {
        super(fontInfo);
    }

    @Override
    protected boolean isSupported(Graphics2D graphics2D) {
        return graphics2D instanceof PDFGraphics2D;
    }

    @Override
    protected void preparePainting(Graphics2D graphics2D) {
        this.pdf = (PDFGraphics2D)((Object)graphics2D);
    }

    @Override
    protected void saveGraphicsState() {
        this.pdf.saveGraphicsState();
    }

    @Override
    protected void restoreGraphicsState() {
        this.pdf.restoreGraphicsState();
    }

    @Override
    protected void setInitialTransform(AffineTransform affineTransform) {
        this.createTextUtil();
        this.textUtil.concatMatrix(affineTransform);
    }

    private void createTextUtil() {
        this.textUtil = new PDFTextUtil(this.pdf.fontInfo){

            protected void write(String string) {
                PDFTextPainter.this.pdf.currentStream.write(string);
            }

            protected void write(StringBuffer stringBuffer) {
                PDFTextPainter.this.pdf.currentStream.append(stringBuffer);
            }
        };
    }

    @Override
    protected void clip(Shape shape) {
        this.pdf.writeClip(shape);
    }

    @Override
    protected void writeGlyphs(FOPGVTGlyphVector fOPGVTGlyphVector, GeneralPath generalPath) throws IOException {
        if (fOPGVTGlyphVector.getGlyphPositionAdjustments() == null) {
            super.writeGlyphs(fOPGVTGlyphVector, generalPath);
        } else {
            FOPGVTFont fOPGVTFont = (FOPGVTFont)fOPGVTGlyphVector.getFont();
            String string = fOPGVTFont.getFontKey();
            Font font = fOPGVTFont.getFont();
            Point2D point2D = fOPGVTGlyphVector.getGlyphPosition(0);
            boolean bl = font.isMultiByte();
            boolean bl2 = this.textUtil.isCIDFont(font.getFontName());
            if (bl || bl2) {
                int n2 = font.getFontSize();
                float f2 = (float)n2 / 1000.0f;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                this.textUtil.writeTextMatrix(new AffineTransform(1.0, 0.0, 0.0, -1.0, point2D.getX(), point2D.getY()));
                this.textUtil.updateTf(string, (double)f2, bl, bl2);
                int[][] nArray = fOPGVTGlyphVector.getGlyphPositionAdjustments();
                int n3 = fOPGVTGlyphVector.getNumGlyphs();
                for (int i2 = 0; i2 < n3; ++i2) {
                    int[] nArray2;
                    int n4 = fOPGVTGlyphVector.getGlyphCode(i2);
                    int[] nArray3 = nArray2 = i2 > nArray.length || nArray[i2] == null ? paZero : nArray[i2];
                    if (fOPGVTGlyphVector.getGlyphPosition(i2) != null) {
                        Point2D point2D2 = fOPGVTGlyphVector.getGlyphPosition(i2);
                        double d6 = point2D2.getX() - point2D.getX();
                        double d7 = -(point2D2.getY() - point2D.getY());
                        double d8 = d6 - d4;
                        double d9 = d7 - d5;
                        this.textUtil.writeTd(d8, d9);
                        this.textUtil.writeTj((int)((char)n4), bl, bl2);
                        d2 = d6 + (double)nArray2[2];
                        d3 = d7 + (double)nArray2[3];
                        d4 = d6;
                        d5 = d7;
                        continue;
                    }
                    double d10 = d2 + (double)nArray2[0];
                    double d11 = d3 + (double)nArray2[1];
                    double d12 = font.getWidth(n4);
                    double d13 = 0.0;
                    double d14 = (d10 - d4) / 1000.0;
                    double d15 = (d11 - d5) / 1000.0;
                    this.textUtil.writeTd(d14, d15);
                    this.textUtil.writeTj((int)((char)n4), bl, bl2);
                    d2 += d12 + (double)nArray2[2];
                    d3 += d13 + (double)nArray2[3];
                    d4 = d10;
                    d5 = d11;
                }
            }
        }
    }

    @Override
    protected void beginTextObject() {
        this.applyColorAndPaint(this.tpi);
        this.textUtil.beginTextObject();
        boolean bl = this.tpi.strokePaint != null && this.tpi.strokeStroke != null;
        this.textUtil.setTextRenderingMode(this.tpi.fillPaint != null, bl, false);
    }

    @Override
    protected void endTextObject() {
        this.textUtil.writeTJ();
        this.textUtil.endTextObject();
    }

    private void applyColorAndPaint(TextPaintInfo textPaintInfo) {
        Color color;
        Paint paint = textPaintInfo.fillPaint;
        Paint paint2 = textPaintInfo.strokePaint;
        Stroke stroke = textPaintInfo.strokeStroke;
        int n2 = 255;
        int n3 = 255;
        if (paint instanceof Color) {
            color = (Color)paint;
            this.pdf.applyColor(color, true);
            n2 = color.getAlpha();
        }
        if (paint2 instanceof Color) {
            color = (Color)paint2;
            this.pdf.applyColor(color, false);
            n3 = color.getAlpha();
        }
        this.pdf.applyPaint(paint, true);
        this.pdf.applyStroke(stroke);
        if (paint2 != null) {
            this.pdf.applyPaint(paint2, false);
        }
        this.pdf.applyAlpha(n2, n3);
    }

    @Override
    protected void positionGlyph(Point2D point2D, Point2D point2D2, boolean bl) {
        double d2;
        double d3;
        double d4;
        boolean bl2 = this.repositionNextGlyph = point2D == null || point2D.getY() != point2D2.getY() || bl;
        if (!this.repositionNextGlyph && (d4 = 1000.0 * (d3 = point2D2.getX() - point2D.getX()) - (d2 = this.prevVisibleGlyphWidth)) != 0.0) {
            double d5 = -d4 / (double)this.font.getFontSize();
            this.textUtil.adjustGlyphTJ(d5 * 1000.0);
        }
    }

    @Override
    protected void writeGlyph(char c2, AffineTransform affineTransform) {
        this.prevVisibleGlyphWidth = this.font.getWidth(c2);
        boolean bl = false;
        if (!this.textUtil.isMultiByteFont(this.font.getFontName())) {
            int n2 = c2 / 256;
            c2 = (char)(c2 % 256);
            if (this.textUtil.getCurrentEncoding() != n2) {
                this.textUtil.setCurrentEncoding(n2);
                bl = true;
            }
        }
        if (this.repositionNextGlyph || bl) {
            this.textUtil.writeTJ();
            if (this.font != this.textUtil.getCurrentFont() || bl) {
                this.textUtil.setCurrentFont(this.font);
                this.textUtil.writeTf(this.font);
            }
            this.textUtil.writeTextMatrix(affineTransform);
        }
        this.textUtil.writeTJMappedChar(c2);
    }
}

