/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.GlyphLayout;
import org.apache.batik.bridge.SVGGVTFont;
import org.apache.batik.bridge.StrokingTextPainter;
import org.apache.batik.bridge.TextLayoutFactory;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.svg.font.FOPGVTGlyphVector;
import org.apache.fop.svg.text.BidiAttributedCharacterIterator;
import org.apache.fop.util.CharUtilities;

public abstract class NativeTextPainter
extends StrokingTextPainter {
    protected static final Log log = LogFactory.getLog(NativeTextPainter.class);
    private static final boolean DEBUG = false;
    protected final FontInfo fontInfo;
    protected final FontFamilyResolver fontFamilyResolver;
    protected Font font;
    protected TextPaintInfo tpi;
    private static final TextLayoutFactory COMPLEX_SCRIPT_TEXT_LAYOUT_FACTORY = new TextLayoutFactory(){

        public TextSpanLayout createTextLayout(AttributedCharacterIterator attributedCharacterIterator, int[] nArray, Point2D point2D, FontRenderContext fontRenderContext) {
            return new GlyphLayout(attributedCharacterIterator, nArray, point2D, fontRenderContext);
        }
    };

    public NativeTextPainter(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
        this.fontFamilyResolver = new FOPFontFamilyResolverImpl(fontInfo);
    }

    protected abstract boolean isSupported(Graphics2D var1);

    protected final void paintTextRun(StrokingTextPainter.TextRun textRun, Graphics2D graphics2D) throws IOException {
        TextSpanLayout textSpanLayout;
        GVTGlyphVector gVTGlyphVector;
        this.logTextRun(textRun);
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        this.tpi = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.tpi == null || !this.tpi.visible) {
            return;
        }
        if (this.tpi.composite != null) {
            graphics2D.setComposite(this.tpi.composite);
        }
        if (!((gVTGlyphVector = (textSpanLayout = textRun.getLayout()).getGlyphVector()).getFont() instanceof FOPGVTFont)) {
            assert (gVTGlyphVector.getFont() == null || gVTGlyphVector.getFont() instanceof SVGGVTFont);
            textRun.getLayout().draw(graphics2D);
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        this.preparePainting(graphics2D);
        this.saveGraphicsState();
        this.setInitialTransform(graphics2D.getTransform());
        this.clip(graphics2D.getClip());
        this.beginTextObject();
        this.writeGlyphs((FOPGVTGlyphVector)gVTGlyphVector, generalPath);
        this.endTextObject();
        this.restoreGraphicsState();
    }

    protected void writeGlyphs(FOPGVTGlyphVector fOPGVTGlyphVector, GeneralPath generalPath) throws IOException {
        AffineTransform affineTransform = new AffineTransform();
        Point2D point2D = null;
        AffineTransform affineTransform2 = null;
        this.font = ((FOPGVTFont)fOPGVTGlyphVector.getFont()).getFont();
        int n2 = fOPGVTGlyphVector.getNumGlyphs();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!fOPGVTGlyphVector.isGlyphVisible(i2)) continue;
            Point2D point2D2 = fOPGVTGlyphVector.getGlyphPosition(i2);
            AffineTransform affineTransform3 = fOPGVTGlyphVector.getGlyphTransform(i2);
            if (log.isTraceEnabled()) {
                log.trace((Object)("pos " + point2D2 + ", transform " + affineTransform3));
            }
            affineTransform.setToIdentity();
            affineTransform.translate(point2D2.getX(), point2D2.getY());
            if (affineTransform3 != null) {
                affineTransform.concatenate(affineTransform3);
            }
            affineTransform.scale(1.0, -1.0);
            this.positionGlyph(point2D, point2D2, affineTransform3 != null || affineTransform2 != null);
            char c2 = (char)fOPGVTGlyphVector.getGlyphCode(i2);
            point2D = point2D2;
            affineTransform2 = affineTransform3;
            this.writeGlyph(c2, affineTransform);
        }
    }

    protected void paintTextRuns(List list, Graphics2D graphics2D) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("paintTextRuns: count = " + list.size()));
        }
        if (!this.isSupported(graphics2D)) {
            super.paintTextRuns(list, graphics2D);
            return;
        }
        for (Object e2 : list) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
            try {
                this.paintTextRun(textRun, graphics2D);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected CharSequence collectCharacters(AttributedCharacterIterator attributedCharacterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.first();
        while (attributedCharacterIterator.getIndex() < attributedCharacterIterator.getEndIndex()) {
            stringBuffer.append(attributedCharacterIterator.current());
            attributedCharacterIterator.next();
        }
        return stringBuffer;
    }

    public List computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        attributedCharacterIterator.first();
        int n2 = ((Integer)attributedCharacterIterator.getAttribute(WRITING_MODE)).intValue() == WRITING_MODE_RTL.intValue() ? 1 : 0;
        int n3 = attributedCharacterIteratorArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            attributedCharacterIteratorArray[i2] = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[i2], n2);
        }
        return super.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray, null);
    }

    protected Set getTextRunBoundaryAttributes() {
        Set set = super.getTextRunBoundaryAttributes();
        if (!set.contains(BIDI_LEVEL)) {
            set.add(BIDI_LEVEL);
        }
        return set;
    }

    protected List reorderTextRuns(StrokingTextPainter.TextChunk textChunk, List list) {
        int n2 = -1;
        int n3 = -1;
        for (StrokingTextPainter.TextRun textRun : list) {
            int n4 = textRun.getBidiLevel();
            if (n4 < 0) continue;
            if (n2 < 0 || n4 < n2) {
                n2 = n4;
            }
            if (n3 >= 0 && n4 <= n3) continue;
            n3 = n4;
        }
        if (n3 > 0) {
            int n5;
            int n6 = n5 = (n2 & 1) == 0 ? n2 + 1 : n2;
            for (int i2 = n3; i2 >= n5; --i2) {
                list = this.reorderRuns(list, i2);
            }
        }
        boolean bl = true;
        this.reverseGlyphs(list, bl);
        return list;
    }

    private List reorderRuns(List arrayList, int n2) {
        assert (n2 >= 0);
        ArrayList<StrokingTextPainter.TextRun> arrayList2 = new ArrayList<StrokingTextPainter.TextRun>();
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            StrokingTextPainter.TextRun textRun;
            int n5;
            StrokingTextPainter.TextRun textRun2 = (StrokingTextPainter.TextRun)arrayList.get(i2);
            if (textRun2.getBidiLevel() < n2) {
                arrayList2.add(textRun2);
                continue;
            }
            for (n5 = n4 = i2; n5 < n3 && (textRun = (StrokingTextPainter.TextRun)arrayList.get(n5)).getBidiLevel() >= n2; ++n5) {
            }
            if (n4 < n5) {
                arrayList2.addAll(this.reverseRuns(arrayList, n4, n5));
            }
            i2 = n5 - 1;
        }
        if (!arrayList2.equals(arrayList)) {
            arrayList = arrayList2;
        }
        return arrayList;
    }

    private List reverseRuns(List list, int n2, int n3) {
        int n4 = n3 - n2;
        ArrayList<StrokingTextPainter.TextRun> arrayList = new ArrayList<StrokingTextPainter.TextRun>(n4);
        if (n4 > 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n4 - i2 - 1;
                StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n2 + n5);
                textRun.reverse();
                arrayList.add(textRun);
            }
        }
        return arrayList;
    }

    private void reverseGlyphs(List list, boolean bl) {
        for (StrokingTextPainter.TextRun textRun : list) {
            textRun.maybeReverseGlyphs(bl);
        }
    }

    protected abstract void preparePainting(Graphics2D var1);

    protected abstract void saveGraphicsState() throws IOException;

    protected abstract void restoreGraphicsState() throws IOException;

    protected abstract void setInitialTransform(AffineTransform var1) throws IOException;

    protected abstract void clip(Shape var1) throws IOException;

    protected abstract void beginTextObject() throws IOException;

    protected abstract void endTextObject() throws IOException;

    protected abstract void positionGlyph(Point2D var1, Point2D var2, boolean var3);

    protected abstract void writeGlyph(char var1, AffineTransform var2) throws IOException;

    protected final void logTextRun(StrokingTextPainter.TextRun textRun) {
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        TextSpanLayout textSpanLayout = textRun.getLayout();
        attributedCharacterIterator.first();
        if (log.isTraceEnabled()) {
            int n2 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
            log.trace((Object)"================================================");
            log.trace((Object)"New text run:");
            log.trace((Object)("char count: " + n2));
            log.trace((Object)("range: " + attributedCharacterIterator.getBeginIndex() + " - " + attributedCharacterIterator.getEndIndex()));
            log.trace((Object)("glyph count: " + textSpanLayout.getGlyphCount()));
        }
    }

    protected final void logCharacter(char c2, TextSpanLayout textSpanLayout, int n2, boolean bl) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("glyph " + n2 + " -> " + textSpanLayout.getGlyphIndex(n2) + " => " + c2));
            if (CharUtilities.isAnySpace((int)c2) && c2 != ' ') {
                log.trace((Object)("Space found: " + Integer.toHexString(c2)));
            } else if (c2 == '\u200d') {
                log.trace((Object)("ZWJ found: " + Integer.toHexString(c2)));
            } else if (c2 == '\u00ad') {
                log.trace((Object)("Soft hyphen found: " + Integer.toHexString(c2)));
            }
            if (!bl) {
                log.trace((Object)("Invisible glyph found: " + Integer.toHexString(c2)));
            }
        }
    }

    protected FontFamilyResolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    protected TextLayoutFactory getTextLayoutFactory() {
        return COMPLEX_SCRIPT_TEXT_LAYOUT_FACTORY;
    }
}

