/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlock;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.xml.AbstractXMLRenderer;
import org.apache.fop.render.xml.XMLXMLHandler;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLRenderer
extends AbstractXMLRenderer {
    public static final String VERSION = "2.0";
    public static final String XML_MIME_TYPE = "application/X-fop-areatree";
    private boolean startedSequence;
    private boolean compactFormat;
    protected Renderer mimic;

    public XMLRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        this.context = new RendererContext((AbstractRenderer)((Object)this), XML_MIME_TYPE);
        XMLXMLHandler xMLXMLHandler = new XMLXMLHandler();
        fOUserAgent.getXMLHandlerRegistry().addXMLHandler((XMLHandler)xMLXMLHandler);
        Boolean bl = (Boolean)fOUserAgent.getRendererOptions().get("compact-format");
        if (bl != null) {
            this.setCompactFormat(bl);
        }
    }

    public void mimicRenderer(Renderer renderer) {
        this.mimic = renderer;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        if (this.mimic != null) {
            this.mimic.setupFontInfo(fontInfo);
        } else {
            super.setupFontInfo(fontInfo);
        }
    }

    public void setCompactFormat(boolean bl) {
        this.compactFormat = bl;
    }

    private boolean isDetailedFormat() {
        return !this.compactFormat;
    }

    protected void addAreaAttributes(Area area) {
        this.addAttribute("ipd", area.getIPD());
        this.addAttribute("bpd", area.getBPD());
        this.maybeAddLevelAttribute(area);
        if (this.isDetailedFormat()) {
            if (area.getIPD() != 0) {
                this.addAttribute("ipda", area.getAllocIPD());
            }
            if (area.getBPD() != 0) {
                this.addAttribute("bpda", area.getAllocBPD());
            }
            this.addAttribute("bap", area.getBorderAndPaddingWidthStart() + " " + area.getBorderAndPaddingWidthEnd() + " " + area.getBorderAndPaddingWidthBefore() + " " + area.getBorderAndPaddingWidthAfter());
        }
    }

    protected void addTraitAttributes(Area area) {
        Map map = area.getTraits();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Object k2 = entry2.getKey();
                String string = Trait.getTraitName(k2);
                Class clazz = Trait.getTraitClass(k2);
                if ("break-before".equals(string) || "break-after".equals(string)) continue;
                Object v2 = entry2.getValue();
                if (((Integer)k2).intValue() == Trait.FONT.intValue()) {
                    object = (FontTriplet)v2;
                    this.addAttribute("font-name", object.getName());
                    this.addAttribute("font-style", object.getStyle());
                    this.addAttribute("font-weight", object.getWeight());
                    continue;
                }
                if (clazz.equals(Trait.InternalLink.class)) {
                    object = (Trait.InternalLink)v2;
                    this.addAttribute(string, object.xmlAttribute());
                    continue;
                }
                if (clazz.equals(Trait.Background.class)) {
                    String string2;
                    object = (Trait.Background)v2;
                    this.addAttribute(string, object.toString());
                    if (object.getColor() != null) {
                        this.addAttribute("bkg-color", ColorUtil.colorToString(object.getColor()));
                    }
                    if (object.getURL() == null) continue;
                    this.addAttribute("bkg-img", object.getURL());
                    int n2 = object.getRepeat();
                    switch (n2) {
                        case 112: {
                            string2 = "repeat";
                            break;
                        }
                        case 113: {
                            string2 = "repeat-x";
                            break;
                        }
                        case 114: {
                            string2 = "repeat-y";
                            break;
                        }
                        case 96: {
                            string2 = "no-repeat";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal value for repeat encountered: " + n2);
                        }
                    }
                    this.addAttribute("bkg-repeat", string2);
                    this.addAttribute("bkg-horz-offset", object.getHoriz());
                    this.addAttribute("bkg-vert-offset", object.getVertical());
                    continue;
                }
                if (clazz.equals(Color.class)) {
                    object = (Color)v2;
                    this.addAttribute(string, ColorUtil.colorToString((Color)object));
                    continue;
                }
                if (((Integer)k2).intValue() == Trait.START_INDENT.intValue() || ((Integer)k2).intValue() == Trait.END_INDENT.intValue()) {
                    if ((Integer)v2 == 0) continue;
                    this.addAttribute(string, v2.toString());
                    continue;
                }
                this.addAttribute(string, v2.toString());
            }
        }
        this.transferForeignObjects((AreaTreeObject)area);
    }

    private void transferForeignObjects(AreaTreeObject areaTreeObject) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : areaTreeObject.getForeignAttributes().entrySet()) {
            object = (QName)entry.getKey();
            hashMap.put(object.getPrefix(), object.getNamespaceURI());
            this.addAttribute((QName)object, (String)entry.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = "xmlns:" + entry.getKey();
            this.atts.addAttribute("http://www.w3.org/2000/xmlns/", (String)entry.getKey(), (String)object, "CDATA", (String)entry.getValue());
        }
    }

    public void processOffDocumentItem(OffDocumentItem offDocumentItem) {
        if (offDocumentItem instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)offDocumentItem);
        } else if (offDocumentItem instanceof DestinationData) {
            this.renderDestination((DestinationData)offDocumentItem);
        } else if (offDocumentItem instanceof OffDocumentExtensionAttachment) {
            ExtensionAttachment extensionAttachment = ((OffDocumentExtensionAttachment)offDocumentItem).getAttachment();
            if (this.extensionAttachments == null) {
                this.extensionAttachments = new ArrayList();
            }
            this.extensionAttachments.add(extensionAttachment);
        } else {
            String string = "Ignoring OffDocumentItem: " + offDocumentItem;
            log.warn((Object)string);
        }
    }

    protected void renderBookmarkTree(BookmarkData bookmarkData) {
        if (bookmarkData.getWhenToProcess() == 2) {
            this.endPageSequence();
        }
        this.startElement("bookmarkTree");
        for (int i2 = 0; i2 < bookmarkData.getCount(); ++i2) {
            this.renderBookmarkItem(bookmarkData.getSubData(i2));
        }
        this.endElement("bookmarkTree");
    }

    private void renderBookmarkItem(BookmarkData bookmarkData) {
        this.atts.clear();
        this.addAttribute("title", bookmarkData.getBookmarkTitle());
        this.addAttribute("show-children", String.valueOf(bookmarkData.showChildItems()));
        PageViewport pageViewport = bookmarkData.getPageViewport();
        String string = pageViewport == null ? null : pageViewport.getKey();
        this.addAttribute("internal-link", Trait.InternalLink.makeXMLAttribute((String)string, (String)bookmarkData.getIDRef()));
        this.startElement("bookmark", this.atts);
        for (int i2 = 0; i2 < bookmarkData.getCount(); ++i2) {
            this.renderBookmarkItem(bookmarkData.getSubData(i2));
        }
        this.endElement("bookmark");
    }

    protected void renderDestination(DestinationData destinationData) {
        if (destinationData.getWhenToProcess() == 2) {
            this.endPageSequence();
        }
        this.atts.clear();
        PageViewport pageViewport = destinationData.getPageViewport();
        String string = pageViewport == null ? null : pageViewport.getKey();
        this.addAttribute("internal-link", Trait.InternalLink.makeXMLAttribute((String)string, (String)destinationData.getIDRef()));
        this.startElement("destination", this.atts);
        this.endElement("destination");
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.debug((Object)"Rendering areas to Area Tree XML");
        if (this.handler == null) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            try {
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
                this.handler = transformerHandler;
                StreamResult streamResult = new StreamResult(outputStream);
                transformerHandler.setResult(streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(transformerConfigurationException.getMessage());
            }
            this.out = outputStream;
        }
        try {
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        if (this.userAgent.getProducer() != null) {
            this.comment("Produced by " + this.userAgent.getProducer());
        }
        this.atts.clear();
        this.addAttribute("version", VERSION);
        this.startElement("areaTree", this.atts);
    }

    public void stopRenderer() throws IOException {
        this.endPageSequence();
        this.endElement("areaTree");
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        if (this.out != null) {
            this.out.flush();
        }
        log.debug((Object)"Written out Area Tree XML");
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        this.atts.clear();
        this.addAttribute("bounds", pageViewport.getViewArea());
        this.addAttribute("key", pageViewport.getKey());
        this.addAttribute("nr", pageViewport.getPageNumber());
        this.addAttribute("formatted-nr", pageViewport.getPageNumberString());
        if (pageViewport.getSimplePageMasterName() != null) {
            this.addAttribute("simple-page-master-name", pageViewport.getSimplePageMasterName());
        }
        if (pageViewport.isBlank()) {
            this.addAttribute("blank", "true");
        }
        this.transferForeignObjects((AreaTreeObject)pageViewport);
        this.startElement("pageViewport", this.atts);
        this.startElement("page");
        this.handlePageExtensionAttachments(pageViewport);
        super.renderPage(pageViewport);
        this.endElement("page");
        this.endElement("pageViewport");
    }

    protected void handleExtensionAttachments(List list) {
        if (list != null && list.size() > 0) {
            this.startElement("extension-attachments");
            for (Object e2 : list) {
                ExtensionAttachment extensionAttachment = (ExtensionAttachment)e2;
                if (extensionAttachment instanceof XMLizable) {
                    try {
                        ((XMLizable)extensionAttachment).toSAX(this.handler);
                    }
                    catch (SAXException sAXException) {
                        log.error((Object)"Error while serializing Extension Attachment", (Throwable)sAXException);
                    }
                    continue;
                }
                String string = "Ignoring non-XMLizable ExtensionAttachment: " + extensionAttachment;
                log.warn((Object)string);
            }
            this.endElement("extension-attachments");
        }
    }

    public void startPageSequence(PageSequence pageSequence) {
        this.handleDocumentExtensionAttachments();
        this.endPageSequence();
        this.startedSequence = true;
        this.atts.clear();
        Locale locale = pageSequence.getLocale();
        if (locale != null) {
            this.addAttribute(new QName("http://www.w3.org/XML/1998/namespace", "xml:lang"), LanguageTags.toLanguageTag((Locale)locale));
        }
        this.transferForeignObjects((AreaTreeObject)pageSequence);
        this.startElement("pageSequence", this.atts);
        this.handleExtensionAttachments(pageSequence.getExtensionAttachments());
        LineArea lineArea = pageSequence.getTitle();
        if (lineArea != null) {
            this.startElement("title");
            List list = lineArea.getInlineAreas();
            for (Object e2 : list) {
                InlineArea inlineArea = (InlineArea)((Object)e2);
                this.renderInlineArea(inlineArea);
            }
            this.endElement("title");
        }
    }

    public void endPageSequence() {
        if (this.startedSequence) {
            this.endElement("pageSequence");
        }
        this.startedSequence = false;
    }

    protected void renderRegionViewport(RegionViewport regionViewport) {
        if (regionViewport != null) {
            this.atts.clear();
            this.addAreaAttributes((Area)regionViewport);
            this.addTraitAttributes((Area)regionViewport);
            this.addAttribute("rect", regionViewport.getViewArea());
            if (regionViewport.hasClip()) {
                this.addAttribute("clipped", "true");
            }
            this.startElement("regionViewport", this.atts);
            RegionReference regionReference = regionViewport.getRegionReference();
            this.atts.clear();
            this.addAreaAttributes((Area)regionReference);
            this.addTraitAttributes((Area)regionReference);
            this.addAttribute("name", regionReference.getRegionName());
            this.addAttribute("ctm", regionReference.getCTM().toString());
            if (regionReference.getRegionClass() == 57) {
                this.startElement("regionBefore", this.atts);
                this.renderRegion(regionReference);
                this.endElement("regionBefore");
            } else if (regionReference.getRegionClass() == 61) {
                this.startElement("regionStart", this.atts);
                this.renderRegion(regionReference);
                this.endElement("regionStart");
            } else if (regionReference.getRegionClass() == 58) {
                assert (regionReference instanceof BodyRegion);
                BodyRegion bodyRegion = (BodyRegion)regionReference;
                if (bodyRegion.getColumnCount() != 1) {
                    this.addAttribute("columnGap", bodyRegion.getColumnGap());
                    this.addAttribute("columnCount", bodyRegion.getColumnCount());
                }
                this.startElement("regionBody", this.atts);
                this.renderBodyRegion(bodyRegion);
                this.endElement("regionBody");
            } else if (regionReference.getRegionClass() == 59) {
                this.startElement("regionEnd", this.atts);
                this.renderRegion(regionReference);
                this.endElement("regionEnd");
            } else if (regionReference.getRegionClass() == 56) {
                this.startElement("regionAfter", this.atts);
                this.renderRegion(regionReference);
                this.endElement("regionAfter");
            }
            this.endElement("regionViewport");
        }
    }

    protected void startVParea(CTM cTM, Rectangle rectangle) {
    }

    protected void endVParea() {
    }

    protected void startLayer(String string) {
    }

    protected void endLayer() {
    }

    protected void renderInlineAreaBackAndBorders(InlineArea inlineArea) {
    }

    protected void renderBeforeFloat(BeforeFloat beforeFloat) {
        this.startElement("beforeFloat");
        super.renderBeforeFloat(beforeFloat);
        this.endElement("beforeFloat");
    }

    protected void renderFootnote(Footnote footnote) {
        this.atts.clear();
        this.addAttribute("top-offset", footnote.getTop());
        this.startElement("footnote", this.atts);
        super.renderFootnote(footnote);
        this.endElement("footnote");
    }

    protected void renderMainReference(MainReference mainReference) {
        this.atts.clear();
        this.addAreaAttributes((Area)mainReference);
        this.addTraitAttributes((Area)mainReference);
        if (mainReference.getColumnCount() != 1) {
            this.addAttribute("columnGap", mainReference.getColumnGap());
        }
        this.startElement("mainReference", this.atts);
        Span span = null;
        List list = mainReference.getSpans();
        for (Object e2 : list) {
            span = (Span)e2;
            this.atts.clear();
            if (span.getColumnCount() != 1) {
                this.addAttribute("columnCount", span.getColumnCount());
            }
            this.addAreaAttributes((Area)span);
            this.addTraitAttributes((Area)span);
            this.startElement("span", this.atts);
            for (int i2 = 0; i2 < span.getColumnCount(); ++i2) {
                NormalFlow normalFlow = span.getNormalFlow(i2);
                this.renderFlow(normalFlow);
            }
            this.endElement("span");
        }
        this.endElement("mainReference");
    }

    protected void renderFlow(NormalFlow normalFlow) {
        this.atts.clear();
        this.addAreaAttributes((Area)normalFlow);
        this.addTraitAttributes((Area)normalFlow);
        this.startElement("flow", this.atts);
        super.renderFlow(normalFlow);
        this.endElement("flow");
    }

    protected void renderReferenceArea(Block block) {
        this.handleBlockTraits(block);
        List list = block.getChildAreas();
        if (list != null) {
            this.renderBlocks(block, list);
        }
    }

    protected void renderBlock(Block block) {
        this.atts.clear();
        this.saveAreaCoordinatesRelativeToItsParent((Area)block);
        this.addAreaAttributes((Area)block);
        this.addTraitAttributes((Area)block);
        int n2 = block.getPositioning();
        if (block instanceof BlockViewport) {
            BlockViewport blockViewport = (BlockViewport)block;
            boolean bl = false;
            if (blockViewport.getPositioning() == 2 || blockViewport.getPositioning() == 3) {
                bl = true;
            }
            boolean bl2 = false;
            if (blockViewport.getPositioning() == 1) {
                bl2 = true;
            }
            if (bl) {
                if (block.getPositioning() == 2) {
                    Point point = this.getCoordinatesForFOReferenceAreaRelativeToCSSReferenceArea();
                    if (point != null) {
                        Point point2 = this.getAbsolutPointRelativeToFOReferenceArea((BlockViewport)block, point);
                        this.addAttribute("left-position", point2.x);
                        this.addAttribute("top-position", point2.y);
                    } else {
                        this.addAttribute("left-position", block.getXOffset());
                        this.addAttribute("top-position", block.getYOffset());
                    }
                } else {
                    this.addAttribute("left-position", block.getXOffset());
                    this.addAttribute("top-position", block.getYOffset());
                }
            }
            if (bl2) {
                if (block.getXOffset() != 0) {
                    this.addAttribute("left-position", block.getXOffset());
                }
                if (block.getYOffset() != 0) {
                    this.addAttribute("top-position", block.getYOffset());
                }
            }
            this.addAttribute("ctm", blockViewport.getCTM().toString());
            if (blockViewport.hasClip()) {
                this.addAttribute("clipped", "true");
            }
        } else {
            if (block.getXOffset() != 0) {
                this.addAttribute("left-offset", block.getXOffset());
            }
            if (block.getYOffset() != 0) {
                this.addAttribute("top-offset", block.getYOffset());
            }
        }
        switch (n2) {
            case 1: {
                this.addAttribute("positioning", "relative");
                break;
            }
            case 2: {
                this.addAttribute("positioning", "absolute");
                break;
            }
            case 3: {
                this.addAttribute("positioning", "fixed");
                break;
            }
        }
        this.startElement("block", this.atts);
        super.renderBlock(block);
        this.endElement("block");
        this.removeAreaCoordinatesRelativeToItsParent();
    }

    protected void renderInlineBlock(InlineBlock inlineBlock) {
        Block block = inlineBlock.getBlock();
        this.atts.clear();
        this.addAreaAttributes((Area)block);
        this.addTraitAttributes((Area)block);
        if (block.getXOffset() != 0) {
            this.addAttribute("left-offset", block.getXOffset());
        }
        if (block.getYOffset() != 0) {
            this.addAttribute("top-offset", block.getYOffset());
        }
        this.startElement("inlineblock", this.atts);
        if (block.getChildAreas() != null) {
            this.renderBlocks(null, block.getChildAreas());
        }
        this.endElement("inlineblock");
    }

    protected void renderLineArea(LineArea lineArea) {
        this.atts.clear();
        this.addAreaAttributes((Area)lineArea);
        this.addTraitAttributes((Area)lineArea);
        this.startElement("lineArea", this.atts);
        super.renderLineArea(lineArea);
        this.endElement("lineArea");
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        this.atts.clear();
        if (((Object)((Object)inlineArea)).getClass() == InlineArea.class) {
            this.addAreaAttributes(inlineArea);
            this.addTraitAttributes(inlineArea);
            this.startElement("inline", this.atts);
            this.endElement("inline");
        } else {
            super.renderInlineArea(inlineArea);
        }
    }

    protected void renderInlineViewport(InlineViewport inlineViewport) {
        this.atts.clear();
        this.addAreaAttributes((Area)inlineViewport);
        this.addTraitAttributes((Area)inlineViewport);
        this.addAttribute("offset", inlineViewport.getBlockProgressionOffset());
        this.addAttribute("pos", inlineViewport.getContentPosition());
        if (inlineViewport.hasClip()) {
            this.addAttribute("clip", "true");
        }
        this.startElement("viewport", this.atts);
        super.renderInlineViewport(inlineViewport);
        this.endElement("viewport");
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
        this.atts.clear();
        this.addAreaAttributes((Area)image);
        this.addTraitAttributes((Area)image);
        this.addAttribute("url", image.getURL());
        this.startElement("image", this.atts);
        this.endElement("image");
    }

    public void renderContainer(Container container) {
        this.startElement("container");
        super.renderContainer(container);
        this.endElement("container");
    }

    public void renderForeignObject(ForeignObject foreignObject, Rectangle2D rectangle2D) {
        this.atts.clear();
        this.addAreaAttributes((Area)foreignObject);
        this.addTraitAttributes((Area)foreignObject);
        String string = foreignObject.getNameSpace();
        this.addAttribute("ns", string);
        this.startElement("foreignObject", this.atts);
        Document document = foreignObject.getDocument();
        this.context.setProperty("handler", (Object)this.handler);
        this.renderXML(this.context, document, string);
        this.endElement("foreignObject");
    }

    protected void renderInlineSpace(Space space) {
        this.atts.clear();
        this.addAreaAttributes((Area)space);
        this.addTraitAttributes((Area)space);
        this.addAttribute("offset", space.getBlockProgressionOffset());
        this.startElement("space", this.atts);
        this.endElement("space");
    }

    protected void renderText(TextArea textArea) {
        this.atts.clear();
        if (textArea.getTextWordSpaceAdjust() != 0) {
            this.addAttribute("twsadjust", textArea.getTextWordSpaceAdjust());
        }
        if (textArea.getTextLetterSpaceAdjust() != 0) {
            this.addAttribute("tlsadjust", textArea.getTextLetterSpaceAdjust());
        }
        this.addAttribute("offset", textArea.getBlockProgressionOffset());
        this.addAttribute("baseline", textArea.getBaselineOffset());
        this.addAreaAttributes((Area)textArea);
        this.addTraitAttributes((Area)textArea);
        this.startElement("text", this.atts);
        super.renderText(textArea);
        this.endElement("text");
    }

    protected void renderWord(WordArea wordArea) {
        CharSequence charSequence;
        int[] nArray;
        this.atts.clear();
        int n2 = wordArea.getBlockProgressionOffset();
        if (n2 != 0) {
            this.addAttribute("offset", n2);
        }
        if ((nArray = wordArea.getLetterAdjustArray()) != null) {
            charSequence = new StringBuffer(64);
            boolean bl = false;
            int n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (i2 > 0) {
                    ((StringBuffer)charSequence).append(' ');
                }
                ((StringBuffer)charSequence).append(nArray[i2]);
                bl |= nArray[i2] != 0;
            }
            if (bl) {
                this.addAttribute("letter-adjust", ((StringBuffer)charSequence).toString());
            }
        }
        this.maybeAddLevelAttribute((Area)wordArea);
        this.maybeAddPositionAdjustAttribute(wordArea);
        charSequence = wordArea.getWord();
        this.maybeAddReversedAttribute(wordArea, (String)charSequence);
        this.startElement("word", this.atts);
        this.characters((String)charSequence);
        this.endElement("word");
        super.renderWord(wordArea);
    }

    protected void renderSpace(SpaceArea spaceArea) {
        this.atts.clear();
        int n2 = spaceArea.getBlockProgressionOffset();
        if (n2 != 0) {
            this.addAttribute("offset", n2);
        }
        this.maybeAddLevelAttribute((Area)spaceArea);
        if (!spaceArea.isAdjustable()) {
            this.addAttribute("adj", "false");
        }
        this.startElement("space", this.atts);
        this.characters(spaceArea.getSpace());
        this.endElement("space");
        super.renderSpace(spaceArea);
    }

    protected void renderInlineParent(InlineParent inlineParent) {
        this.atts.clear();
        this.addAreaAttributes((Area)inlineParent);
        this.addTraitAttributes((Area)inlineParent);
        this.addAttribute("offset", inlineParent.getBlockProgressionOffset());
        if (inlineParent.getPositioning() == 1) {
            this.addAttribute("positioning", "relative");
            if (inlineParent.getXOffset() != 0) {
                this.addAttribute("left-position", inlineParent.getXOffset());
            }
            if (inlineParent.getYOffset() != 0) {
                this.addAttribute("top-position", inlineParent.getYOffset());
            }
        }
        this.startElement("inlineparent", this.atts);
        super.renderInlineParent(inlineParent);
        this.endElement("inlineparent");
    }

    protected void renderInlineBlockParent(InlineBlockParent inlineBlockParent) {
        this.atts.clear();
        this.addAreaAttributes((Area)inlineBlockParent);
        this.addTraitAttributes((Area)inlineBlockParent);
        this.addAttribute("offset", inlineBlockParent.getBlockProgressionOffset());
        this.startElement("inlineblockparent", this.atts);
        super.renderInlineBlockParent(inlineBlockParent);
        this.endElement("inlineblockparent");
    }

    protected void renderLeader(Leader leader) {
        this.atts.clear();
        this.addAreaAttributes((Area)leader);
        this.addTraitAttributes((Area)leader);
        this.addAttribute("offset", leader.getBlockProgressionOffset());
        this.addAttribute("ruleStyle", leader.getRuleStyleAsString());
        this.addAttribute("ruleThickness", leader.getRuleThickness());
        this.startElement("leader", this.atts);
        this.endElement("leader");
        super.renderLeader(leader);
    }

    public String getMimeType() {
        return XML_MIME_TYPE;
    }

    private void maybeAddLevelAttribute(Area area) {
        int n2 = area.getBidiLevel();
        if (n2 >= 0) {
            this.addAttribute("level", n2);
        }
    }

    private void maybeAddPositionAdjustAttribute(WordArea wordArea) {
        int[][] nArray = wordArea.getGlyphPositionAdjustments();
        if (nArray != null) {
            this.addAttribute("position-adjust", XMLUtil.encodePositionAdjustments((int[][])nArray));
        }
    }

    private void maybeAddReversedAttribute(WordArea wordArea, String string) {
        if (wordArea.isReversed() && string.length() > 1) {
            this.addAttribute("reversed", "true");
        }
    }
}

