/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFVideoAnnot;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.AbstractPDFImageHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.render.pdf.VideoMP4ImageAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.VideoMP4Image;

public class PDFVideoHandlerMP4
extends AbstractPDFImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{new ImageFlavor("video/3gpp2"), new ImageFlavor("video/3gpp"), new ImageFlavor("video/mp4"), new ImageFlavor("video/x-m4v"), new ImageFlavor("video/quicktime")};

    public int getPriority() {
        return 100;
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        if (this.isCompatible(renderingContext, image)) {
            PDFRenderingContext pDFRenderingContext = (PDFRenderingContext)renderingContext;
            PDFPage pDFPage = pDFRenderingContext.getPage();
            VideoMP4ImageAdapter videoMP4ImageAdapter = (VideoMP4ImageAdapter)this.createPDFImage(image, image.getInfo().getOriginalURI());
            PDFVideoAnnot pDFVideoAnnot = new PDFVideoAnnot(pDFRenderingContext, videoMP4ImageAdapter, rectangle, pDFPage);
            pDFPage.addAnnotation((PDFObject)pDFVideoAnnot.createAnnot());
        }
    }

    PDFImage createPDFImage(Image image, String string) {
        return new VideoMP4ImageAdapter((VideoMP4Image)image, string);
    }

    public Class getSupportedImageClass() {
        return VideoMP4Image.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        return (image == null || image instanceof VideoMP4Image) && renderingContext instanceof PDFRenderingContext;
    }
}

